//
//	setuppnl.cc (ɻѹ/ѥͥɷ)
//
//	(C) Copyright 2001 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>

#include	"cval.h"
#include	"val.h"
#include	"dbox.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"setuppnl.h"


// ѿ
LOCAL	SETUPPNL*	pnl = NULL;	// panel ؿλ


// ؿץȥ
LOCAL	W	setuppnl_fn(W pnid, W ino, W val);


// ----------------------------------------------------------- class ؿ
//
// ѥͥɴؿ
//
LOCAL	W	setuppnl_fn(W pnid, W ino, W val)
{
	W	rv;

	rv = -1;
	switch (ino) {
#if	0				// ʤ
		case -2:		// 
			break;
		case -1:		// 
			break;
		case 0:			// 
			break;
#endif	// 0
		case SETUPPNL::STPIDX_MS_EXIT:	// [λ]
			pnl->get_setdat();
			rv = 0;
			break;
		case SETUPPNL::STPIDX_MS_SET:	// []
			pnl->get_setdat();
			rv = 1;
			break;
#if	0				// ʤ
		case SETUPPNL::STPIDX_SB_MIN:	// ʬ
			break;
		case SETUPPNL::STPIDX_SB_SEC:	// 
			break;
		case SETUPPNL::STPIDX_AS_PANEL:	// [ưΥѥͥ]
			break;
		case SETUPPNL::STPIDX_AS_CHANGE:// [ưˤɻѹ]
			break;
#endif	// 0
	}

	return rv;
}


// ---------------------------------------------------- SETUPPNL  public ؿ
//
// constructor
//
SETUPPNL::SETUPPNL()
	: pnid(-1)
{
	// ѥͥ򳫤
	pnid = opnstdpnl(DBOX::OPNL_SETUP, NULL);
	if (pnid < ER_OK) {
		throw EXCEPT_SETUP(pnid);
	}
	DPRINT(("panel ID : %d\n", pnid));

	// ƥѡĤξ֤
	W	val;
	const	UW	opt = appl->fsn->get_option();

	val = static_cast<W>(appl->fsn->get_min());
	cset_val(pidstdpnl(STPIDX_SB_MIN), 1, &val);
	val = static_cast<W>(appl->fsn->get_sec());
	cset_val(pidstdpnl(STPIDX_SB_SEC), 1, &val);
	val = (opt & CVAL::OPT_PANEL) ? 1 : 0;
	cset_val(pidstdpnl(STPIDX_AS_PANEL), 1, &val);
	val = (opt & CVAL::OPT_CHANGE) ? 1 : 0;
	cset_val(pidstdpnl(STPIDX_AS_CHANGE), 1, &val);

	pnl = this;
}


//
// destructor
//
SETUPPNL::~SETUPPNL()
{
	if (pnid >= 0) {
		clsstdpnl();
	}
}


//
// ͤμ
//
void	SETUPPNL::get_setdat()
{
	W	val;
	UW	opt;

	// ʬμФ
	cget_val(pidstdpnl(STPIDX_SB_MIN), 1, &val);
	appl->fsn->set_min(val);

	// äμФ
	cget_val(pidstdpnl(STPIDX_SB_SEC), 1, &val);
	appl->fsn->set_sec(val);

	// ѥͥ롦ѹμФ
	opt = CVAL::OPT_NONE;
	cget_val(pidstdpnl(STPIDX_AS_PANEL), 1, &val);
	opt |= val * CVAL::OPT_PANEL;
	cget_val(pidstdpnl(STPIDX_AS_CHANGE), 1, &val);
	opt |= val * CVAL::OPT_CHANGE;
	appl->fsn->set_option(opt);

	return;
}


//
// ѥͥμ¹
//	<  0 : error code
//	== 0 : λ
//	== 1 : 
//
WERR	SETUPPNL::exec()
{
	WERR	rv;

	rv = exstdpnl(pnid, (FUNCP)(&setuppnl_fn));
	pnid = -1;

	return rv;
}
