//
//	maintsk.cc (ɻѹ/紴)
//
//	(C) Copyright 2001 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"dbox.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"sendmsg.h"
#include	"wallchg.h"
#include	"maintsk.h"
#include	"subtsk.h"
#include	"setuppnl.h"


// ----------------------------------------------------- MAINTSK  public ؿ
//
// constructor
//
MAINTSK::MAINTSK()
	: loop(true)
{
	if (wdef_fep(1) < ER_OK) {
		throw EXCEPT_MAINTSK(WALLERR::NOREGFEP);
	}
}

//
// destructor
//
MAINTSK::~MAINTSK()
{
	wdef_fep(0);
}


//
// åμԤ(event loop )
//
void	MAINTSK::recv_msgloop() throw()
{
	do {
		// window ϻʤ¾λ¿ message ⸫뤿
		W	type;
		bool	pass;

		pass = true;
		type = wget_evt(&wevt, WAIT);
		switch (type) {
#if	0				// fep ȡϼʤ
			case EV_MSG:
				pass = recv_mesg((MESSAGE*)(&wevt.g.data[0]));
				break;
#else	// 0				// fepʤΤ EV_NULL ˼ʬǳǧ
			case EV_NULL:
				MESSAGE	msg;

				if (rcv_msg(SENDMSG::CHG_MSGMASK, &msg, sizeof(msg), NOWAIT | NOCLR) >= ER_OK) {
					pass = recv_mesg(&msg);
				}
				break;
#endif	// 0
			case EV_REQUEST:
				if ((wevt.r.cmd == W_FINISH) ||
				    (wevt.r.cmd == W_DELETE)) {
					// subtask 
					appl->stsk=std::auto_ptr<SUBTSK>(NULL);
					wrsp_evt(&wevt, 0);
					DPRINT(("terminate main task.\n"));
					loop = false;
					pass = false;
				}
				break;
		}
		if (pass) {
			wpas_evt(&wevt);
		}
		wai_prc(0);
	} while (loop);

	return;
}


// ---------------------------------------------------- MAINTSK  private ؿ
//
// åμ
//
// ʬѤΥåä false ֤( process äƤϤʤ
// åäȤ̣)
//
bool	MAINTSK::recv_mesg(MESSAGE* wmsg)
{
	bool	flg;

	flg = true;
	DPRINT(("recive message.\n"));
	if (wmsg->msg_type == static_cast<W>(SENDMSG::CHG_MSGTYPE)) {
		MESSAGE	msg;

		DPRINT(("my message\n."));
		if (rcv_msg(SENDMSG::CHG_MSGMASK, &msg, sizeof(msg), NOWAIT | NOCLR) >= ER_OK) {
			if (memcmp(msg.msg_body.ANYMSG.msg_str, SENDMSG::TYPE0_STR, SENDMSG::SIZE_TYPE0_STR) == 0) {
				// λ׵
				flg = false;
				loop = false;
				DPRINT(("terminate main task.\n"));
			} else if (memcmp(msg.msg_body.ANYMSG.msg_str, SENDMSG::TYPE1_STR, SENDMSG::SIZE_TYPE1_STR) == 0) {
				// ɽѹ
				flg = false;
				try {
					WALLCHG	wchg;

					wchg.exec();
					appl->start_subtsk();
				} catch (EXCEPT_WALLCHG& err) {
					// Ѥʤäñ̵
					DPRINT(("can't change(%d).\n", err.get_err() >> 16));
				} catch (...) {
					// Ǥ⤤鼺Ԥ exit
					loop = false;
				}
			} else if (memcmp(msg.msg_body.ANYMSG.msg_str, SENDMSG::TYPE2_STR, SENDMSG::SIZE_TYPE2_STR) == 0) {
				flg = false;
				appl->stsk = std::auto_ptr<SUBTSK>(NULL);
				wdef_fep(0);	// panel 򳫤Τ
				try {
					SETUPPNL	pnl;
 
					if (pnl.exec() == 1) {
						if((appl->fsn->get_min() > 0)||
						   (appl->fsn->get_sec() > 0)){
							appl->create_subtsk();
						} else {
							// Ԥ0ˤ齪λ
							loop = false;
						}
					} else {
						loop = false;
					}
				} catch (...) {
					// Ǥ⤤鼺Ԥ exit
					loop = false;
				}
				wdef_fep(1);
			}
			if (!(flg)) {
				// pass ƤϤʤΤǾä
				clr_msg(MM_ALL, MM_ALL);
			}
		}
	}

	return flg;
}
