//
//	main.cc (ɻѹ/ᥤ)
//
//	(C) Copyright 2001 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<errcode.h>
#include	<bstdlib.h>

#include	<new>

#include	"val.h"
#include	"dbox.h"
#include	"except.h"
#include	"err.h"
#include	"debug.h"

#include	"main.h"
#include	"appl.h"


// ѿ
EXPORT	WALLCHG_APPL*	appl = NULL;	// application 


// ----------------------------------------------------------------------- MAIN
extern "C" W MAIN(MESSAGE* msg)
{
	ERR	er;
	IMPORT	ERR	_StartupError;

	if (_StartupError < ER_OK) {
		er = _StartupError;
		DPRINT(("WARNING : startup error : %d\n", er >> 16));
		goto EXIT;
	}
#ifdef	DEBUG
	malloctest(1);
#endif	// DEBUG
	try {
		appl = new WALLCHG_APPL(msg);	// application 𴴤
		er = appl->main();	// application μ¹
	} catch (EXCEPT_EXECMSG& err) {	// ưˡ
					// (appl  constructor ǤΤȯ)
		er = err.get_err();
		DPRINT(("%s : %d\n", err.what(), er >> 16));
		errpanel(DBOX::EPNL_EXECMSG, er);
		closedbox();
	} catch (EXCEPT_INITERR& err) {	// application νǤ㳰
					// (panelθˤΤ panel ̵)
		er = err.get_err();
		DPRINT(("%s : %d\n", err.what(), er >> 16));
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, 0);	// ʤȤ⤢뤫
		er = ER_NOMEM;
	} catch (exception& err) {
		DPRINT(("other exception.\n"));
		errpanel(DBOX::EPNL_SYSTEM, 0);	// ʤȤ⤢뤫
		er = ER_SYS;
	} catch (...) {
		DPRINT(("unknown exception.\n"));
		errpanel(DBOX::EPNL_SYSTEM, 0);	// ʤȤ⤢뤫
		er = ER_SYS;
	}
	sysmsg(0);

EXIT:
	delete appl;			// application 𴴤Ѵ
#ifdef	DEBUG
	return er;
#else	// DEBUG
	ext_prc(er);
	return er;
#endif	// DEBUG
}
