//
//	fusen.cc (ɻѹ/䵴)
//
//	(C) Copyright 2001 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/cnvend.h>
#include	<bstdlib.h>

#include	"cval.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"macro.h"

#include	"fusen.h"


// ------------------------------------------------------- FUSEN  public ؿ
//
// constructor
//
FUSEN::FUSEN(MESSAGE* msg)
{
	WALLCHG_FUSEN	buf;

	fsn = DEF_FUSEN;

	if (msg->msg_type == EXECREQ) {
		// ȤΥץưμФ
		M_EXECREQ*	exreq;

		exreq = reinterpret_cast<M_EXECREQ*>(msg);
		if ((exreq->mode & 0x03) != 0x00) {
			// 䵸ͭǡɤ߹
			W	fd;
			WERR	rv;

			fd = opn_fil(&exreq->lnk, F_READ, NULL);
			if (fd < ER_OK) {
				throw EXCEPT_FUSEN(fd);
			}
			rv = oget_fsn(exreq->vid, fd,
						&buf, sizeof(WALLCHG_FUSEN));
			cls_fil(fd);
			if (rv < ER_OK) {
				throw EXCEPT_FUSEN(rv);
			}
		} else {
			memcpy(&buf, (VP)exreq->info, sizeof(WALLCHG_FUSEN));
		}
	} else {
		// 䵤ΥץưμФ
		memcpy(&buf, (VP)((M_FUSENREQ*)msg)->info,
							sizeof(WALLCHG_FUSEN));
	}

	// 䵤Ǥγǧ䵤ɤ߹(ɤƤʤнͤΤޤ)
	if ((buf.dlen >= WALLCHG_FUSEN_DLEN) &&
	    (ConvEndianH(buf.ver) == WALLCHG_FUSEN_VERSION)) {
		ConvEndianStruct(&fsn, &buf,
				WALLCHG_FUSEN_STRUCT, sizeof(WALLCHG_FUSEN));
	}

	// Ƥ򵭲Ƥ
	org = fsn;
}


//
// destructor
//
FUSEN::~FUSEN()
{
}


//
// 䵸ͭǡ񤭹(¸)
//
void	FUSEN::write_fusen(MESSAGE* msg)
{
	W	upd;
	W	vid;

	upd = (memcmp(&fsn, &org, sizeof(WALLCHG_FUSEN)) != 0) ? 1 : 0;
	if (msg->msg_type == EXECREQ) {
		// ȤΥץư
		M_EXECREQ*	exreq;

		exreq = reinterpret_cast<M_EXECREQ*>(msg);
		vid = exreq->vid;
		if (upd == 1) {
			// ư/䵤ιomgr ʬιλ
			W	fd;

			fd = opn_fil(&exreq->lnk, F_UPDATE, NULL);
			if (fd < ER_OK) {
				throw EXCEPT_FUSEN(fd);
			}
			fsn.dlen = WALLCHG_FUSEN_DLEN;
			oput_fsn(vid, fd, &fsn);
			cls_fil(fd);
		}
	} else {
		// 䵤Υץư
		vid = ((M_FUSENREQ*)msg)->vid;
	}
	oend_prc(vid, &fsn, upd);

	return;
}
