//
//	appl.cc (ɻѹ/application )
//
//	(C) Copyright 2001 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<btron/cnvend.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"cval.h"
#include	"except.h"
#include	"dbox.h"
#include	"err.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"sendmsg.h"
#include	"wallchg.h"
#include	"maintsk.h"
#include	"subtsk.h"
#include	"setuppnl.h"


// ------------------------------------------------ WALLCHG_APPL  public ؿ
//
// constructor
//
WALLCHG_APPL::WALLCHG_APPL(MESSAGE* msg)
	: endprc(true)
{
	// little endian 
	bigEndian = False;

	// Ūʽ
	getscreen();
	initstdpnl();
	chg_wrk(NULL);

	//  application μ(ʪưʳͤ)
	mydat.pid = prc_sts(0, NULL, NULL);
	prc_inf(0, PI_LINK, (LINK*)&mydat.lnk, sizeof(LINK));

	// databox 򳫤
	if (opendatabox(&mydat.lnk, DBOX::WALLCHG_DTYP, DBOX::WALLCHG_DNUM, 1) < ER_OK) {
		throw EXCEPT_INITERR(WALLERR::DBOXOPEN);
	}

	// ưˡγǧ
	DPRINT(("execution : "));
	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			DPRINT(("EXECREQ\n"));
			mydat.msg.exreq = (M_EXECREQ*)msg;
			if (!(mydat.msg.exreq->mode & 0x0002)) {
				// ʪưΤǧ
				oend_prc(mydat.msg.exreq->vid, NULL, 0);
				throw EXCEPT_EXECMSG(ER_NOSPT);
			}
			break;
		case FUSENREQ:		// 䵤Υץư
			DPRINT(("FUSENREQ\n"));
			mydat.msg.fsnreq = (M_FUSENREQ*)msg;
			break;
		case DISPREQ:		// Ȥɽư
			DPRINT(("DISPREQ\n"));
			oend_req(((M_DISPREQ*)msg)->vid, 1);
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
		case PASTEREQ:		// ǡŽߵư
			DPRINT(("PASTEREQ\n"));
			oend_req(((M_PASTEREQ*)msg)->vid, 1);
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
		case TADREQ:		// Ȥ TAD ǡư
			DPRINT(("TADREQ\n"));
			oend_req(((M_TADREQ*)msg)->vid, 1);
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
		default:		// ¾(cliưʤ)
			DPRINT(("other\n"));
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
	}
}


//
// destructor
//
WALLCHG_APPL::~WALLCHG_APPL()
{
	closedbox();

	if (endprc) {
		if (mydat.msg.msg->msg_type == EXECREQ) {
			oend_prc(mydat.msg.exreq->vid, NULL, 0);
		} else {
			oend_prc(mydat.msg.fsnreq->vid, NULL, 0);
		}
	}
}


//
// application 紴ؤ
//
ERR	WALLCHG_APPL::main()
{
	ERR	er;

	er = ER_OK;

	// ư(¿ŵưǽ window ʤΤǤǸƤӽФ)
	if (mydat.msg.msg->msg_type == EXECREQ) {
		osta_prc(mydat.msg.exreq->vid, -1);
	} else {
		osta_prc(mydat.msg.fsnreq->vid, -1);
	}

	// ΤΤγǧ
	if (chk_front()) {
		goto EXIT;
	}

	// ƴ class 
	try {
		WALLCHG::init_rand();
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));

		//  option ˱
		bool	chg;		// ѹƤ褤
		bool	cont;		// ³Ԥ뤫ɤ
		const	UW	opt = fsn->get_option();

		chg = true;
		cont = true;
		if (opt & CVAL::OPT_CHANGE) {
			// ưɻѹͭ
			WALLCHG	wchg;

			wchg.exec();
			chg = false;
		}
		if (opt & CVAL::OPT_PANEL) {
			// ѥͥ򳫤뤳ȤˤʤäƤ
			SETUPPNL	pnl;

			cont = (pnl.exec() == 1);
		}
		if (cont) {
			if ((fsn->get_option() & CVAL::OPT_CHANGE) && (chg)) {
				// ɻѹͭˤʤä
				WALLCHG	wchg;

				wchg.exec();
			}
			if ((fsn->get_min() > 0) || (fsn->get_sec() > 0)) {
				//  task εư
				mtsk = std::auto_ptr<MAINTSK>(new MAINTSK);
				create_subtsk();

				// Ԥ
				mtsk->recv_msgloop();
			}
		}
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߻ξ㳲
		er = err.get_err();
		DPRINT(("can't read fusen : %d(%d)\n", er, er >> 16));
		errpanel(DBOX::EPNL_FREAD, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_MAINTSK& err) {	// 紴Ǥξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		if (er == WALLERR::NOREGFEP) {
			errpanel(DBOX::EPNL_REGFEP, er);
		} else {
			errpanel(DBOX::EPNL_MAINTSK, er);
		}
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_SUBTSK& err) {	// Ԥ subtask Ǥξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_SUBTSK, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_WALLCHG& err) {	// ɻѹǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_WALLCHG, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_SETUP& err) {	// ѥͥǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_SETUP, er);
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	if (er >= ER_OK) {
                // 䵤ι
		try {
			fsn->write_fusen(mydat.msg.msg);
			endprc = false;
		} catch (EXCEPT_FUSEN& err) {
			DPRINT(("can't write fusen : %d\n",err.get_err()>>16));
			errpanel(DBOX::EPNL_FWRITE, err.get_err());
			er = err.get_err();
                }
	}

EXIT:
	DPRINT(("appl exit.\n"));
	return er;
}


//
// Ԥ subtask 
//
void	WALLCHG_APPL::create_subtsk()
{
	UW	time;

	time = (fsn->get_min() * 60 + fsn->get_sec()) * 1000;
	stsk = std::auto_ptr<SUBTSK>(new SUBTSK(time));

	return;
}
 

//
// Ԥ subtask Ω夲
//
void	WALLCHG_APPL::start_subtsk()
{
	stsk->wakeup_subtask();

	return;
}


// ----------------------------------------------- WALLCHG_APPL  private ؿ
//
// ΤΤ¸߳ǧ׵
//
// ΤΤä硢true ֤
//
bool	WALLCHG_APPL::chk_front()
{
	bool	flg;
	TC*	name;

	flg = false;
	name = reinterpret_cast<TC*>(getdbox(DBOX::GLOBAL_NM));

	// ˵ưƤ뤫ǧ
	W	dat;

	if (get_nam(name, &dat) >= ER_OK) {
		if (prc_sts(dat, NULL, NULL) == dat) {
			// ưƤ顢ʬ׵
			SENDMSG::send_mesg(dat, SENDMSG::CHGTYPE_2);
			DPRINT(("setup panel request(%d).\n", dat));
			flg = true;
		}
	}

	// ïʤäΤʤ顢ʬ PID Ǿ
	if (!(flg)) {
		cre_nam(name, mydat.pid, N_FORCE | DELEXIT);
		DPRINT(("set pid : %d\n", mydat.pid));
	}

	return flg;
}
