//
//	tadsave.cc (ʰʸԽ/¿Ȥؤν񤭹߷)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>		// tad.h ɬ
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<errcode.h>
#include	<tad.h>
#include	<tcode.h>
#include	<tlang.h>
#include	<wtstring.h>

#include	<vector>

#include	"dbox.h"
#include	"cval.h"
#include	"val.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"strope.h"
#include	"tadsave.h"


// ----------------------------------------------------- TADSAVE  public ؿ
//
// constructor
//
TADSAVE::TADSAVE(W pfd, W pvid)
	: fd(pfd), dvid(pvid)
{
	sysmsg(DBOX::SMSG_SAVE);
	wbuf.ofs = 0;
	wbuf.size = 0;
	memset(wbuf.dat, 0x00, BUFFER_SIZE);
}


//
// destructor
//
TADSAVE::~TADSAVE()
{
	sysmsg(0);
}


//
// ¸μ¹Խ
//
void	TADSAVE::main()
{
	store_tad();
	del_oldtad();

	return;
}


// ---------------------------------------------------- TADSAVE  private ؿ
//
// record ؤν񤭽Ф
//
void	TADSAVE::output_data(const B* dat, W size)
{
	if (size < 0) {
		// flush buffer
		if (wbuf.size > 0) {
			wri_rec(fd, wbuf.ofs, wbuf.dat, wbuf.size,NULL,NULL,0);
			wbuf.ofs += wbuf.size;
			wbuf.size = 0;
			memset(wbuf.dat, 0x00, BUFFER_SIZE);
		}
	} else {
		// buffer ίƤ
		W	widx;

		for (widx = 0; widx < size; ++widx) {
			if (wbuf.size >= BUFFER_SIZE) {
				// buffer Ϥ߽ФΤ flush ǽϤ
				output_data(NULL, -1);
			}
			wbuf.dat[wbuf.size] = dat[widx];
			++wbuf.size;
		}
	}

	return;
}


//
// 󥻥Ȥν񤭽Ф
//
void	TADSAVE::store_info()
{
	TADSEG	inf = {
			TC_ESC | TS_INFO, sizeof(INFOSEG)
		};
	TC	dat[] = {		// padding к
			0x0000, 2, 0x0121
		};

	output_data(reinterpret_cast<B*>(&inf), sizeof(TADSEG));
	output_data(reinterpret_cast<B*>(&dat), sizeof(TC) * 3);

	return;
}


//
// ʸϳϥȤν񤭽Ф
//
void    TADSAVE::store_txt()
{
	TADSEG	txt = {
			TC_ESC | TS_TEXT, sizeof(TEXTSEG)
		};
	TEXTSEG	dat = {
			(RECT){{0, 0, 0, 0}}, (RECT){{0, 0, 0, 0}},
			-120, -120, TSC_SYS, 0
		};

	output_data(reinterpret_cast<B*>(&txt), sizeof(TADSEG));
	output_data(reinterpret_cast<B*>(&dat), sizeof(TEXTSEG));

	return;
}


//
// ʸϽλȤν񤭽Ф
//
void	TADSAVE::store_txtend()
{
	TADSEG	tend = {
			TC_ESC | TS_TEXTEND, 0
		};

	output_data(reinterpret_cast<B*>(&tend), sizeof(TADSEG));

	return;
}


//
// TAD  record ν񤭽Ф
//
// ɬǸɲ(apd_rec())Ȥʤޤ
//
void	TADSAVE::store_tad()
{
	// оݥ쥳ɤ
	ERR     er;

	er = apd_rec(fd, NULL, 0, RT_TADDATA, 0x0000, 0);
	if (er < ER_OK) {
		throw EXCEPT_TADSAVE(er);
	}

	// ϤΥ쥳ɤ˰ư
	W	rtype;

	rtype = fnd_rec(fd, F_ENDTOP, RM_TADDATA, 0x0000, NULL);
	if (rtype < ER_OK) {
		throw EXCEPT_TADSAVE(rtype);
	}

	// إåʬν񤭽Ф
	store_info();
	store_txt();

        // ƤƤ
	W	l;
	TLANG	lng;
	const	W	wlen = appl->estr.get_tlen();
	const	WTC*	wstr = appl->estr.get_text();

	lng = TSC_SYS;
	for (l = 0; l < wlen; ++l) {
		if (lng != wtclang(wstr[l])) {
			// /ץȻڤؤ
			lng = wtclang(wstr[l]);

			// /ץȻ TAD Ѵ
			std::vector<TC>	lstr(TLANGtoTC(NULL, -1, lng) + 1);

			TLANGtoTC(lstr.begin(), -1, lng);
			output_data(reinterpret_cast<B*>(lstr.begin()), (lstr.size() - 1) * sizeof(TC));
		}

		// ʸν񤭽Ф
		TC	ch;

		ch = wtcchar(wstr[l]);
		output_data(reinterpret_cast<B*>(&ch), sizeof(TC));
	}

	// ʸϽλȤν񤭽Ф
	store_txtend();

	// buffer flush
	output_data(NULL, -1);

	return;
}


//
// Ť TAD  record ˴
//
// store_tad() λˤ record ƺƤޤ
//
void	TADSAVE::del_oldtad()
{
	W	mode;

	for (mode = F_NBWD; ; ) {
		W	rtype;

		rtype = fnd_rec(fd, mode, RM_TADDATA, 0x0000, NULL);
		if (rtype == ER_REC) {
			// λ
			break;
		} else if (rtype < ER_OK) {
			// ¾ error
			throw EXCEPT_TADSAVE(rtype);
		} else if (rtype == RT_TADDATA) {
			//  record 
			mode = (del_rec(fd) >= 0) ? F_NBWD : F_BWD;
		}
	}

	return;
}

