//
//	tadload.cc (ʰʸԽ/¿Ȥɤ߹߷)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>		// tad.h ɬ
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<tad.h>
#include	<tcode.h>
#include	<tlang.h>
#include	<wtstring.h>

#include	<stack>

#include	"dbox.h"
#include	"cval.h"
#include	"val.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"strope.h"
#include	"tadload.h"


// ----------------------------------------------------- TADLOAD  public ؿ
//
// constructor
//
TADLOAD::TADLOAD(const LINK* lnk)
	: nst(0), lng(TSC_SYS), skiptad(false), ln(false)
{
	// оݼ¿Ȥ򳫤
	rinf.fd = opn_fil((LINK*)lnk, F_READ, NULL);
	if (rinf.fd < ER_OK) {
		throw EXCEPT_TADLOAD(rinf.fd);
	}

	sysmsg(DBOX::SMSG_LOAD);
	rinf.ofs = 0;
	rinf.idx = 0;
	rinf.rsize = 0;
	memset(rinf.buf, 0x00, BUFFER_SIZE);
}


//
// destructor
//
TADLOAD::~TADLOAD()
{
	sysmsg(0);
	cls_fil(rinf.fd);
}


//
// ɤ߹ߤμ紴
//
void	TADLOAD::main()
{
	// TAD  record ɤ
	W	mode;

	for (mode = F_TOPEND; ; mode = F_NFWD) {
		// о record õ
		if (fnd_rec(rinf.fd, mode, RM_TADDATA, 0x0000, NULL) != RT_TADDATA) {
			break;
		}

		// ɤ߹߾ν
		rinf.ofs = 0;
		rinf.idx = 0;
		memset(rinf.buf, 0x00, BUFFER_SIZE);
		rea_rec(rinf.fd, 0, NULL, 0, &rinf.rsize, NULL);
		DPRINT(("record size : %d\n", rinf.rsize));

		// parser θƽФ
		tad_parse();
	}

	// ɤ߹߸ξ֤γǧ
	if (nst != 0) {
		// ʿ
		skiptad = true;
	}
	if (!(ln)) {
		// Ǹ夬/ԤǤʤСɲä
		appl->estr.add_text(towtc(lng, TC_NL));
	}

	// ۾
	if (skiptad) {
		errpanel(DBOX::EPNL_LOADSKIP, 0);
		appl->eobj->set_skipflg(true);
	}

	return;
}


// ---------------------------------------------------- TADLOAD  private ؿ
//
// record ɤ߹(TC 1ʸŤĤɤ߹)
//
// force == true : ɬ¿Ȥɤ߼
//
TC	TADLOAD::read_buf(bool force)
{
	TC	ch;

	if (rinf.idx >= rinf.rsize) {
		// record νüã
		rinf.idx = -1;
		rinf.ofs = -1;
		ch = TNULL;
	} else {
		// buffer 椫Ȥ
		if (((rinf.ofs + BUFFER_SIZE) <= rinf.idx) || (force)) {
			// buffer ˤϤʤʤΤ record ɤ߹
			rinf.ofs = rinf.idx;
			rea_rec(rinf.fd, rinf.ofs, rinf.buf, BUFFER_SIZE, NULL, NULL);
		}
		ch = *(reinterpret_cast<const TC*>(&rinf.buf[rinf.idx - rinf.ofs]));
        }

	return ch;
}


//
// TAD  record Ƥβ
//
void	TADLOAD::tad_parse()
{
	do {
		TC	ch;

		ch = read_buf(rinf.idx <= 0);
		if ((ch == TNULL) && (rinf.idx < 0) && (rinf.ofs < 0)) {
			// ü
			DPRINT(("buffer over.\n"));
			break;
		} else if ((ch & TC_SPEC) == TC_SPEC) {
			// /
			chk_TS(ch);
		} else if ((ch & TC_SPEC) == TC_LANG) {
			// /ץȻ
			W	n;	// TC_LANG θĿ
			TLANG	lbuf;	// Ǹ TLANG

			n = -1;		// ǽ +1 Τǽͤ -1
			while ((ch & TC_SPEC) == TC_LANG) {
				// isTLANG() ۤɤθ̩ǤϤʤ
				++n;
				lbuf = ch & 0x00ff;
				rinf.idx += sizeof(TC);
				if ((ch & 0x00ff) != 0x00fe) {
					// ̤ 0xfe Ǥʤ TLANG Ͻλ
					break;
				}
				ch = read_buf(false);
			}
			lng = (n << 8) | lbuf;
		} else if ((ch == TC_NL) || (ch == TC_CR) || (ch >= 0x2121)) {
			// ʸ//
			appl->estr.add_text(towtc(lng, ch));
			rinf.idx += sizeof(TC);
			ln = ((ch == TC_NL) || (ch == TC_CR));
		} else {
			// 
			skiptad = true;
			rinf.idx += sizeof(TC);
		}
	} while ((rinf.idx >= 0) && (rinf.ofs >= 0));

	return;
}
 

//
// /Ȥμʬ
//
void	TADLOAD::chk_TS(TC ch)
{
	W	len;			// /Ĺ(byte ñ)
	UB	id;			// segment ID
	UB	sid;			// segment sub ID
	UB	sattr;			// attribute

	// TADSEG ʬμ
	id = ch & 0x00ff;
	rinf.idx += sizeof(TC);
	len = read_buf(false);
	rinf.idx += sizeof(TC);
	if (len == 0xffff) {
		// large segment(ˡǤ endian )(LTADSEG )
		len = read_buf(false);
		rinf.idx += sizeof(TC);
		len += (read_buf(false) << 16);
		rinf.idx += sizeof(TC);
	}

	// sub ID Ȥμ(Ǥ rinf.idx Ϥޤʤʤ)
	TC	sch;

	sch = read_buf(false);
	sid = sch >> 8;
	sattr = sch & 0x00ff;

	// segment ID ʬ
	switch (id) {
		case TS_INFO:
			// 󥻥(̵)
			break;
		case TS_TEXT:
		case TS_FIG:
			// ʸϳϥ/޷ϥ
			++nst;		// ʿɲäΤ
			nlng.push(lng);
			lng = TSC_SYS;
			break;
		case TS_TEXTEND:
		case TS_FIGEND:
			// ʸϽλ/޷λ
			--nst;		// ʿθ
			if (!(nlng.empty())) {
				lng = nlng.top();
				nlng.pop();
			}
			break;
		default:
			// 
			skiptad = true;
			break;
	}

	// rinf.idx ʤ
	rinf.idx += len;

	return;
}
