//
//	strope.cc (ʰʸԽ/Խʸ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<tcode.h>
#include	<tlang.h>
#include	<wtstring.h>

#include	<vector>

#include	"cval.h"

#include	"strope.h"


// ------------------------------------------------------ STROPE  public ؿ
//
// constructor
//
STROPE::STROPE()
	: cidx(0), wlen(0)
{
	lpos = (PNT){-1, -1};
}


//
// destructor
//
STROPE::~STROPE()
{
}


//
// ʸɽ
//
// mode <  0 : 
//	== 0 : ʸ֤ν°ԤΤ
//	== 1 : ʸ֤ν°԰ʹ
//
void	STROPE::disp_text(W gid, RECT vrect, W mode)
{
	// ϰϤ
	W	st;			// 
	W	ed;			// 轪
	PNT	p;			// ʸ

	st = 0;
	ed = 0;
	p = (PNT){CVAL::TEXT_HGAP, CVAL::TEXT_VGAP + CHSSTD};

	if ((mode < 0) || (mode == 1)) {
		ed = wlen;
	}
	if ((mode == 0) || (mode == 1)) {
		// °Ԥõ
		W	l;
		bool	lin;

		lin = false;
		for (l = 0; l < wlen; ++l) {
			if (l == cidx) {
				lin = true;
			}

			// Ԥγǧ
			TC	ch;

			ch = wtcchar(wstr[l]);
			if ((ch == TC_NL) || (ch == TC_CR)) {
				if (lin) {
					if (mode == 0) {
						ed = l;
					}
					break;
				} else {
					st = l + 1;
					p.y += CHSSTD + CVAL::CH_VGAP;
				}
			}
		}
	}

	// ʸ
	W	i;

	for (i = st; i < ed; ++i) {
		TC	ch;

		ch = wtcchar(wstr[i]);

		// ʸ֤γǧ
		RECT	r;

		r.c.left = p.x;
		r.c.top = p.y - CHSSTD;
		r.c.right = p.x + CHSSTD;
		r.c.bottom = p.y;
		if (sectrect(r, vrect) && (ch != TC_NL) && (ch != TC_CR)) {
			// ɽϰʤΤ褹
			gset_scr(gid, wtclang(wstr[i]));
			gdra_chp(gid, p.x, p.y, ch, G_STORE);
		} else if (r.c.top > vrect.c.bottom) {
			// Ϥ߽ФΤǤڤ
			break;
		}

		// ʸγǧ
		if ((ch == TC_NL) || (ch == TC_CR)) {
			// /
			p.x = CVAL::TEXT_HGAP;
			p.y += CHSSTD + CVAL::CH_VGAP;
		} else {
			// ¾ΰʸ
			p.x += CHSSTD + CVAL::CH_HGAP;
		}
	}

	return;
}


//
// Խоʸʸɲä
//
void	STROPE::add_text(WTC wch)
{
	if (wlen < wstr.size()) {
		wstr[wlen] = wch;
	} else {
		wstr.push_back(wch);
	}
	++wlen;

	return;
}


//
// ʸ֤ľʸ
//
void	STROPE::del_text()
{
	if ((wlen > 0) && (cidx > 0)) {
		if (cidx < wlen) {
			// ʬ˵ͤ
			memmove(&wstr[cidx - 1], &wstr[cidx], (wstr.size() - cidx) * sizeof(WTC));
		}
		wstr[wlen - 1] = WTNULL;

		if (cidx > 0) {
			--cidx;
			lpos = (PNT){-1, -1};	// ݻ
		}
		if (wlen > 0) {
			--wlen;
		}
	}

	return;
}


//
// ʸ֤ľʸ
//
void	STROPE::ins_text(const WTC* istr, W ilen)
{
	W	rlen;			// ĥʸ(WTC ñ)

	rlen = ilen + wlen - wstr.size();
	if (rlen > 0) {
		wstr.resize(wstr.size() + rlen);
	}
	memmove(&wstr[cidx + ilen], &wstr[cidx], (wlen - cidx) * sizeof(WTC));
	memcpy(&wstr[cidx], istr, ilen * sizeof(WTC));
	wlen += ilen;
	cidx += ilen;
	lpos = (PNT){-1, -1};		// ݻ

	return;
}


//
// ʸ֤ΰư([̿]  [ĥ] Ʊʬϴޤޤ)
//
// type == 0 : 
//	== 1 : 
//	== 2 : 
//	== 3 : 
//
void	STROPE::move_cidx(W type)
{
	if ((type == 0) || (type == 1)) {
		// ذư
		W	step;
		TC	ch;

		ch = wtcchar(wstr[cidx]);
		cidx += (type == 0) ? -1 : 1;
		if (cidx < 0) {
			cidx = 0;
		} else if (cidx >= wlen) {
			cidx = wlen - 1;
		}
		lpos = (PNT){-1, -1};	// ݻ
	} else if ((type == 2) || (type == 3)) {
		// 岼λϼºɸ򸵤˰ư
		PNT	cp;
		PNT	np;

		if (lpos.y < 0) {
			// ݻ֤ǤϤʤ
			lpos = cnv_crpos();
		}
		cp = lpos;

		cp.y += ((type == 2) ? -CHSSTD : CHSSTD) - (CHSSTD >> 1);
		cnv_pdpos(cp);
		np = cnv_crpos();	// ưΰ֤μ
		lpos = (PNT){cp.x, np.y};
	}

	return;
}


//
// ʸ֤ caret (window кɸ)Ѵ
//
// ʸ CHSSTD 
//
const	PNT	STROPE::cnv_crpos()
{
	PNT	p;
	W	l;
	TC	ch;

	p = (PNT){CVAL::TEXT_HGAP, CVAL::TEXT_VGAP + CHSSTD};
	for (l = 0; (l < wlen) && (l < cidx); ++l) {
		ch = wtcchar(wstr[l]);
		if ((ch == TC_NL) || (ch == TC_CR)) {
			// /
			p.x = CVAL::TEXT_HGAP;
			p.y += CHSSTD + CVAL::CH_VGAP;
		} else {
			// ¾ΰʸ
			p.x += CHSSTD + CVAL::CH_HGAP;
		}
	}

	return p;
}


//
// PD (window кɸ)ʸ֤Ѵ
//
void	STROPE::cnv_pdpos(PNT p)
{
	W	l;
	TC	ch;
	PNT	cp;
	bool	lin;

	cp = (PNT){CVAL::TEXT_HGAP + CHSSTD, CVAL::TEXT_VGAP + CHSSTD};
	lin = false;
	cidx = -1;
	for (l = 0; l < wlen; ++l) {
		if ((p.y >= cp.y - CVAL::TEXT_VGAP - CHSSTD) && (p.y <= cp.y)){
			if (p.x <= cp.x) {
				cidx = l;
				break;
			}
			lin = true;
		} else if (lin) {
			cidx = l - 1;
			break;
		}

		ch = wtcchar(wstr[l]);
		if ((ch == TC_NL) || (ch == TC_CR)) {
			// /
			cp.x = CVAL::TEXT_HGAP + CHSSTD;
			cp.y += CHSSTD + CVAL::CH_VGAP;
		} else {
			// ¾ΰʸ
			cp.x += CHSSTD + CVAL::CH_HGAP;
		}
	}
	if (cidx < 0) {
		cidx = l - 1;
	}
	lpos = (PNT){-1, -1};		// ݻ

	return;
}


//
// 쥤ϰϤ
//
const	SIZE	STROPE::get_layarea()
{
	SIZE	sz;
	W	l;
	TC	ch;
	PNT	p;

	sz = (SIZE){0, 0};
	p = (PNT){CVAL::TEXT_HGAP, CVAL::TEXT_VGAP + CHSSTD};
	for (l = 0; l < wlen; ++l) {
		// ʸ֤λ
		ch = wtcchar(wstr[l]);
		if ((ch == TC_NL) || (ch == TC_CR)) {
			// /
			p.x = CVAL::TEXT_HGAP;
			p.y += CHSSTD + CVAL::CH_VGAP;
		} else {
			// ¾ΰʸ
			p.x += CHSSTD + CVAL::CH_HGAP;
		}

		// ϰϤγǧ
		if (sz.h < p.x) {
			sz.h = p.x;
		}
		if (sz.v < p.y) {
			sz.v = p.y;
		}
	}

	return sz;
}
