//
//	saveope.cc (ʰʸԽ/¸)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>

#include	"dbox.h"
#include	"val.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"saveope.h"
#include	"tadsave.h"


// -------------------------------------- SAVEOPE  public ؿ(static member)
//
// ¸¸
//
// rv == 0 : /ä/¾Υ顼
//    >  0 : ¸
//
UW	SAVEOPE::make_newfile(W& vid, LINK& lnk)
{
	W	att;
	UW	rv;

	rv = 0;
	att = oatt_vob(appl->get_vid(), 0);
	if (att <= 0) {
		// ¸ file system Ǿ
		if (att != 0) {
			errpanel(DBOX::EPNL_WRITE, att); 
		}
	} else {
		// ¸¿Ȥ/ȤŽ
		W	fd;
		TC	name[L_FNM + 1]; 
 
		name[0] = TNULL;
		fd = ocre_obj(appl->get_vid(), name, &vid, &lnk, 1);
		if (fd < ER_OK) {
			// ä¸褬Ǥʤ
			if (fd != EX_PAR) {
				errpanel(DBOX::EPNL_WRITE, vid); 
			}
		} else {
			rv = 1;
			cls_fil(fd);
		}
	}

	return rv;
}


// ----------------------------------------------------- SAVEOPE  public ؿ
//
// constructor(default)(ǧ¸)
//
SAVEOPE::SAVEOPE()
	: fd(-1), vid(appl->get_vid()), newfile(false), hidden(true),
	  lnk(*appl->get_link())
{
	DPRINT(("SAVEOPE deafult constructor(no ask save).\n"));

	fd = opn_fil(&lnk, F_UPDATE | F_EXCL, NULL);
	if (fd < ER_OK) {
		// ¿Ȥʤʤ¸λ
		throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_ALLSAVE);
	}
}


//
// constructor(copy)(ǧλ/ǧ¸)
//
// flg == true  : λǧ
//     == false : ¸ǧ
//
SAVEOPE::SAVEOPE(bool flg)
	: fd(-1), vid(appl->get_vid()), newfile(false), hidden(false),
	  lnk(*appl->get_link())
{
	DPRINT(("SAVEOPE copy constructor(ask save).\n"));

	W	sel;

	if (flg) {
		// λǧ
		if (appl->eobj->get_editflg()) {
			// λǧѥͥ
			if (appl->eobj->get_skipflg()) {
				// ɤФ뤳Ȥս
				sel = panel(DBOX::PNL_UPESKIP);
			} else {
				// ̤ι
				sel = panel(DBOX::PNL_UPDEXIT);
			}
			if (sel == 1) {
				// [Ѵƽλ]
				throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_UPDATE);
			} else if (sel == 2) {
				// [ƽλ]
				if (appl->eobj->chk_ronly()) {
					// 񤭹Բ°ȤʤäƤ
					if (panel(DBOX::PNL_ERRSAVE) == 1) {
						// [¸]
						if (make_newfile(vid, lnk) == 0) {
							// ϼä
							throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
						}
					} else {
						// [ä] 
						throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
					}
				} else if (appl->eobj->chk_update()) {
					// ¾鹹Ƥ
					sel = panel(DBOX::PNL_OTHUPD);
					if (sel == 1) {
						// []
					} else if (sel == 0) {
						// [ä]
						if (panel(DBOX::PNL_UPDEXIT2) == 1) {
							// [Ѵƽλ]
							throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_UPDATE);
						} else {
							// [ä] 
							throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
						}
					} else {
						// 
						throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
					}
				}
			} else {
				// [ä] 
				throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
			}
		} else if (appl->eobj->chk_update()) {
			// ¾鹹Ƥ
			sel = panel(DBOX::PNL_OTHEXIT);
			if (sel == 1) {
				// [Ѵƽλ]
				throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_UPDATE);
			} else if (sel == 2) {
				// [ƽλ]
				;
			} else {
				// [ä] 
				throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
			}
		} else if (appl->eobj->get_saveflg()) {
			// ƿ¸
			hidden = true;
		} else {
			// ¿Ȥ¸ɬפʤ
			throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_UPDATE);
		}

		// ¸³
		W	att;

		att = oatt_vob(appl->get_vid(), 0);
		if (att <= 0) {
			// ¸ file system Ǿ
			throw EXCEPT_SAVEOPE((att == 0) ? T_TXEDITERR::SAVE_CANCEL : att);
		}
	} else {
		// ¸³(̾ι)
		W	att;

		att = oatt_vob(appl->get_vid(), 0);
		if (att <= 0) {
			// ¸ file system Ǿ
			throw EXCEPT_SAVEOPE((att == 0) ? T_TXEDITERR::SAVE_CANCEL : att);
		}

		if (appl->eobj->chk_ronly()) {
			// 񤭹Բ°ȤʤäƤ
			if (panel(DBOX::PNL_ERRSAVE) == 1) {
				// [¸]
				if (make_newfile(vid, lnk) == 0) {
					// ϼä
					throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
				}
			} else {
				// [ä] 
				throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
			}
		} else {
			// ¸ǧѥͥ
			if (appl->eobj->get_skipflg()) {
				// ɤФ뤳Ȥս
				sel = panel(DBOX::PNL_UPDSKIP);
			} else {
				// ̤ι
				sel = panel(DBOX::PNL_UPDATE);
			}
			if (sel == 1) {
				// []
				if (appl->eobj->chk_update()) {
					// ¾鹹Ƥ
					if (panel(DBOX::PNL_OTHUPD) != 1) {
						// [ä] 
						throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
					}
				}
			} else {
				// [ä] 
				throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
			}
		}
	}

	if (!(hidden)) {
		// ƿ¸Ǥʤϡ(error )Ū
		fd = opn_fil(&lnk, F_UPDATE | F_EXCL, NULL);
		if (fd < ER_OK) {
			// Ԥʤ顢¸¥
			if (make_newfile(vid, lnk) > 0) {
				fd = opn_fil(&lnk, F_UPDATE | F_EXCL, NULL);
				if (fd < ER_OK) {
					// ¿Ȥ̵ʤ error 
					throw EXCEPT_SAVEOPE(fd);
				}
			} else {
				// ϼä
				throw EXCEPT_SAVEOPE(T_TXEDITERR::SAVE_CANCEL);
			}
		}
	} else {
		// ƿξϡ¸򳫤
		fd = opn_fil(&lnk, F_UPDATE | F_EXCL, NULL);
		if (fd < ER_OK) {
			throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_ALLSAVE);
		}
	}
}


//
// constructor(copy)(¸)
//
SAVEOPE::SAVEOPE(W pvid, const LINK* plnk)
	: fd(-1), vid(pvid), newfile(true), hidden(false), lnk(*plnk)
{
	DPRINT(("SAVEOPE copy constructor(new save).\n"));

	fd = opn_fil(&lnk, F_UPDATE | F_EXCL, NULL);
	if (fd < ER_OK) {
		// ¿Ȥʤʤ¸λ
		throw EXCEPT_SAVEOPE(fd);
	}
}


//
// destructor
//
SAVEOPE::~SAVEOPE()
{
	DPRINT(("SAVEOPE destructor.\n"));

	if (fd >= 0) {
		cls_fil(fd);
	}
}


//
// ¸μ紴
//
void	SAVEOPE::main()
{
	DPRINT(("SAVEOPE main procedure.\n"));

	try {
		TADSAVE	tsave(fd, vid);

		tsave.main();
	} catch (EXCEPT_TADSAVE& err) {
		throw EXCEPT_SAVEOPE(err.get_err());
	} catch (std::bad_alloc) {
		throw EXCEPT_SAVEOPE(ER_NOMEM);
	} catch (...) {
		throw EXCEPT_SAVEOPE(ER_SYS);
	}

	return;
}
