//
//	mainwin.cc (ʰʸԽ/祦ɥɷ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<btron/cnvend.h>
#include	<bstring.h>
#include	<errcode.h>
#include	<keycode.h>
#include	<tstring.h>
#include	<tcode.h>

#include	<new>
#include	<memory>
#include	<vector>

#include	"val.h"
#include	"cval.h"
#include	"dbox.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"strope.h"
#include	"fusen.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"textin.h"
#include	"caretope.h"
#include	"mainmenu.h"


// ----------------------------------------------------- MAINWIN  public ؿ
//
// constructor
//
MAINWIN::MAINWIN()
	: wid(-1), gid(-1)
{
	// ɥǡμФ
	ConvEndianStruct(&wdef, getdbox(DBOX::DEF_MAINWIN), WINDEF_STRUCT, sizeof(wdef));

	// ¾ν
	ppos = (PNT){0, 0};
	genrectlist(4, rlist);
}


//
// destructor
//
MAINWIN::~MAINWIN()
{
	if (wid >= 0) {
		wcls_wnd(wid, CLR);
	}
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;
}


//
// ɥ򳫤
//
void	MAINWIN::open_win(const W pwid, const RECT* pr)
{
	// ԥȥμ
	W	pcid;			// ԥȥ ID

	pcid = (static_cast<W>(appl->eobj->get_atype()) & 0xff);
	if (pcid == 0) {
		pcid = CVAL::T_TXEDIT_PICT;
	}

	// ɥξ
	const	WINATTR	wattr = appl->fsn->get_wattr();

	vrect = wattr.rect;
	if ((vrect.c.left >= vrect.c.right)||(vrect.c.top >= vrect.c.bottom)) {
		vrect = wdef.r;
		centering(&vrect);
	}

	// ɥ򳫤
	UW	atr;

	atr = wdef.attr | ((wattr.fwindow) ? WA_FULL : 0);
	set_wbgpat(false);
	wid = wopn_wnd(atr, pwid, &vrect, (RECT*)pr, pcid, (TC*)appl->eobj->get_fname(), &wbgpat, NULL);
	if (wid < ER_OK) {
		throw EXCEPT_MAINWIN(wid);
	}
	DPRINT(("wid : %d\n", wid));
	wget_bar(wid, &bar[0], &bar[1], NULL);

	// ɽν
	gid = wget_gid(wid);
	gset_vis(gid, vrect);
	set_char();

	// ɽ֤ȿ
	const	PNT	vp = appl->fsn->get_vpos();

	wscr_wnd(wid, NULL, -vp.x, -vp.y, W_SCRL);
	gget_vis(gid, &vrect);

	// ɽˤ
	cchg_par(bar[0], P_DRAGBREAK);
	cchg_par(bar[1], P_DRAGBREAK);

	// ʸϼν
	try {
		tin = std::auto_ptr<TEXTIN>(new TEXTIN(wid, CVAL::TIP_MODE));
		car = std::auto_ptr<CARETOPE>(new CARETOPE(tin->get_tport()));
	} catch (EXCEPT_TEXTIN& err) {
		DPRINT(("%s : %d(%d)\n", err.what(), err.get_err(), err.get_err() >> 16));
		throw EXCEPT_MAINWIN(err.get_err());
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_MAINWIN(ER_NOMEM);
	} catch (...) {
		DPRINT(("other exception.\n"));
		throw EXCEPT_MAINWIN(ER_SYS);
	}

	// ɥ쥳ɤϿ
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = wid;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].chgmod = 0x10;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].limit = (RECT){{0, 0, 0, 0}};
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[0] = bar[0];
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[1] = bar[1];
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[2] = -1;

	return;
}


//
// ɥĤ
//
void	MAINWIN::close_win()
{
	wcls_wnd(wid, CLR);
	wid = -1;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;

	return;
}


//
// ɥطʿꤹ
//
void	MAINWIN::set_wbgpat(bool set)
{
	// ʬ
	wbgpat.spat.kind = 0;
	wbgpat.spat.hsize = 16;
	wbgpat.spat.vsize = 16;
	wbgpat.spat.bgcol = CVAL::RGB_WHITE;

	// 䵸ͭǡƤȿ
	const	WINCOL	wcol = appl->fsn->get_wcol();

	if (wcol.mask == 0) {
		// طʿŬ
		wbgpat.spat.fgcol = appl->get_bgcol();
		wbgpat.spat.mask = FILL100;
	} else {
		// 䵸ͭǡͤȿ
		wbgpat.spat.fgcol = wcol.col;
		wbgpat.spat.mask = reinterpret_cast<UB*>(wcol.mask & 0x0007);
	}

	if (set) {
		// ȿǤ
		wset_bgp(wid, &wbgpat);
		set_char();
		redisp(NULL);
	}

	return;
}


//
// Τ˴ؤ
//
void	MAINWIN::set_char()
{
	const	WINATTR	wattr = appl->fsn->get_wattr();
	COLOR	fgcol;			// ʸʿ
	COLOR	bgcol;			// ʸطʿ
	FSSPEC	fspec = {
			{TNULL}, FTC_DEFAULT, 0x0000, {CHSSTD, CHSSTD}
		};

	fgcol = CVAL::RGB_BLACK;
	if (wattr.gray) {
		bgcol = CVAL::COL_GRAY | wbgpat.spat.fgcol;
		fspec.attr |= FT_GRAYSCALE;
	} else {
		bgcol = CVAL::COL_TRANS;
	}

	gset_fon(gid, &fspec);
	gset_chc(gid, fgcol, bgcol);

	return;
}


//
// caret Ϣ
//
// type == 0 : 
//	== 1 : ( window  active Ǥ뤳)
//	>  1 : ( window  active Ǥ뤳)
//
void	MAINWIN::disp_caret(W type)
{
	if (type == 0) {
		// 
		car->off();
	} else if (wget_act(NULL) == wid) {
		//  window  active ǤʤȡɽϤʤ
		if (type == 1) {
			// 
			car->on();
		} else {
			// 
			car->blink();
		}
	}

	return;
}


//
// ɽ򥹥뤵
//
void	MAINWIN::scroll_work(PNT p)
{
	W	rv;

	rv = wscr_wnd(wid, NULL, p.x, p.y, W_SCRL | W_RDSET);
	gget_vis(gid, &vrect);		// scroll ȼưμФ
	if ((rv >= ER_OK) && (rv & W_RDSET)) {
		// scroll ȼ
		disp_fn(0, NULL);
	}

	// ɽ֤䵤˳Ф
	appl->fsn->set_vpos(vrect.p.lefttop);

	// scroll bar ι
	sbar_setup();

	return;
}


//
// 
//
void	MAINWIN::redisp(RECT* r)
{
	RECT	vr;

	gget_vis(gid, &vr);

	// 
	wera_wnd(wid, r);
	if (r != NULL) {
		gset_vis(gid, *r);
	}
	appl->estr.disp_text(gid, vrect, -1);

	gset_vis(gid, vr);

	return;
}


//
// (window event)
//
void	MAINWIN::idle_fn(bool pdflg)
{
	if (pdflg) {
		// ()
		setpointer(PS_SELECT, NULL);
	}

	// caret ΤĤ
	disp_caret(2);

	return;
}


//
// ɽ(window event)
//
void	MAINWIN::disp_fn(W mode, RECT* newr)
{
	if (mode < 0) {
		// 
		appl->estr.cnv_pdpos(appl->fsn->get_vpos());
		car->move(appl->estr.cnv_crpos(), false);
		car_scroll(false);
		redisp(NULL);
		sbar_setup();
	} else {
		// ¾κ
		disp_caret(0);
		if (newr != NULL) {
			// Ѥä
			if ((newr->c.left < CVAL::LIMIT_RECT.c.left) ||
			    (newr->c.top < CVAL::LIMIT_RECT.c.top)) {
				// 夬°ʲˤʤ
				vrect.c.right = rectwidth(*newr);
				vrect.c.bottom = rectheight(*newr);
				vrect.p.lefttop = (PNT){0, 0};
				wset_wrk(wid, &vrect);
				do {
					wsta_dsp(wid, NULL, NULL);
				} while (wend_dsp(wid) > 0);
				gset_vis(gid, vrect);
				redisp(NULL);
			} else {
				vrect = *newr;
				gset_vis(gid, vrect);
			}
		}

		// ׵νʬ
		do {
			W	i;
			RECT	r;

			i = wsta_dsp(wid, &r, rlist);
			if (i <= 0) break;
			if (i > 4) {
				redisp(&r);
			} else {
				while (i--) {
					redisp(&rlist[i].rcomp);
				}
			}
		} while (wend_dsp(wid) > 0);

		// 䵸ͭǡؤȿ
		WINATTR	wattr = static_cast<WINATTR>(appl->fsn->get_wattr());

		if (mode == 5) {
			// ̥⡼ɤˤʤä
			wattr.fwindow = true;
		} else if ((newr != NULL) || (mode == 1)) {
			// Ѥä֤ư
			WDSTAT	wstat;

			wget_sts(wid, &wstat, NULL);
			wattr.rect = wstat.r;
			wattr.fwindow = false;
		}
		appl->fsn->set_wattr(wattr);
		appl->fsn->set_vpos(vrect.p.lefttop);
		sbar_setup();
		disp_caret(1);
	}

	return;
}


//
// Ͻ(window event)
//
W	MAINWIN::key_fn()
{
	W	rv;
	W	sts;			// text_in ư
	PNT	pepos;
	TEXTPORT*	tport = tin->get_tport();

	rv = 0;

	// ʴѴԤɽɸ
	tport->left = vrect.c.left;
	tport->right = vrect.c.right;
	tport->spos = appl->estr.cnv_crpos();
	pepos = tport->spos;

	// text_in μ¹
	do {
		// text_in  event Ϥ
		sts = read_text(tport, &wevt);

		// ư̤Ƚ
		if (sts & TXT_NOIMG) {
			// 褬ɬפˤʤä
			RECT	dr;

			if (tport->epos.x < pepos.x) {
				dr.c.left = tport->epos.x;
				dr.c.right = pepos.x;
			} else {
				dr.c.left = pepos.x;
				dr.c.right = tport->epos.x;
			}
			if (tport->epos.y < pepos.y) {
				dr.c.top = tport->epos.y;
				dr.c.bottom = pepos.y;
			} else {
				dr.c.top = pepos.y;
				dr.c.bottom = tport->epos.y;
			}
			redisp(&dr);
			if (sts & TXT_CNV) {
				redisp_text(tport);
			}
		}
		pepos = tport->epos;

		if (sts & TXT_EVT) {
			// ¾ event ΤǺᤷ
			// (text_in ϳѤߤ˰ܹԤƤ)
			unget_wevt();
		}

		if (sts & TXT_OUT) {
			// ʸȯ
			ins_str(tport->cnv, tport->n_cnv);
		} else if (sts & TXT_SCRL) {
			// ׵᤬ȯ
			kcnv_scroll(tport);
		}

		if (sts & TXT_KEY) {
			// ¾ΥϤԤ줿
			// (text_in ϳѤߤ˰ܹԤƤ)
			TC	code;

			code = wevt.e.data.key.code;
			if ((wevt.s.stat & ES_CMD) && (code > KC_SPACE)) {
				// [̿] Ϥʤ麹ᤷ
				unget_wevt();
			} else if ((code == KC_CC_L) || (code == KC_CC_R) ||
			           (code == KC_CC_U) || (code == KC_CC_D)) {
				act_KC_CC(code);
			} else if (code == KC_BS) {
				act_KC_BS();
			} else if ((code == KC_NL) || (code == KC_CR)) {
				ins_str(&code, 1);
			}
		}
	} while (sts & TXT_CNV);

	return rv;
}


//
// ܥץ쥹(window event)
//
W	MAINWIN::press_fn()
{
	appl->estr.cnv_pdpos(wevt.s.pos);
	car->move(appl->estr.cnv_crpos(), true);
	car_scroll(true);

	return 0;			//  0
}


//
// (window event)
//
void	MAINWIN::scroll_fn(W type, W diff)
{
	W	diff2;
	PNT	p;
	const	SIZE	lsize = appl->estr.get_layarea();
	 
	if ((type & 0x0c) == 0) {
		// smooth scroll  DLED Ʊ®٤Ĥ
		W       max;
 
		diff2 = CHSSTD * ((diff >> 1) + 1);
		max = ((type & 2) ? rectwidth(vrect) : rectheight(vrect)) >> 1;
		if (diff2 > max) {
			diff2 = max;
		}
	} else {
		diff2 = 0;
	}
	p = chk_scroll(type, diff, diff2, vrect, (RECT){{0, 0, lsize.h, lsize.v}});

	// ư̤ 0 λϤʤˤ⤷ʤ
	if ((p.x != 0) || (p.y != 0)) {
		scroll_work(p);
	}

	return;
}


// ---------------------------------------------------- MAINWIN  private ؿ
//
// Сͤꤹ
//
void	MAINWIN::sbar_setup()
{
	W	val[4];
	const	SIZE	lsize = appl->estr.get_layarea();

	// С(ľְư)
	val[0] = vrect.c.top;
	val[1] = vrect.c.bottom;
	val[2] = 0;
	val[3] = lsize.v;
	if (val[1] > val[3]) {
		val[1] = val[3];
	}
	cset_val(bar[0], 4, val);

	// С(ʿְư)
	val[0] = vrect.c.right;
	val[1] = vrect.c.left;
	val[2] = lsize.h;
	val[3] = 0;
	if (val[0] > val[2]) {
		val[0] = val[2];
	}
	cset_val(bar[1], 4, val);

	return;
}


//
// caret 褦 scroll 
//
void	MAINWIN::car_scroll(bool hscrl)
{
	// caret ɽ()Ȥλ
	RECT	cr;
	const	PNT	cp = appl->estr.cnv_crpos();

	cr.c.left = cp.x - CVAL::CH_HGAP;
	cr.c.top = cp.y - CHSSTD - CVAL::CH_VGAP;
	cr.c.right = cp.x + CVAL::CH_HGAP;
	cr.c.bottom = cp.y + CVAL::CH_VGAP;

	// ưư̤λ
	PNT	sp;

	if (hscrl) {
		// ʿư̤λ
		if (cr.c.left < vrect.c.left) {
			sp.x = vrect.c.left - cr.c.left + CVAL::CH_HGAP;
		} else if (cr.c.right > vrect.c.right) {
			sp.x = vrect.c.right - cr.c.right - CVAL::CH_HGAP;
		} else {
			sp.x = 0;
		}
	} else {
		sp.x = 0;
	}

	// ľư̤λ
	if (cr.c.top < vrect.c.top) {
		sp.y = vrect.c.top - cr.c.top + CVAL::CH_VGAP;
	} else if (cr.c.bottom > vrect.c.bottom) {
		sp.y = vrect.c.bottom - cr.c.bottom - CVAL::CH_VGAP;
	} else {
		sp.y = 0;
	}

	// scroll ȯ
	if ((sp.x != 0) || (sp.y != 0)) {
		scroll_work(sp);
	}

	return;
}


//
// ʴѴǤ scroll ׵
//
void	MAINWIN::kcnv_scroll(TEXTPORT* tport)
{
	// scroll ̤λ
	PNT	sp;

	if (tport->car->pos.x < vrect.c.left) {
		sp.x = vrect.c.left - tport->car->pos.x + CVAL::CH_HGAP;
	} else if (tport->car->pos.x > vrect.c.right) {
		sp.x = vrect.c.right - tport->car->pos.x - CVAL::CH_HGAP;
	} else {
		sp.x = 0;
	}
	if (tport->car->pos.y < vrect.c.top) {
		sp.y = vrect.c.top - tport->car->pos.y + CVAL::CH_VGAP;
	} else if (tport->car->pos.y > vrect.c.bottom) {
		sp.y = vrect.c.bottom - tport->car->pos.y - CVAL::CH_VGAP;
	} else {
		sp.y = 0;
	}
	scroll_work(sp);

	return;
}


//
// ʸ
//
void	MAINWIN::ins_str(TC* str, W len)
{
	// ʸμ
	W	l;
	TC*	ptr;
	TLANG	lng;
	std::vector<WTC>	istr;

	lng = TSC_SYS;
	for (l = 0; l < len; ++l) {
		TC	ch;

		ch = *str;
		if ((ch & TC_SPEC) == TC_LANG) {
			// /ץȻμ
			lng = isTLANG(str, l - len, &str);
		} else if ((ch == TC_NL) || (ch == TC_CR) || (ch >= 0x2121)) {
			// ʸ//
			istr.push_back(towtc(lng, ch));
			++str;
		}
	}

	// ʸ
	PNT	cp1, cp2;	// caret
	RECT	cr;

	cr = vrect;
	cp1 = appl->estr.cnv_crpos();
	appl->estr.ins_text(istr.begin(), istr.size());
	cp2 = appl->estr.cnv_crpos();
	cr.c.top = cp2.y - CHSSTD;
	car->off();
	if (cp1.y != cp2.y) {
		// ľιԤ
		cr.c.top = cp1.y - CHSSTD;
		wera_wnd(wid, &cr);
		appl->estr.cnv_pdpos(cp1);	// ξ
		appl->estr.disp_text(gid, vrect, 1);
		appl->estr.cnv_pdpos(cp2);	// ξ᤹
	} else {
		// ԤΤ
		cr.c.bottom = cp2.y + CVAL::CH_VGAP;
		wera_wnd(wid, &cr);
		appl->estr.disp_text(gid, vrect, 0);
	}

	// caret ֤ι
	car->move(appl->estr.cnv_crpos(), true);
	car_scroll(true);

	appl->eobj->set_editflg(true);	// 

	return;
}


//
// KC_CC_L/R/U/D εư(ES_CMD Ʊޤޤ)
//
void	MAINWIN::act_KC_CC(TC code)
{
	W	type;

	switch (code) {
		case KC_CC_L:
			type = 0;
			break;
		case KC_CC_R:
			type = 1;
			break;
		case KC_CC_U:
			type = 2;
			break;
		case KC_CC_D:
			type = 3;
			break;
		default:
			type = -1;
			break;
	}

	if (type >= 0) {
		// caret ΰư
		appl->estr.move_cidx(type);
		car->move(appl->estr.cnv_crpos(), true);
		car_scroll(true);
	}

	return;
}


//
// KC_BS εư
//
void	MAINWIN::act_KC_BS()
{
	PNT	cp1, cp2;	// õcaret
	RECT	cr;

	cr = vrect;
	cp1 = appl->estr.cnv_crpos();
	appl->estr.del_text();
	cp2 = appl->estr.cnv_crpos();
	cr.c.top = cp2.y - CHSSTD;
	car->off();
	if (cp1.y != cp2.y) {
		// ʹ
		wera_wnd(wid, &cr);
		appl->estr.disp_text(gid, vrect, 1);
	} else {
		// ԤΤ
		cr.c.bottom = cp2.y + CVAL::CH_VGAP;
		wera_wnd(wid, &cr);
		appl->estr.disp_text(gid, vrect, 0);
	}

	// caret ֤ι
	car->move(appl->estr.cnv_crpos(), true);
	car_scroll(true);

	appl->eobj->set_editflg(true);	// 

	return;
}
