//
//	guiope.cc (ʰʸԽ/GUI ɷϼ紴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"dbox.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"


// ------------------------------------------------------ GUIOPE  public ؿ
//
// constructor
//
GUIOPE::GUIOPE()
{
}


//
// destructor
//
GUIOPE::~GUIOPE()
{
}


//
// Ƽ class 
//
void	GUIOPE::init()
{
	ERR	er;

	try {
		// 
		evtope = std::auto_ptr<EVTOPE>(new EVTOPE());
		mwin = std::auto_ptr<MAINWIN>(new MAINWIN());
		menu = std::auto_ptr<MAINMENU>(new MAINMENU());

		// 
		mwin->open_win(appl->get_pwid(), appl->get_pr());
	} catch (EXCEPT_MAINWIN& err) {	// 祦ɥν˼
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_WINDOW, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_MAINMENU& err) {// ᥤ˥塼ν˼
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_MENU, er);
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// ¾
		throw;
	}

	return;
}


//
// ƴ class λ񸻤Ѵ
//
void	GUIOPE::dest()
{
	// 祦ɥλ񸻤γؼ
	mwin->close_win();

	return;
}
