//
//	fusen.cc (ʰʸԽ/䵴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/cnvend.h>

#include	"cval.h"		// macro.h ɬ
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"macro.h"

#include	"fusen.h"


// ------------------------------------------------------- FUSEN  public ؿ
//
// constructor
//
FUSEN::FUSEN(const MESSAGE* msg)
{
	UH*	ptr;			// omgr Ƥ pointer
	T_TXEDIT_FUSEN	buf;
	const	M_EXECREQ*	exreq =reinterpret_cast<const M_EXECREQ*>(msg);

	fsn = DEF_FUSEN;

	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			if ((exreq->mode & 0x03) != 0x00) {
				// 䵸ͭǡɤ߹
				W	fd;
				WERR	rv;

				fd = opn_fil((LINK*)&exreq->lnk, F_READ, NULL);
				if (fd < ER_OK) {
					throw EXCEPT_FUSEN(fd);
				}
				rv = oget_fsn(exreq->vid, fd, &buf, sizeof(T_TXEDIT_FUSEN));
				cls_fil(fd);
				if (rv < ER_OK) {
					throw EXCEPT_FUSEN(rv);
				}
				break;
			}
		case DISPREQ:		// Ȥɽư
		case TADREQ:		// Ȥ TAD ǡư
		case PASTEREQ:		// ǡŽߵư
			ptr = reinterpret_cast<UH*>(exreq->info);
			goto GET_DATA;
		case FUSENREQ:		// 䵤Υץư
			ptr = reinterpret_cast<UH*>((reinterpret_cast<const M_FUSENREQ*>(msg))->info);
GET_DATA:
			// ¿Ȳȥޥ͡δ
			W	size;	// omgr Ƥ礭(byte ñ)

			size = *ptr + sizeof(UH);
			if (size > sizeof(T_TXEDIT_FUSEN)) {
				// ϰϤĶƤϼФʤ
				size = sizeof(T_TXEDIT_FUSEN);
			}
			memcpy(&buf, ptr, size);
			break;
		default:		// cli ưʤɤΤ¾ξ
			// ä˲⤷ʤ
			break;
	}

	// 䵤Ǥγǧ䵤ɤ߹(ɤƤʤнͤΤޤ)
	if ((buf.dlen >= T_TXEDIT_FUSEN_DLEN) &&
	    (ConvEndianH(buf.ver) == T_TXEDIT_FUSEN_VERSION)) {
		ConvEndianStruct(&fsn, &buf, T_TXEDIT_FUSEN_STRUCT, sizeof(T_TXEDIT_FUSEN));
	}

	// Ƥ򵭲Ƥ
	org = fsn;
}


//
// destructor
//
FUSEN::~FUSEN()
{
}


//
// 䵤ؤν񤭹
//
// eflg == true : oend_prc() ȯ
//
W	FUSEN::write_fusen(const MESSAGE* msg, W vid, bool eflg)
{
	W	upd;
	W	vgid;

	upd = (memcmp(&fsn, &org, sizeof(T_TXEDIT_FUSEN)) != 0) ? 1 : 0;
	vgid = 0;

	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			if (upd == 1) {
				// 䵸ͭǡι
				W	fd;
				const	M_EXECREQ*	exreq = reinterpret_cast<const M_EXECREQ*>(msg);

				fd = opn_fil((LINK*)&exreq->lnk,F_UPDATE,NULL);
				if (fd < ER_OK) {
					if (eflg) {
						// omgrǤ⹹Ϥ
						vgid = oend_prc(vid, &fsn,upd);
					}
					throw EXCEPT_FUSEN(fd);
				}
				fsn.dlen = T_TXEDIT_FUSEN_DLEN;
				oput_fsn(vid, fd, &fsn);
				cls_fil(fd);
			}
		case FUSENREQ:		// 䵤Υץư
			if (eflg) {
				vgid = oend_prc(vid, &fsn, upd);
			}
			break;
		case DISPREQ:		// Ȥɽư
		case TADREQ:		// Ȥ TAD ǡư
		case PASTEREQ:		// ǡŽߵư
			// ä˲⤷ʤ
			break;
		default:		// cli ưʤɤΤ¾ξ
			// ä˲⤷ʤ
			break;
	}

	// ߤξ֤򸵡ƤȤƵ
	org = fsn;

	return vgid;
}
