//
//	evtope.cc (ʰʸԽ/٥ɷϼ紴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<errcode.h>
#include	<keycode.h>

#include	<new>

#include	"dbox.h"
#include	"val.h"
#include	"cval.h"
#include	"macro.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"
#include	"saveope.h"


// ----------------------------------------- EVTOPE  static member ѿμ
//bool	EVTOPE::pflg = false;
WFUNCREC	EVTOPE::wfunc;
WINFOREC	EVTOPE::winfo[CVAL::WIN_NUM + 1];


// ------------------------------------------------------ EVTOPE  public ؿ
//
// constructor
//
EVTOPE::EVTOPE()
{
	// ɥ쥳ɤν
	W	l;

	for (l = 0; l <= CVAL::WIN_NUM; ++l) {
		winfo[l] = DEF_WINFO;
	}
	winfo[CVAL::WIN_NUM].wid = 0;

	// ɥ٥ȴؿơ֥
	wfunc.bgfn = NULL;		// Хå饦ɽ
	wfunc.idlefn = evt_idle;	// ɥ
	wfunc.msgfn = NULL;		// ̥å
	wfunc.menufn = evt_menu;	// ˥塼٥
	wfunc.dspfn = evt_disp;		// ɽ׵
	wfunc.stsfn = evt_chgsts;	// Ѳ
	wfunc.keyfn = evt_key;		// Ͻ
	wfunc.presfn = evt_press;	// ܥץ쥹
	wfunc.finfn = evt_finish;	// λ׵
	wfunc.pastefn = NULL;		// Ž׵
	wfunc.respfn = NULL;		// ׵
	wfunc.scrlfn = evt_scroll;	// 
	wfunc.devfn = NULL;		// ǥХ٥Ƚ
	wfunc.vobjfn = NULL;		// ׵ᥤ٥
}


//
// destructor
//
EVTOPE::~EVTOPE()
{
}


// --------------------------------------- EVTOPE  public ؿ(static member)
//
// event loop 
//
ERR	EVTOPE::eventloop()
{
	ERR	er;

	er = ER_OK;
	try {
		WERR	rv;

		rv = evt_loop(&wfunc, winfo);
		er = (rv >= ER_OK) ? ER_OK : rv;
	} catch (...) {			// ϤäƤϤʤʤ
		DPRINT(("!! CAUTION !! : evt_loop() was gone to down by exception.\n"));
		throw;
	}
	switch (er) {
		case ER_SYS:
			errpanel(DBOX::EPNL_SYSTEM, 0);
			break;
	}

	return er;
}


//
// 
//
void	EVTOPE::evt_idle()
{
	// ̤
	bool	pdflg;			// PD ϼ祦ɥ˰¸

	pdflg = false;
	if ((!(wevt.s.stat & (ES_CMD | ES_BUT2))) &&
	    (wevt.s.wid == winfo[CVAL::WIDX_MAINWIN].wid) &&
	    (wevt.s.cmd == W_WORK)) {
		if (cidl_par(wevt.s.wid, &wevt.s.pos) == 0) {
			pdflg = true;
		}
	}

	// ɥ˲
	appl->gui->mwin->idle_fn(pdflg);

	return;
}


//
// ˥塼٥
//
W	EVTOPE::evt_menu()
{
	return appl->gui->menu->exec();
}


//
// ɽ
//
void	EVTOPE::evt_disp(W ix, W mode, RECT* newr)
{
	appl->gui->mwin->disp_fn(mode, newr);

	return;
}


//
// Ѳ
//
void	EVTOPE::evt_chgsts(W ix, W sts)
{
	setpointer(0x8000, NULL);
	if (sts != 0x100) {
		// ѡĤ(evt_loop() ɽȤƤ뤿)
		cdsp_pwd(appl->gui->mwin->get_wid(), NULL, P_RDISP);
		if (sts == 2) {		// W_SWITCH Žߤβǽ
			;
		}
	}

	// caret 
	if (sts <= 0) {
		appl->gui->mwin->disp_caret(0);
	} else {
		appl->gui->mwin->disp_caret(1);
	}

	return;
}


//
// Ͻ
//
W	EVTOPE::evt_key()
{
	W	rv;

	if ((wevt.s.stat & ES_CMD) && (wevt.e.data.key.code > KC_SPACE)) {
		// [̿] Ʊʤ饭ޥ
		rv = appl->gui->menu->exec();
	} else {
		// ̾ key Ͻ
		rv = appl->gui->mwin->key_fn();
	}

	return rv;
}


//
// ܥץ쥹
//
W	EVTOPE::evt_press(W ix)
{
	W	rv;

	rv = appl->gui->mwin->press_fn();

	return rv;
}


//
// λ׵
//
W	EVTOPE::evt_finish(W ix, W mode)
{
	W	rv;

	rv = 1;				// ʤϼ֤ˤ
	try {
		std::auto_ptr<SAVEOPE>	save;

		if (mode == 1) {
			// W_DELETE(¸λ)
			save = std::auto_ptr<SAVEOPE>(new SAVEOPE());
		} else if (mode == 2) {
			// W_FINISH(¸λ)
			throw EXCEPT_SAVEOPE(T_TXEDITERR::NO_ALLSAVE);
		} else {
			// ¾(Ūʽλ)
			save = std::auto_ptr<SAVEOPE>(new SAVEOPE(true));
		}

		// ¸μ¹
		save->main();
	} catch (EXCEPT_SAVEOPE& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if (rv == T_TXEDITERR::NO_ALLSAVE) {
			// ¸λ(䵸ͭǡ¿Ȥ⹹ʤ)
			appl->fsn->undo_fusen();
			rv = 1;
		} else if (rv == T_TXEDITERR::NO_UPDATE) {
			// ¸λ(䵸ͭǡϹ)
			rv = 1;
		} else if (rv == T_TXEDITERR::SAVE_CANCEL) {
			// λ(ä)
			rv = 0;
		} else if ((rv == ER_NOMEM) || (rv == ER_NOSPC)) {
			// memory allocation error
			errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
			rv = 0;
		} else {
			// 
			errpanel(DBOX::EPNL_WRITE, rv);
			rv = 0;
		}
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		rv = 0;
	} catch (...) {
		DPRINT(("other exception.\n"));
		rv = ER_SYS;
	}

	return rv;
}


//
// 
//
void	EVTOPE::evt_scroll(W ix, W type, W diff)
{
	appl->gui->mwin->scroll_fn(type, diff);

	return;
}
