//
//	mainwin.h (ѡ/祦ɥɷϥإå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_PARSAMP_MAINWIN_H
#define	_PARSAMP_MAINWIN_H

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>

#include	"struct.h"


// -------------------------------------------------------------- class MAINWIN
class	MAINWIN {
	enum PTIDX {			// ɥֹ
		PTIDX_STR_STR   = 0,	// [ʸ]
		PTIDX_TB_STR1   = 1,	// ʸ TB_PARTS (1)
		PTIDX_TB_STR2   = 2,	// ʸ TB_PARTS (2)
		PTIDX_AS_ENABLE = 3,	// [ͭ]
		PTIDX_STR_COLOR = 4,	// []
		PTIDX_SS_COLOR  = 5,	//  SS_PARTS
		PTIDX_STR_SIZE  = 6,	// []
		PTIDX_VL_SIZE   = 7,	//  VL_PARTS
		PTIDX_SB_SIZE   = 8,	//  SB_PARTS
		PTIDX_STR_PITCH = 9,	// [ԥå]
		PTIDX_WS_PITCH  = 10,	// ԥå WS_PARTS
		PTIDX_MS_INIT   = 11,	// []

		PTIDX_ALL = 12		// 
	};

	#define	PTMASK(n)	(1 << n)
	enum PTMSK {			// ɥܤΥޥ
		PTMSK_STR_STR   = PTMASK(PTIDX_STR_STR),
		PTMSK_TB_STR1   = PTMASK(PTIDX_TB_STR1),
		PTMSK_TB_STR2   = PTMASK(PTIDX_TB_STR2),
		PTMSK_AS_ENABLE = PTMASK(PTIDX_AS_ENABLE),
		PTMSK_STR_COLOR = PTMASK(PTIDX_STR_COLOR),
		PTMSK_SS_COLOR  = PTMASK(PTIDX_SS_COLOR),
		PTMSK_STR_SIZE  = PTMASK(PTIDX_STR_SIZE),
		PTMSK_VL_SIZE   = PTMASK(PTIDX_VL_SIZE),
		PTMSK_SB_SIZE   = PTMASK(PTIDX_SB_SIZE),
		PTMSK_STR_PITCH = PTMASK(PTIDX_STR_PITCH),
		PTMSK_WS_PITCH  = PTMASK(PTIDX_WS_PITCH),
		PTMSK_MS_INIT   = PTMASK(PTIDX_MS_INIT),

		PTMSK_ALL = 0xffffffff	// 
	};

	// ѡɴؿδ
	typedef	ERR	(MAINWIN::*PAR_FN)(W pid, W pidx);

public:
	MAINWIN();			// constructor
	~MAINWIN();			// destructor

	// window ID μ
	const	W	get_wid() {return wid;}

	// ɥ򳫤
	void	open_win(const W pwid, const RECT* pr);

	// ɥĤ
	void	close_win();

	// ѡĤ
	void	par_create();

	// ѡĤѴ
	void	par_destroy();

	// ᤹ͤ
	void	init_data();

	// ȥ졼ʣ/ưƤ뤫ǧ
	bool	chk_totray();

	// ʸ
	void	del_string();

	// (ޤ)ȥ졼ͳǤΥȥ졼ʣ/ưμ¹
	void	do_pushtray(bool tmp, bool cut);

	// (ޤ)ȥ졼ͳǤΥȥ졼ʣ/ưμ¹
	void	do_poptray(bool tmp, bool cut);

	// 
	void	redisp(RECT* r = NULL);

	// event loop 
	void	idle_fn();
	void	disp_fn(W mode, RECT* newr);
	W	key_fn();
	W	press_fn();
	W	paste_fn(PNT pos);

private:
	W	wid;			// window ID
	W	gid;			// window Ķ ID
	W	actbox;			// ¹ԤƤ٤ܥåϥѡ
	W	pactbox;		// Žߤ줿ֹ
	PNT	ppos;			// Žߤ줿κɸ
	RECT	vrect;			// ΰ
	WINDEF	wdef;			// ɥ
	RLIST	rlist[4];		// ʬΰ
	PAR_FN	par_fn[PTIDX_ALL];	// ѡɴؿ
	PNL_ITEM	parts[PTIDX_ALL];	// ѡĴ

	// ʸκ
	void	disp_string();

	// ɥǤʸΰư/ʣ
	void	str_move(W pid, bool cut);

	// ѡľ֤ν
	void	par_setup(UW msk = PTMSK_ALL);

	// ѡĤξ֤
	void	par_getdat(UW msk = PTMSK_ALL);

	// ѡĤưؿ
	ERR	p_tb_str1_fn(W pid, W pidx);
	ERR	p_tb_str2_fn(W pid, W pidx);
	ERR	p_as_enable_fn(W pid, W pidx);
	ERR	p_ss_color_fn(W pid, W pidx);
	ERR	p_vl_size_fn(W pid, W pidx);
	ERR	p_sb_size_fn(W pid, W pidx);
	ERR	p_ws_pitch_fn(W pid, W pidx);
	ERR	p_ms_init_fn(W pid, W pidx);
};

#endif	// _PARSAMP_MAINWIN_H
