//
//	mainwin.cc (ѡ/祦ɥɷ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//
//	-DSB_CEXE_USE : SB_PARTS μ¹Ԥ cexe_par() Ѥ
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<btron/cnvend.h>
#include	<bstring.h>
#include	<errcode.h>
#include	<keycode.h>
#include	<tlang.h>
#include	<tstring.h>

#include	<new>
#include	<memory>
#include	<vector>

#include	"val.h"
#include	"cval.h"
#include	"dbox.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"
#include	"trayope.h"


// ----------------------------------------------------- MAINWIN  public ؿ
//
// constructor
//
MAINWIN::MAINWIN()
	: wid(-1), gid(-1), actbox(PTIDX_TB_STR1), pactbox(-1)
{
	// ɥǡμФ
	ConvEndianStruct(&wdef, getdbox(DBOX::DEF_MAINWIN), WINDEF_STRUCT, sizeof(wdef));

	// ѡǡμФ(ϿϤޤʤ)
	W	l;
	PNL_ITEM*	ptr;

	ptr = reinterpret_cast<PNL_ITEM*>(ptrdbox(wdef.parts));
	for (l = 0; l < wdef.pnum; ++l) {
		ConvEndianStruct(&parts[l], &ptr[l], PNL_ITEM_STRUCT, sizeof(PNL_ITEM));
		parts[l].desc = 0;
		if (parts[l].ptr != 0) {
			parts[l].ptr = reinterpret_cast<H*>(ptrdbox((W)parts[l].ptr));
		}
		adjscalr(&parts[l].ir);	// ɸѴ˹Ԥ
	}

        // ѡɴؿơ֥ν
	par_fn[PTIDX_STR_STR] = NULL;
	par_fn[PTIDX_TB_STR1] = &MAINWIN::p_tb_str1_fn;
	par_fn[PTIDX_TB_STR2] = &MAINWIN::p_tb_str2_fn;
	par_fn[PTIDX_AS_ENABLE] = &MAINWIN::p_as_enable_fn;
	par_fn[PTIDX_STR_COLOR] = NULL;
	par_fn[PTIDX_SS_COLOR] = &MAINWIN::p_ss_color_fn;
	par_fn[PTIDX_STR_SIZE] = NULL;
	par_fn[PTIDX_VL_SIZE] = &MAINWIN::p_vl_size_fn;
	par_fn[PTIDX_SB_SIZE] = &MAINWIN::p_sb_size_fn;
	par_fn[PTIDX_STR_PITCH] = NULL;
	par_fn[PTIDX_WS_PITCH] = &MAINWIN::p_ws_pitch_fn;
	par_fn[PTIDX_MS_INIT] = &MAINWIN::p_ms_init_fn;

	// ¾ν
	genrectlist(4, rlist);
	ppos = (PNT){0, 0};
}


//
// destructor
//
MAINWIN::~MAINWIN()
{
	if (wid >= 0) {
		cdel_pwd(wid, CLR);
		odel_vob(-wid, CLR);
		wcls_wnd(wid, CLR);
	}
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;
}


//
// ɥ򳫤
//
void	MAINWIN::open_win(const W pwid, const RECT* pr)
{
	// ɥξꤹ
	const	PNT	p = appl->fsn->get_wpos();

	vrect.c.left = wdef.r.c.left + p.x;
	vrect.c.top = wdef.r.c.top + p.y;
	vrect.c.right = wdef.r.c.right + p.x;
	vrect.c.bottom = wdef.r.c.bottom + p.y;

	// ɥ򳫤
	wid = wopn_wnd(wdef.attr, pwid, &vrect, (RECT*)pr, CVAL::PARSAMP_PICT, wdef.title, (PAT*)WI_PANELBACK, NULL);
	if (wid < ER_OK) {
		throw EXCEPT_MAINWIN(wid);
	}
	DPRINT(("wid : %d\n", wid));

	// ɽν
	COLOR	bgcol = CVAL::COL_TRANS;

	gid = wget_gid(wid);
	gset_vis(gid, vrect);
	wget_inf(WI_GSBGC(WI_PANELBACK), &bgcol, sizeof(bgcol));
	gset_chc(gid, CVAL::RGB_BLACK, bgcol);

	// ɥ쥳ɤϿ
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = wid;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].chgmod = 0x20;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].limit = (RECT){{0, 0, 0, 0}};
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[0] = -1;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[1] = -1;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[2] = -1;

	return;
}


//
// ɥĤ
//
void	MAINWIN::close_win()
{
	cdel_pwd(wid, CLR);
	wcls_wnd(wid, CLR);
	wid = -1;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;

	return;
}


//
// ѡĤ
//
void	MAINWIN::par_create()
{
	W	l;
	SWSEL*	sw;
 
	for (l = 0; l < wdef.pnum; ++l) {
		// PARTS_ITEM ʳ̵
		if ((parts[l].itype & 0x000f) != PARTS_ITEM) {
			continue;
		}
 
		// ѡĤϿ
		sw = reinterpret_cast<SWSEL*>(parts[l].ptr);
		switch (sw->type & P_TYPE) {
			case 4:		// SB_PARTS
				offtoptr((UW*)&(((SERBOX*)sw)->fmt));
				offtoptr((UW*)&(((SERBOX*)sw)->cv));
				break;
			case 1:		// TB_PARTS
			case 2:		// XB_PARTS
			case 5:		// AS_PARTS
			case 6:		// MS_PARTS
			case 9:		// WS_PARTS
			case 10:	// SS_PARTS
				offtoptr((UW*)&(sw->name));
				break;
#if	0				// Ѵ
			case 3:		// NB_PARTS
			case 7;		// PA_PARTS
			case 8:		// PM_PARTS
			case 11:	// VL_PARTS
				break;
#endif	// 0
		}
		adjscalr(&sw->r);
		parts[l].desc = ccre_par(wid, (PARTS*)sw);
		if (parts[l].desc < ER_OK) {
			throw EXCEPT_MAINWIN(parts[l].desc);
		}
		DPRINT(("parts[%d] : %d\n", l, parts[l].desc));
 
		// ֤ư
		parts[l].ir.c.right = parts[l].ir.c.left + rectwidth(sw->r);
		parts[l].ir.c.bottom = parts[l].ir.c.top + rectheight(sw->r);
		cset_pos(parts[l].desc, &parts[l].ir);

		// VL_PARTS  P_DRAGBREAK ˤƤ
		if ((sw->type & P_TYPE) == VL_PARTS) {
			cchg_par(parts[l].desc, P_DRAGBREAK);
		}
	}

	return;
}


//
// ѡĤѴ
//
void	MAINWIN::par_destroy()
{
	W	l;

	for (l = 0; l < wdef.pnum; ++l) {
		if (parts[l].desc >= 0) {
			cdel_par(parts[l].desc, CLR);
			parts[l].desc = 0;
		}
	}

	return;
}


//
// ᤹ͤ
//
void	MAINWIN::init_data()
{
	const	PNT	wp = appl->fsn->get_wpos();

	appl->fsn->init_fusen();
	appl->fsn->set_wpos(wp);
	par_setup(PTMSK_ALL);

	return;
}


//
// ȥ졼ʣ/ưǤƤ뤫ǧ
//
bool	MAINWIN::chk_totray()
{
	W	len;

	len = 0;
	if ((actbox == PTIDX_TB_STR1) || (actbox == PTIDX_TB_STR2)) {
		len = ccut_txt(parts[actbox].desc, 0, NULL, 0);
	}

	return (len > 0);
}


//
// ʸ
//
void	MAINWIN::del_string()
{
	if ((actbox == PTIDX_TB_STR1) || (actbox == PTIDX_TB_STR2)) {
		TC	dmy;

		ccut_txt(parts[actbox].desc, 1, &dmy, 1);
	}

	return;
}


//
// (ޤ)ȥ졼ͳǤΥȥ졼ʣ/ưμ¹
//
void	MAINWIN::do_pushtray(bool tmp, bool cut)
{
	if ((actbox == PTIDX_TB_STR1) || (actbox == PTIDX_TB_STR2)) {
		TRAYOPE::push_tray(parts[actbox].desc, tmp, cut);
	}

	return;
}


//
// (ޤ)ȥ졼ͳǤΥȥ졼ʣ/ưμ¹
//
void	MAINWIN::do_poptray(bool tmp, bool cut)
{
	if ((pactbox == PTIDX_TB_STR1) || (pactbox == PTIDX_TB_STR2)) {
		// ȥ졼ͳξ֤äΤǡФ
		actbox = pactbox;
	}

	if ((actbox == PTIDX_TB_STR1) || (actbox == PTIDX_TB_STR2)) {
		W	len;

		len = TRAYOPE::pop_tray(parts[actbox].desc, tmp, cut, ppos);
		if ((len <= 0) && (!(tmp))) {
			errpanel(DBOX::EPNL_POPTRAY, 0);
		}
	}

	// ȥ졼ͳξϽƤ
	ppos = (PNT){0, 0};
	pactbox = -1;

        return;
}


//
// 
//
void	MAINWIN::redisp(RECT* r)
{
	RECT	vr;

	gget_vis(gid, &vr);

	// 
	wera_wnd(wid, r);
	if (r != NULL) {
		gset_vis(gid, *r);
	}
	cdsp_pwd(wid, r, P_RDISP);
	disp_string();

	gset_vis(gid, vr);

	return;
}


//
// (window event)
//
void	MAINWIN::idle_fn()
{
	// ¹ԤƤ٤ܥåϥѡĤ¹Ԥ
	if (actbox >= 0) {
		if (this->*par_fn[actbox] != NULL) {
			(this->*par_fn[actbox])(parts[actbox].desc, actbox);
		}
	}

	return;
}


//
// ɽ(window event)
//
void	MAINWIN::disp_fn(W mode, RECT* newr)
{
	if (mode < 0) {
		// 
		par_setup(PTMSK_ALL);
		redisp(NULL);
	} else {
		// ¾κ
		do {
			W	i;
			RECT	r;

			i = wsta_dsp(wid, &r, rlist);
			if (i <= 0) break;
			if (i > 4) {
				redisp(&r);
			} else {
				while (i--) {
					redisp(&rlist[i].rcomp);
				}
			}
		} while (wend_dsp(wid) > 0);

		// 䵸ͭǡؤȿ
		if ((mode == 1) || (mode == 8) || (mode == 9)) {
			// ֤ư
			WDSTAT  wstat;

			wget_sts(wid, &wstat, NULL);
			appl->fsn->set_wpos(wstat.r.p.lefttop);
		}
	}

	return;
}


//
// Ͻ(window event)
//
W	MAINWIN::key_fn()
#ifdef	SB_CEXE_USE			// cexe_par() Ѥ
{
	W	rv;

	rv = ER_OK;
	if (actbox == PTIDX_SB_SIZE) {
		rv = (this->*par_fn[actbox])(parts[actbox].desc, actbox);
	}

	return rv;
}
#else	// SB_CEXE_USE			// cexe_par() Ѥʤ
{
	// äˤʤˤ⤷ʤ

	return 0;			//  0
}
#endif	// SB_CEXE_USE


//
// ܥץ쥹(window event)
//
W	MAINWIN::press_fn()
{
	W	rv;
	W	pid;
 
	rv = ER_OK;
	cfnd_par(wid, wevt.s.pos, &pid);
	if (pid != 0) {
		// Υѡľ
		W	l;

		for (l = 0; l < wdef.pnum; ++l) {
			if (pid == parts[l].desc) {
				if (this->*par_fn[l] != NULL) {
					rv = (this->*par_fn[l])(pid, l);
				}
				break;
			}
		}
	}

        return rv;
}
 
 
//
// Ž׵(window event)
//
W	MAINWIN::paste_fn(PNT pos)
{
	W	rv;
	W	pid;
	PNT	p;

        rv = W_NAK;
	p = UWtoPNT(wevt.s.time);	// libapp ǤεȤ
	pactbox = -1;

	pid = 0;
	cfnd_par(wid, p, &pid);
	if (pid == parts[PTIDX_TB_STR1].desc) {
		pactbox = PTIDX_TB_STR1;
	} else if ((pid == parts[PTIDX_TB_STR2].desc) &&
		   (appl->fsn->get_enable())) {
		pactbox = PTIDX_TB_STR2;
	}

	if (pactbox >= 0) {
		// TB_PARTS ʤƤɾ򤷤Ƥɽ
		if (TRAYOPE::pop_tray(-1, true, false, p) > 0) {
			ppos = p;
			wevt.s.pos = toPNT(0x8000, 0x8000);
			rv = W_ACK;
		}
	}

	return rv;
}


// ---------------------------------------------------- MAINWIN  private ؿ
//
// ʸκ
//
void	MAINWIN::disp_string()
{
	W	l;

	for (l = 0; l < wdef.pnum; ++l) {
		// TEXT_ITEM ʳɽоݤˤʤ
		if (((parts[l].itype & 0x000f) != TEXT_ITEM) ||
		    (parts[l].ptr == NULL)) {
			continue;
		}

		gset_scr(gid, TSC_SYS);
		gdra_stp(gid,
			parts[l].ir.c.left, parts[l].ir.c.top + CHSSTD,
			(TC*)parts[l].ptr, tc_strlen((TC*)parts[l].ptr),
			G_STORE);
	}

	// ˵(ʸǤϤʤ)
	PNT	p1, p2;

	p1.x = parts[PTIDX_TB_STR2].ir.c.right;
	p1.y = parts[PTIDX_TB_STR2].ir.c.top + (rectheight(parts[PTIDX_TB_STR2].ir) >> 1);
	p2.x = parts[PTIDX_AS_ENABLE].ir.c.left - 1;
	p2.y = p1.y;
	gdra_lin(gid, p1, p2, 0x0001, BLACK100, G_STORE);

        return;  
}


//
// ɥǤʸΰư/ʣ
//
void	MAINWIN::str_move(W pid, bool cut)
{
	W	dpid;

	dpid = 0;
	cfnd_par(wid, wevt.s.pos, &dpid);
	if (pid != dpid) {
		WERR	rv;
		W	abox;		// μ¹ԥѡĤθ
		TC	buf[CVAL::STR_LEN + 1];

		rv = ER_OK;
		ccut_txt(pid, CVAL::STR_LEN + 1, buf, 0);
		if (dpid == parts[PTIDX_TB_STR1].desc) {
			// ʸ1 Ф
			rv = cins_txt(dpid, wevt.s.pos, buf);
			abox = PTIDX_TB_STR1;
		} else if ((dpid == parts[PTIDX_TB_STR2].desc) && 
			   (appl->fsn->get_enable())) {
			// ʸ2 Ф
			rv = cins_txt(dpid, wevt.s.pos, buf);
			abox = PTIDX_TB_STR2;
		}

		// 
		if (rv > 0) {
			if (cut) {
				ccut_txt(pid, 1, buf, 1);
			}
			actbox = abox;
		}
	}

	return;
}


//
// ѡľ֤ν(䵸ͭǡƤȿ)
//
void	MAINWIN::par_setup(UW msk)
{
	W	val[4];			// (ѡĤͤ)

	// ʸ1 
	if (msk & PTMSK_TB_STR1) {
		cset_val(parts[PTIDX_TB_STR1].desc, CVAL::STR_LEN, (W*)appl->fsn->get_str1());
	}

	// ʸ2 
	if (msk & PTMSK_TB_STR2) {
		cset_val(parts[PTIDX_TB_STR2].desc, CVAL::STR_LEN, (W*)appl->fsn->get_str2());
		cchg_par(parts[PTIDX_TB_STR2].desc, (appl->fsn->get_enable()) ? P_ENABLE : P_DISABLE);
	}

	// ͭ/ǽ
	if (msk & PTMSK_AS_ENABLE) {
		val[0] = (appl->fsn->get_enable()) ? 1 : 0;
		cset_val(parts[PTIDX_AS_ENABLE].desc, 1, val);
	}

	// 
	if (msk & PTMSK_SS_COLOR) {
		val[0] = appl->fsn->get_color() + 1;
		cset_val(parts[PTIDX_SS_COLOR].desc, 1, val);
	}

	// (VL_PARTS)
	if (msk & PTMSK_VL_SIZE) {
		val[1] = appl->fsn->get_size();
		val[0] = val[1] + 1;
		cset_val(parts[PTIDX_VL_SIZE].desc, 2, val);
	}

	// (SB_PARTS)
	if (msk & PTMSK_SB_SIZE) {
		val[0] = appl->fsn->get_size();
		cset_val(parts[PTIDX_SB_SIZE].desc, 1, val);
	}

	// ԥå
	if (msk & PTMSK_WS_PITCH) {
		val[0] = (appl->fsn->get_pitch()) ? 2 : 1;
		cset_val(parts[PTIDX_WS_PITCH].desc, 1, val);
	}

	return;
}



//
// ѡĤξ֤(䵸ͭǡƤ)
//
void	MAINWIN::par_getdat(UW msk)
{
	W	val[4];			// (ѡĤͤμ)
	TC	str[CVAL::STR_LEN + 1];

	// ʸ1 μ
	if (msk & PTMSK_TB_STR1) {
		cget_val(parts[PTIDX_TB_STR1].desc, CVAL::STR_LEN + 1, (W*)str);
		appl->fsn->set_str1(str);
	}

	// ʸ2 μ
	if (msk & PTMSK_TB_STR2) {
		cget_val(parts[PTIDX_TB_STR2].desc, CVAL::STR_LEN + 1, (W*)str);
		appl->fsn->set_str2(str);
	}

	// ͭ/ǽμ
	if (msk & PTMSK_AS_ENABLE) {
		cget_val(parts[PTIDX_AS_ENABLE].desc, 1, val);
		appl->fsn->set_enable(val[0] == 1);
	}

	// μ
	if (msk & PTMSK_SS_COLOR) {
		cget_val(parts[PTIDX_SS_COLOR].desc, 1, val);
		appl->fsn->set_color(val[0] - 1);
	}

	// μ(VL_PARTS)
	if (msk & PTMSK_VL_SIZE) {
		cget_val(parts[PTIDX_VL_SIZE].desc, 2, val);
		appl->fsn->set_size(val[1]);
	}

	// μ(SB_PARTS)
	if (msk & PTMSK_SB_SIZE) {
		cget_val(parts[PTIDX_SB_SIZE].desc, 1, val);
		appl->fsn->set_size(val[0]);
	}

	// ԥåμ
	if (msk & PTMSK_WS_PITCH) {
		cget_val(parts[PTIDX_WS_PITCH].desc, 1, val);
		appl->fsn->set_pitch(val[0] == 2);
	}

	return;
}


//
// ʸ TB_PARTS (1) ưؿ
//
ERR	MAINWIN::p_tb_str1_fn(W pid, W pidx)
{
	ERR	er;
	W	sts;

	er = ER_OK;
	actbox = pidx;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {	
		er = sts;
	} else if ((sts == P_EVENT) || (sts == P_MENU)) {
		par_getdat(PTMASK(pidx));
		unget_wevt();
	} else {
		par_getdat(PTMASK(pidx));

		// ληγǧ
		sts &= 0x0007;
		if ((sts == P_MOVE) || (sts == P_COPY)) {
			// ϰϤ drag
			if (wevt.s.wid == wid) {
				// ɥǤμ
				str_move(pid, (sts == P_MOVE));
			} else  {
				// ¾Υɥذȥ졼ͳǰư/ʣ
				do_pushtray(true, (sts == P_MOVE));
			}
		} else if (sts == P_NL) {
			// 
			;		// ä˲⤷ʤ
		} else if (sts == P_TAB) {
			// TAB (ΥܥåϥѡĤ focus ư)
			actbox = (appl->fsn->get_enable()) ? PTIDX_TB_STR2 : PTIDX_SB_SIZE;
		} else if (sts == P_BUT) {
			// ѡΰ賰 click
			unget_wevt();
		}
	}

	return er;
}


//
// ʸ TB_PARTS (2) ưؿ
//
ERR	MAINWIN::p_tb_str2_fn(W pid, W pidx)
{
	ERR	er;
	W	sts;

	er = ER_OK;
	actbox = pidx;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {	
		er = sts;
	} else if ((sts == P_EVENT) || (sts == P_MENU)) {
		par_getdat(PTMASK(pidx));
		unget_wevt();
	} else {
		par_getdat(PTMASK(pidx));

		// ληγǧ
		sts &= 0x0007;
		if ((sts == P_MOVE) || (sts == P_COPY)) {
			// ϰϤ drag
			if (wevt.s.wid == wid) {
				// ɥǤμ
				str_move(pid, (sts == P_MOVE));
			} else  {
				// ¾Υɥذȥ졼ͳǰư/ʣ
				do_pushtray(true, (sts == P_MOVE));
			}
		} else if (sts == P_NL) {
			// 
			;		// ä˲⤷ʤ
		} else if (sts == P_TAB) {
			// TAB (ΥܥåϥѡĤ focus ư)
			actbox = PTIDX_SB_SIZE;
		} else if (sts == P_BUT) {
			// ѡΰ賰 click
			unget_wevt();
		}
	}

	return er;
}


//
// ͭǽڤؤ AS_PARTS ưؿ
//
ERR	MAINWIN::p_as_enable_fn(W pid, W pidx)
{
	ERR	er;
	W	sts;

	er = ER_OK;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {
		er = sts;
	} else if (sts & P_CHANGE) {
		// click 줿ΤǾ֤ꤹ
		par_getdat(PTMASK(pidx));
		par_setup(PTMASK(PTIDX_TB_STR2));

		// ܥåϥѡĤ֤ͭڤؤ
		if (appl->fsn->get_enable()) {
			// ͭˤʤäΤ ʸ2 ¦ͭˤ
			actbox = PTIDX_TB_STR2;
		} else if (actbox == PTIDX_TB_STR2) {
			// ʸ2 ¦ͭäΤʤܤ
			actbox = PTIDX_SB_SIZE;
		}
	}

	return er;
}


//
// Ѥ SS_PARTS ưؿ
//
ERR	MAINWIN::p_ss_color_fn(W pid, W pidx)
{
	ERR	er;
	W	sts;

	er = ER_OK;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {
		er = sts;
	} else if (sts & P_CHANGE) {
		// Ť줫ιܤ򤵤줿
		par_getdat(PTMASK(pidx));
	}

	return er;
}


//
//  VL_PARTS ưؿ
//
ERR	MAINWIN::p_vl_size_fn(W pid, W pidx)
{
	ERR	er;

	er = ER_OK;
	for ( ; ; ) {
		// volume ¹Ԥ
		W	sts;

		sts = cact_par(pid, &wevt);
		if (sts <= ER_OK) {
			// äѲ̵۾郎ȯ
			er = sts;
			break;
		} else if ((sts & 0x7000) == 0x4000) {
			// äѲʤ
			break;
		}

		// ̤ꤹ
		W	fact;		// Ѱ
		W	val[4];

		fact = 0;
		cget_val(pid, 4, val);
		switch (sts & 0x000f) {
			case (P_SMOOTH | P_LEFT):
				// ˥ࡼư
				fact = -1;
				break;
			case (P_SMOOTH | P_RIGHT):
				// ˥ࡼư
				fact = 1;
				break;
			case (P_AREA | P_LEFT):
				// ˥ꥢư
				fact = -16;
				break;
			case (P_AREA | P_RIGHT):
				// ˥ꥢư
				fact = 16;
				break;
		}

		if (fact == 0) {
			// Ѱ̤ʤ(ɽư)
			;	// äˤʤˤ⤷ʤ
		} else {
			val[1] += fact;
			if (val[1] < val[3]) {
				val[1] = val[3];
			} else if (val[1] > (val[2] - 1)) {
				val[1] = val[2] - 1;
			}
			val[0] = val[1] + 1;
			cset_val(pid, 2, val);
		}

		if (!(sts & P_BREAK)) {
			// ɽ֤Ǥʤнλ
			break;
		}

		//  SB_PARTS ¦ˤȿǤ
		par_getdat(PTMASK(pidx));
		par_setup(PTMASK(PTIDX_SB_SIZE));
	}

	if (er >= ER_OK) {
		// ｪλΤʤ顢֤ȿ
		par_getdat(PTMASK(pidx));
		par_setup(PTMASK(PTIDX_SB_SIZE));
		actbox = PTIDX_SB_SIZE;
	}

	return er;
}


//
//  SB_PARTS ưؿ
//
ERR	MAINWIN::p_sb_size_fn(W pid, W pidx)
#ifdef	SB_CEXE_USE			// cexe_par() Ѥ
{
	ERR	er;

	er = ER_OK;
	actbox = pidx;
	if ((wevt.s.type == EV_KEYDWN) || (wevt.s.type == EV_AUTKEY)) {
		// KC_TAB λϻ˼Фƽ򤹤ޤ
		if (wevt.e.data.key.code == KC_TAB) {
			actbox = PTIDX_TB_STR1;
			goto EXIT;
		}
	}

	// parts μ¹
	W	sts;

	sts = cexe_par(pid, &wevt);
	if (sts <= ER_OK) {
		// äƤʤ
		er = sts;
	} else {
		// 
		W	val;

		cget_val(pid, 1, &val);
		if (val != appl->fsn->get_size()) {
			// ͤѤäƤȿǤ
			appl->fsn->set_size(val);
			par_setup(PTMASK(PTIDX_VL_SIZE));
		}
	}

EXIT:
	return er;
}
#else	// SB_CEXE_USE			// cexe_par() Ѥʤ
{
	ERR	er;
	W	sts;

	er = ER_OK;
	actbox = pidx;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {	
		er = sts;
	} else if ((sts == P_EVENT) || (sts == P_MENU)) {
		par_getdat(PTMASK(pidx));
		par_setup(PTMASK(PTIDX_VL_SIZE));
		unget_wevt();
	} else {
		par_getdat(PTMASK(pidx));
		par_setup(PTMASK(PTIDX_VL_SIZE));

		// ληγǧ
		sts &= 0x0007;
		if (sts == P_NL) {
			// 
			;		// ä˲⤷ʤ
		} else if (sts == P_TAB) {
			// TAB (ΥܥåϥѡĤ focus ư)
			actbox = PTIDX_TB_STR1;
		} else if (sts == P_BUT) {
			// ѡΰ賰 click
			unget_wevt();
		}
	}

	return er;
}
#endif	// SB_CEXE_USE


//
// ԥåѤ WS_PARTS ưؿ
//
ERR	MAINWIN::p_ws_pitch_fn(W pid, W pidx)
{

	ERR	er;
	W	sts;

	er = ER_OK;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {
		er = sts;
	} else if (sts & P_CHANGE) {
		// Ť줫ιܤ򤵤줿
		par_getdat(PTMASK(pidx));
	}

	return er;
}


//
//  MS_PARTS ưؿ
//
ERR	MAINWIN::p_ms_init_fn(W pid, W pidx)
{
	ERR	er;
	W	sts;

	er = ER_OK;
	sts = cact_par(pid, &wevt);
	if (sts <= ER_OK) {
		er = sts;
	} else if (sts & P_CHANGE) {
		// click 줿Τ᤹ͤͤ
		init_data();
	}

	return er;
}
