//
//	mainmenu.cc (ѡ/ᥤ˥塼)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>

#include	<memory>

#include	"val.h"
#include	"cval.h"
#include	"dbox.h"
#include	"err.h"
#include	"except.h"

#include	"appl.h"
#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"
#include	"trayope.h"


// --------------------------------------- MAINMENU  static member ѿμ
FUNCP	MAINMENU::mfun[MENU_NUM];


// ---------------------------------- MAINMENU  public ؿ( static member)
//
// constructor
//
MAINMENU::MAINMENU()
	: mid(-1)
{
	// ˥塼ؿơ֥ν
	mfun[MIDX_VOBJ] = NULL;
	mfun[MIDX_TOOL] = reinterpret_cast<FUNCP>(&mn_tool);
	mfun[MIDX_EXEC] = NULL;
	mfun[MIDX_EXIT] = reinterpret_cast<FUNCP>(&mn_exit);
	mfun[MIDX_REDISP] = reinterpret_cast<FUNCP>(&mn_redisp);
	mfun[MIDX_TOTRAY] = reinterpret_cast<FUNCP>(&mn_totray);
	mfun[MIDX_FROMTRAY] = reinterpret_cast<FUNCP>(&mn_fromtray);
	mfun[MIDX_DELETE] = reinterpret_cast<FUNCP>(&mn_delete);
	mfun[MIDX_INIT] = reinterpret_cast<FUNCP>(&mn_init);

	// ˥塼Ͽ
	mid = openmenu(DBOX::MENU_MAIN);
	if (mid < ER_OK) {
		throw EXCEPT_MAINMENU(mid);
	}
}


//
// destructor
//
MAINMENU::~MAINMENU()
{
	closemenu();
}


//
// ˥塼μ¹Խ
//
W	MAINMENU::exec()
{
	set_indi();			// 󥸥
	set_enable();			// ͭǽ

	return selmenu(-1, mfun);
}


// ------------------------------------- MAINMENU  public ؿ(static member)
//
// [λ]
//
W	MAINMENU::mn_exit(W par)
{
	return EVTOPE::evt_finish(0, 0);
}


//
// [ɽ]-[ɽ]
//
W	MAINMENU::mn_redisp(W par)
{
	appl->gui->mwin->redisp();

	return 0;			//  0
}


//
// [Խ]-[ȥ졼ʣ]/[ȥ졼ذư]
//
W	MAINMENU::mn_totray(W par)
{
	appl->gui->mwin->do_pushtray(false, (par == 2));

	return 0;			//  0
}


//
// [Խ]-[ȥ졼ʣ]/[ȥ졼ư]
//
W	MAINMENU::mn_fromtray(W par)
{
	appl->gui->mwin->do_poptray(false, (par == 2));

	return 0;			//  0
}


//
// [Խ]-[]
//
W	MAINMENU::mn_delete(W par)
{
	appl->gui->mwin->del_string();

	return 0;			//  0
}


//
// [Խ]-[]
//
W	MAINMENU::mn_init(W par)
{
	appl->gui->mwin->init_data();

	return 0;			//  0
}


//
// ʪ
//
W	MAINMENU::mn_tool(W par)
{
	appl_exec(par, 0);

	return 0;			//  0
}


//
// application μ¹( menu )
//
void	MAINMENU::appl_exec(W par, W vid)
{
	setpointer(PS_BUSY, NULL);
	if (oexe_apg(vid, par) > 0) {
		setpointer(0x8001, NULL);
	}

	return;
}


// --------------------------------------------------- MAINMENU  private ؿ
//
// 󥸥
//
void	MAINMENU::set_indi()
{
	// 󥸥ĤΤäˤʤ

	return;
}


//
// ͭǽ
//
void	MAINMENU::set_enable()
{
	W	mask;

	mask = 0;

	// [ȥ졼ʣ]/[ȥ졼ذư]/[] 
	mask |= (appl->gui->mwin->chk_totray()) ? 0 : (MMASK_TOTRAY | MMASK_DELETE);

	// [ȥ졼ʣ]/[ȥ졼ư] 
	mask |= (tget_sts(NULL, NULL) <= 0) ? MMASK_FROMTRAY : 0;

	inactmenu(mask, 0);

	return;
}
