//
//	evtope.cc (ѡ/٥ɷϼ紴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<errcode.h>
#include	<keycode.h>

#include	<new>

#include	"appl.h"
#include	"dbox.h"
#include	"val.h"
#include	"cval.h"
#include	"macro.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"


// ----------------------------------------- EVTOPE  static member ѿμ
bool	EVTOPE::pflg = false;
WFUNCREC	EVTOPE::wfunc;
WINFOREC	EVTOPE::winfo[CVAL::WIN_NUM + 1];


// ------------------------------------------------------ EVTOPE  public ؿ
//
// constructor
//
EVTOPE::EVTOPE()
{
	// ɥ쥳ɤν
	W	l;

	for (l = 0; l <= CVAL::WIN_NUM; ++l) {
		winfo[l] = DEF_WINFO;
	}
	winfo[CVAL::WIN_NUM].wid = 0;

	// ɥ٥ȴؿơ֥
	wfunc.bgfn = NULL;		// Хå饦ɽ
	wfunc.idlefn = evt_idle;	// ɥ
	wfunc.msgfn = NULL;		// ̥å
	wfunc.menufn = evt_menu;	// ˥塼٥
	wfunc.dspfn = evt_disp;		// ɽ׵
	wfunc.stsfn = evt_chgsts;	// Ѳ
	wfunc.keyfn = evt_key;		// Ͻ
	wfunc.presfn = evt_press;	// ܥץ쥹
	wfunc.finfn = evt_finish;	// λ׵
	wfunc.pastefn = evt_paste;	// Ž׵
	wfunc.respfn = NULL;		// ׵
	wfunc.scrlfn = NULL;		// 
	wfunc.devfn = NULL;		// ǥХ٥Ƚ
	wfunc.vobjfn = NULL;		// ׵ᥤ٥
}


//
// destructor
//
EVTOPE::~EVTOPE()
{
}


// --------------------------------------- EVTOPE  public ؿ(static member)
//
// event loop 
//
ERR	EVTOPE::eventloop()
{
	ERR	er;

	er = ER_OK;
	try {
		WERR	rv;

		rv = evt_loop(&wfunc, winfo);
		er = (rv >= ER_OK) ? ER_OK : rv;
	} catch (...) {			// ϤäƤϤʤʤ
		DPRINT(("!! CAUTION !! : evt_loop() was gone to down by exception.\n"));
		throw;
	}
	switch (er) {
		case ER_SYS:
			errpanel(DBOX::EPNL_SYSTEM, 0);
			break;
	}

	return er;
}


//
// 
//
void	EVTOPE::evt_idle()
{
	// ̤
	if ((!(wevt.s.stat & (ES_CMD | ES_BUT2))) &&
	    (wevt.s.wid == winfo[CVAL::WIDX_MAINWIN].wid) &&
	    (wevt.s.cmd == W_WORK)) {
		if (cidl_par(wevt.s.wid, &wevt.s.pos) == 0) {
			setpointer(PS_SELECT, NULL);
		}
	}

	// ɥ˲
	appl->gui->mwin->idle_fn();

	return;
}


//
// ˥塼٥
//
W	EVTOPE::evt_menu()
{
	return appl->gui->menu->exec();
}


//
// ɽ
//
void	EVTOPE::evt_disp(W ix, W mode, RECT* newr)
{
	appl->gui->mwin->disp_fn(mode, newr);

	return;
}


//
// Ѳ
//
void	EVTOPE::evt_chgsts(W ix, W sts)
{
	setpointer(0x8000, NULL);
	if (sts != 0x100) {
		// ѡĤ(evt_loop() ɽȤƤ뤿)
		cdsp_pwd(appl->gui->mwin->get_wid(), NULL, P_RDISP);
		if (sts == 2) {		// W_SWITCH Žߤξ⤢
			if (pflg) {
				// ŽߤƤ
				appl->gui->mwin->do_poptray(true, true);
				pflg = false;
			}
		}
	}

	return;
}


//
// Ͻ
//
W	EVTOPE::evt_key()
{
	W	rv;

	if ((wevt.s.stat & ES_CMD) && (wevt.e.data.key.code > KC_SPACE)) {
		// [̿] Ʊʤ饭ޥ
		rv = appl->gui->menu->exec();
	} else {
		// ̾ key Ͻ
		rv = appl->gui->mwin->key_fn();
	}

	return rv;
}


//
// ܥץ쥹
//
W	EVTOPE::evt_press(W ix)
{
	W	rv;

	rv = appl->gui->mwin->press_fn();

	return rv;
}


//
// λ׵
//
W	EVTOPE::evt_finish(W ix, W mode)
{
	W	rv;

	rv = 1;				// ʤϼȤƤ
	switch (mode) {
		case 1:			// ¸λ(W_DELETE)
			break;
		case 2:			// ¸λ(W_FINISH)
			// ͤ򸵤᤹
			appl->fsn->undo_fusen();
			break;
		default:		// ¾(Ūʽλ)
			if (appl->fsn->chk_fusen()) {
				// ǧ
				switch (panel(DBOX::PNL_UPDATE)) {
					default:
					case 0:	// [ä]
						rv = 0;	// λϼʤ
						break;
					case 1:	// [Ѵƽλ]
						// ͤ򸵤ξ֤᤹
						const	PNT	wp = appl->fsn->get_wpos();

						appl->fsn->undo_fusen();
						appl->fsn->set_wpos(wp);
						break;
					case 2:	// [ƽλ]
						break;
				}
			}
			break;
	}

	return rv;
}


//
// Ž׵
//
W	EVTOPE::evt_paste(W ix, PNT pos)
{
	W	rv;

	rv = appl->gui->mwin->paste_fn(pos);
	pflg = (rv == W_ACK);

	return rv;
}
