//
//	appl_ex.cc (ѡ/application -ȤΥץư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"dbox.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"


// ----------------------------------------------- PARSAMP_EXREQ  public ؿ
//
// constructor
//
PARSAMP_EXREQ::PARSAMP_EXREQ(const M_EXECREQ* msg)
	: endprc(true)
{
	DPRINT(("PARSAMP_EXREQ constructor\n"));

	// μ
	mydat.msg.exmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.pr = msg->r;
	mydat.lnk = msg->lnk;
}


//
// destructor
//
PARSAMP_EXREQ::~PARSAMP_EXREQ()
{
	DPRINT(("PARSAMP_EXREQ destructor\n"));
	if (endprc) {
		oend_prc(mydat.vid, NULL, 0);
	}
}


//
// application 
//
ERR	PARSAMP_EXREQ::main()
{
	ERR	er;

	er = ER_OK;

	// ɬפ class 
	try {
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		gui = std::auto_ptr<GUIOPE>(new GUIOPE);

		// GUI Ϥν
		gui->init();
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_FREAD, er);
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	// Ȥμ¹Ԥ
	osta_prc(mydat.vid, gui->mwin->get_wid());

	// ٥ȥ롼פγ
	DPRINT(("event loop start.\n"));
	er = gui->evtope->eventloop();
	DPRINT(("evt_loop exit : %d(%d)\n", er, er >> 16));

	// λ
	if (er >= ER_OK) {
		// 䵤ι(ｪλΤ)
		try {
			// ʪʤΤǡȤνϤꤨʤ
			fsn->write_fusen(mydat.msg.msg, mydat.vid);
			endprc = false;
		} catch (EXCEPT_FUSEN& err) {
			er = err.get_err();
			DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
			errpanel(DBOX::EPNL_FWRITE, er);
		}
	}
	gui->dest();

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
