//
//	appl.h (ѡ/application 𴴥إå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_PARSAMP_APPL_H
#define	_PARSAMP_APPL_H

#include	<basic.h>
#include	<btron/btron.h>
#include	<errcode.h>

#include	<new>
#include	<memory>


//  class 
class	FUSEN;
class	GUIOPE;
class	PARSAMP_EXREQ;
class	PARSAMP_FSNREQ;


// --------------------------------------------------------- class PARSAMP_APPL
// application δ class
class	PARSAMP_APPL {
	typedef	struct {		//  application 
		W	pid;		//  PID
		W	vid;		// ư ID
		W	pwid;		// ưȤΤ WID
		RECT	pr;		// ưȤζΰ
		LINK	lnk;		// оݼ¿Ȥؤ LINK
		LINK	alnk;		//  application ¿
		union {			// ư message
			const	MESSAGE*	msg;	// 
			const	M_EXECREQ*	exmsg;	// ȤΥץư
			const	M_PASTEREQ*	pstmsg;	// ǡŽߵư
			const	M_FUSENREQ*	fsnmsg;	// 䵤Υץư
			const	M_DISPREQ*	dspmsg;	// Ȥɽư
			const	M_TADREQ*	tadmsg;	// TAD ǡư
		} msg;
	} MYDAT;

public:
	PARSAMP_APPL();			// default constructor
	PARSAMP_APPL(const MESSAGE* msg);	// copy constructor
	virtual	~PARSAMP_APPL();		// destructor

	std::auto_ptr<FUSEN>	fsn;	// 䵴
	std::auto_ptr<GUIOPE>	gui;	// GUI ɷϴ

	//  PID μ
	const	W	get_pid() {return mydat.pid;}

	// ư ID μ
	const	W	get_vid() {return mydat.vid;}

	// ưȤΤ window ID μ
	const	W	get_pwid() {return mydat.pwid;}

	// ưȤζȤμ
	const	RECT*	get_pr() {return &mydat.pr;}

	// оݼ¿Ȥؤ LINK μ
	const	LINK*	get_link() {return &mydat.lnk;}

	// ư message μ
	const	MESSAGE*	get_msg() {return mydat.msg.msg;}
	const	M_EXECREQ*	get_exmsg() {return mydat.msg.exmsg;}
	const	M_PASTEREQ*	get_pstmsg() {return mydat.msg.pstmsg;}
	const	M_FUSENREQ*	get_fsnmsg() {return mydat.msg.fsnmsg;}
	const	M_DISPREQ*	get_dspmsg() {return mydat.msg.dspmsg;}
	const	M_TADREQ*	get_tadmsg() {return mydat.msg.tadmsg;}

	// application 
	virtual	ERR	main() {return ER_OK;}

private:
	MYDAT	mydat;			//  application 

	friend	PARSAMP_EXREQ;
	friend	PARSAMP_FSNREQ;
};


// -------------------------------------------------------- class PARSAMP_EXREQ
// ȤΥץưδ
class	PARSAMP_EXREQ : public PARSAMP_APPL {
public:
	PARSAMP_EXREQ(const M_EXECREQ* msg);	// constructor
	~PARSAMP_EXREQ();		// destructor

	// application 
	ERR	main();

private:
	bool	endprc;			// oend_prc() ȯԤɬ
};


// ------------------------------------------------------- class PARSAMP_FSNREQ
// 䵤Υץưδ
class	PARSAMP_FSNREQ : public PARSAMP_APPL {
public:
	PARSAMP_FSNREQ(const M_FUSENREQ* msg);	// constructor
	~PARSAMP_FSNREQ();		// destructor

	// application 
	ERR	main();

private:
	bool	endprc;			// oend_prc() ȯԤɬ
};

#endif	// _PARSAMP_APPL_H
