//
//	vobjs.cc (Ȱ//䵷)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>

#include	<new>

#include	"cval.h"
#include	"val.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"guiope.h"
#include	"mainwin.h"
#include	"vobjope.h"
#include	"vobjs.h"


// ------------------------------------------------------- VOBJS  public ؿ
//
// constructor
//
VOBJS::VOBJS()
	: rid(-1), hidden(false), vobj(NULL)
{
}


//
// destructor
//
VOBJS::~VOBJS()
{
	del_allvobj();
}


//
// Ȥɲä(list ϴľ)
//
void	VOBJS::add_vobj(const VLINK* lnk, const VP dat, W len)
{
	try {
		if (vobj == NULL) {
			// Ǥ
			vobj = new VOBJ(lnk, dat, len, rid, NULL);
			vobj->set_prev(vobj);
			vobj->set_next(vobj);
		} else {
			// ǰʹߤ
			vobj->set_prev(new VOBJ(lnk, dat, len, rid, vobj->get_prev()));
			(const_cast<VOBJ*>((const_cast<VOBJ*>(vobj->get_prev()))->get_prev()))->set_next(vobj->get_prev());
			(const_cast<VOBJ*>(vobj->get_prev()))->set_next(vobj);
		}
	} catch (std::bad_alloc) {
		throw EXCEPT_VOBJS(ER_NOMEM);
	} catch (...) {
		throw;
	}

	return;
}


//
// βȤɲä
//
void	VOBJS::ins_vobj(W nvid)
{
	try {
		W	type;
		UW	len;

		type = oget_vob(nvid, NULL, NULL, 0, &len);
		if (vobj == NULL) {
			// Ǥ
			vobj = new VOBJ(nvid, (type == 0), len, rid, NULL);
			vobj->set_prev(vobj);
			vobj->set_next(vobj);
		} else {
			// ǰʹߤ
			vobj->set_prev(new VOBJ(nvid, (type == 0), len, rid, vobj->get_prev()));
			(const_cast<VOBJ*>((const_cast<VOBJ*>(vobj->get_prev()))->get_prev()))->set_next(vobj->get_prev());
			(const_cast<VOBJ*>(vobj->get_prev()))->set_next(vobj);
		}
	} catch (std::bad_alloc) {
		throw EXCEPT_VOBJS(ER_NOMEM);
	} catch (...) {
		throw;
	}

	return;
}

 
//
// ȤϿ
//
void	VOBJS::del_allvobj() throw()
{
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			VOBJ*	dptr = ptr;

			ptr = const_cast<VOBJ*>(ptr->get_next());
			delete dptr;
		} while (ptr != vobj);
	}
	vobj = NULL;

	return;
}


//
//  ID 鲾Ȥõ
//
const	VOBJ*	VOBJS::srch_vobj(W vid) throw()
{
	VOBJ*	rptr;

	rptr = NULL;
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			if (ptr->get_vid() == vid) {
				// ĤäΤǤޤ
				rptr = ptr;
				break;
			} else {
				// ʤΤǡ
				ptr = const_cast<VOBJ*>(ptr->get_next());
			}
		} while (ptr != vobj);
	}

	return rptr;
}


//
// ֤βȤä
//
void	VOBJS::dest_delvobj() throw()
{
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
NEXT:
			if (ptr->get_del()) {
				// ΤΤä
				VOBJ*	dptr = ptr;

				ptr = const_cast<VOBJ*>(ptr->get_next());
				ptr->set_prev(dptr->get_prev());
				const_cast<VOBJ*>(dptr->get_prev())->set_next(ptr);
				if (dptr == vobj) {
					// Ĥκ
					if(ptr->get_prev() == ptr->get_next()){
						// ¾˲Ȥ̵ʤ
						vobj = NULL;
					} else {
						vobj = ptr;
					}
					delete dptr;
					if (vobj == NULL) {
						break;
					} else {
						goto NEXT;	// 
					}
				} else {
					// ¾ʬ
					delete dptr;
				}
			} else {
				// βȾ
				ptr = const_cast<VOBJ*>(ptr->get_next());
			}
		} while (ptr != vobj);
	}

	// μ¿ȷ
	delgabage();

	return;
}


//
// 
//
// del == true : ΤΤϴޤʤĿ
//
const	UW	VOBJS::get_cnt(bool del)
{
	UW	cnt;

	cnt = 0;

	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			if ((!(del)) || (!(ptr->get_del()))) {
				++cnt;
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	return cnt;
}


//
// Ȥθ경֤
//
// sel == true : ֤Τ
//
void	VOBJS::set_allhold(bool flg, bool sel)
{
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			if ((!(sel)) || (ptr->get_sel())) {
				if (ptr->get_type()) {
					// Ȥξ°ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) ||
					    (hidden)) {
						ptr->set_hold(flg);
					}
				} else {
					// 䵤λϤΤޤ
					ptr->set_hold(flg);
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	return;
}


//
// Ȥطʲ֤
//
// sel == true : ֤Τ
//
void	VOBJS::set_allback(bool flg, bool sel)
{
	if (vobj != NULL) {
		VOBJ*	ptr;
		RECT	dr;
		bool	first;

		ptr = vobj;
		dr = (RECT){{0, 0, 0, 0}};
		first = true;
		do {
			if ((!(sel)) || (ptr->get_sel())) {
				// ϰϤμ
				RECT	r;

				orsz_vob(ptr->get_vid(), &r, V_CHECK);
				if (first) {
					dr = r;
					first = false;
				} else {
					orrect(&dr, &dr, &r);
				}

				if (ptr->get_type()) {
					// Ȥξ°ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) ||
					    (hidden)) {
						ptr->set_back(flg);
					}
				} else {
					// 䵤λϤΤޤ
					ptr->set_back(flg);
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);

		// ȯ
		appl->gui->mwin->redisp(&dr);
	}

	return;
}


//
// Ȥΰ֤
//
// sel == true : ֤Τ
//
void	VOBJS::set_alldel(bool flg, bool sel)
{
	if (vobj != NULL) {
		VOBJ*	ptr;
		RECT	dr;
		bool	first;

		ptr = vobj;
		dr = (RECT){{0, 0, 0, 0}};
		first = true;
		do {
			if ((!(sel)) || (ptr->get_sel())) {
				// ϰϤμ
				RECT	r;

				orsz_vob(ptr->get_vid(), &r, V_CHECK);
				if (first) {
					dr = r;
					first = false;
				} else {
					orrect(&dr, &dr, &r);
				}

				// flag ȿ
				if (ptr->get_type()) {
					// Ȥξ°ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) ||
					    (hidden)) {
						ptr->set_del(flg);
					}
				} else {
					// 䵤λϤΤޤ
					ptr->set_del(flg);
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);

		// ȯ
		appl->gui->mwin->redisp(&dr);
	}
	

	return;
}


//
// Ȥ֤
//
// sel == true : ֤Τ
//
void	VOBJS::set_allsel(bool flg, bool sel)
{
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			if ((!(sel)) || (ptr->get_sel())) {
				if ((ptr->get_type()) && (flg)) {
					// ϲȤξ°
					// ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) ||
					    (hidden)) {
						ptr->set_sel(flg);
					}
				} else {
					// 䵤λϤΤޤ
					ptr->set_sel(flg);
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	return;
}


//
// ȤζϰϤ
//
const	RECT	VOBJS::get_allarea()
{
	RECT	r;

	r = (RECT){{0, 0, 0, 0}};
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			RECT	vr;

			if (orsz_vob(ptr->get_vid(), &vr, V_CHECK) >= ER_OK) {
				// ǤΤδ֤ǤΤȿǤƤ
				if (vr.c.right > r.c.right) {
					r.c.right = vr.c.right;
				}
				if (vr.c.bottom > r.c.bottom) {
					r.c.bottom = vr.c.bottom;
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	// ˤϴַߤ
	r.c.right += CHSSTD;
	r.c.bottom += CHSSTD;

	// ¤Ķʤ褦
	if (r.c.right > CVAL::LIMIT_RECT.c.right + CHSSTD) {
		r.c.right = CVAL::LIMIT_RECT.c.right + CHSSTD;
	}
	if (r.c.bottom > CVAL::LIMIT_RECT.c.bottom + CHSSTD) {
		r.c.bottom = CVAL::LIMIT_RECT.c.bottom + CHSSTD;
	}

	return r;
}


//
// PD ֤б벾Ȥõ
//
// vid < 0 : о̵
//
const	W	VOBJS::fnd_posvobj(PNT p)
{
	W	vid;

	vid = -1;
	if (vobj != NULL) {
		VOBJ*	ptr;

		// ΤΤõ
		vid = 0;
		ptr = vobj;
		do {
			ptr = const_cast<VOBJ*>(ptr->get_prev());
			if (ptr->get_sel()) {
				RECT	vr;

				orsz_vob(ptr->get_vid(), &vr, V_CHECK);
				if (inrect(vr, p)) {
					vid = ptr->get_vid();
					break;
				}
			}
		} while ((vid == 0) && (ptr != vobj));
		if (vid != 0) {
			goto EXIT;
		}

		// βǤʤСΤõ
		ptr = vobj;
		do {
			ptr = const_cast<VOBJ*>(ptr->get_prev());

			if (ptr->get_type()) {
				// Ȥξ°ǧ
				const	VLINK*	vlnk = ptr->get_vlnk();

				if ((!(vlnk->attr & V_HIDDEN)) || (hidden)) {
					ofnd_vob(-ptr->get_vid(), p, &vid);
				}
			} else {
				// 䵤ξϤΤޤĴ
				ofnd_vob(-ptr->get_vid(), p, &vid);
			}
		} while ((vid == 0) && (ptr != vobj));
		if (vid == 0) {
			vid = -1;
		}
	}

EXIT:
	return vid;
}


//
// Ȥκɽ
//
// vid < 0 : 
//
void	VOBJS::dsp_vobj(W vid, const RECT* r)
{
	if (vobj != NULL) {
		UW	atr;
		VOBJ*	ptr;

		atr = V_DISPALL | ((rid < 0) ? V_NOFRAME : 0);

		// طʲƤʬɽ
		ptr = vobj;
		do {
			if (((vid < 0) || (vid == ptr->get_vid())) &&
			    (ptr->get_back())) {
				if (ptr->get_type()) {
					// Ȥξ°ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) || (hidden)) {
						odsp_vob(ptr->get_vid(), (RECT*)r, atr);
					}
				} else {
					// 䵤ξϤΤޤɽ
					odsp_vob(ptr->get_vid(), (RECT*)r,atr);
				}
				if (vid >= 0) {
					break;
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);

		// ̤֤Ƥʬ(طʲƤʬϽ)
		ptr = vobj;
		do {
			if (((vid < 0) || (vid == ptr->get_vid())) &&
			    (!(ptr->get_back()))) {
				if (ptr->get_type()) {
					// Ȥξ°ǧ
					const	VLINK*	vlnk = ptr->get_vlnk();

					if ((!(vlnk->attr & V_HIDDEN)) || (hidden)) {
						odsp_vob(ptr->get_vid(), (RECT*)r, atr);
					}
				} else {
					// 䵤ξϤΤޤɽ
					odsp_vob(ptr->get_vid(), (RECT*)r,atr);
				}
				if (vid >= 0) {
					break;
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	return;
}


//
// ưưμ¹
//
void	VOBJS::do_autoexec()
{
	if (vobj != NULL) {
		VOBJ*	ptr;

		ptr = vobj;
		do {
			if (ptr->get_type()) {
				// ȤΤ߼ưưǽ
				const	VLINK*	vlnk = ptr->get_vlnk();

				if (((!(vlnk->attr & V_HIDDEN)) || (hidden)) &&
				    (vlnk->attr & V_AUTEXE)) {
					ptr->exec_vobj();
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	return;
}
