//
//	vobjope.h (Ȱ/ñ첾/䵴ϥإå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_I_DLED_VOBJ_H
#define	_I_DLED_VOBJ_H

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<bstring.h>

#include	<new>
#include	<vector>


// ----------------------------------------------------------------- class VOBJ
class	VOBJ {
public:
	VOBJ(const VLINK* lnk, const VP dat, W len, W pwid, const VOBJ* ptr);	// constructor(/䵤Ͽ)
	VOBJ(W avid, bool vtype, W len, W pwid, const VOBJ* ptr);	// constructor(ID ɲä)
	~VOBJ();			// destructor

	friend	bool	operator==(const VOBJ&, const VOBJ& ) throw();
	friend	bool	operator!=(const VOBJ&, const VOBJ& ) throw();
	VOBJ&	operator=(const VOBJ& ) throw(std::bad_alloc);

	// 
	//  ID μ
	const	W	get_vid() {return vid;}

	// ̤μ
	const	bool	get_type() {return type;}

	// 경֤μ
	const	bool	get_hold() {return hold;}

	// طʲ֤μ
	const	bool	get_back() {return back;}

	// ֤μ
	const	bool	get_del() {return del;}

	// ֤μ
	const	bool	get_sel() {return sel;}

	// VLINK μ
	const	VLINK*	get_vlnk() {return &vlnk;}

	// segment Ĺμ
	const	W	get_seglen() {return buf.size();}

	// segment Ƥμ(VOBJSEG )
	const	VOBJSEG*	get_vobjseg() {return reinterpret_cast<const VOBJSEG*>(buf.begin());}

	// segment Ƥμ(FUSENSEG )
	const	FUSENSEG*	get_fusenseg() {return reinterpret_cast<const FUSENSEG*>(buf.begin());}

	// 
	// 경֤
	void	set_hold(bool flg);

	// طʲ֤
	void	set_back(bool flg);

	// ֤
	void	set_del(bool flg);

	// ֤
	void	set_sel(bool flg);

	// VLINK Ƥκؤ()
	void	set_vlnk(const VLINK* lnk);

	// segment Ƥκؤ()
	void	set_segdat(const VP dat, W len);

	// ¾
	// VLINK, segment Ƥμ()
	void	upd_mydat(bool lupd, bool supd);

	// Ȥ default application Ǥμ¹
	void	exec_vobj();

	// list 
	const	VOBJ*	get_prev() {return prev;}
	const	VOBJ*	get_next() {return next;}
	void	set_prev(const VOBJ* ptr) {prev = const_cast<VOBJ*>(ptr);}
	void	set_next(const VOBJ* ptr) {next = const_cast<VOBJ*>(ptr);}

private:
	W	wid;			// ° window ID
	W	vid;			//  ID
	bool	type;			// true :      false : 
	bool	hold;			// 경
	bool	back;			// طʲ
	bool	del;			// 
	bool	sel;			// 
	VLINK	vlnk;			// оݼ¿Ȥؤ VLINK
	std::vector<UB>	buf;		// ºݤƤݴΰ

	VOBJ*	prev;			// (֤)β
	VOBJ*	next;			// (֤)β
};

#endif	// _I_DLED_VOBJ_H
