//
//	vobjope.cc (Ȱ/ñ첾/䵴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<bstring.h>

#include	<new>
#include	<memory>
#include	<vector>

#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"vobjope.h"


// -------------------------------------------------------- VOBJ  public ؿ
//
// constructor(/䵤Ͽ)
//
VOBJ::VOBJ(const VLINK* lnk, const VP dat, W len, W pwid, const VOBJ* ptr)
	: wid(pwid), vid(-1), type(lnk != NULL),
	  hold(false), back(false), del(false), sel(false),
	  buf(len),
	  prev(const_cast<VOBJ*>(ptr))
{
//	DPRINT(("VOBJ constructor\n"));

	memcpy(buf.begin(), dat, buf.size());
	if (type) {
		vlnk = *lnk;
	}
	vid = oreg_vob((VLINK*)lnk, dat, pwid, V_NODISP);
//	DPRINT(("vid : %d(%d)\n", vid, vid >> 16));
	if (vid < ER_OK) {
		throw EXCEPT_VOBJ(vid);
	}
}


//
// constructor(ID ɲä)
//
VOBJ::VOBJ(W avid, bool vtype, W len, W pwid, const VOBJ* ptr)
	: wid(pwid), vid(avid), type(vtype),
	  hold(false), back(false), del(false), sel(false),
	  buf(len),
	  prev(const_cast<VOBJ*>(ptr))
{
	oget_vob(vid, (vtype) ? &vlnk : NULL, buf.begin(), buf.size(), NULL);
}


//
// destructor
//
VOBJ::~VOBJ()
{
//	DPRINT(("VOBJ destructor(vid : %d)\n", vid));

	odel_vob(vid, 0);
}


//
// 黻 == ؤư(VOBJ friend)
//
bool	operator==(const VOBJ& lhs, const VOBJ& rhs) throw()
{
	return ((lhs.wid == rhs.wid) &&
		(lhs.vid == rhs.vid) &&
		(lhs.type == rhs.type) &&
		(lhs.hold == rhs.hold) &&
		(lhs.back == rhs.back) &&
		(lhs.del == rhs.del) &&
		(lhs.sel == rhs.sel) &&
		(lhs.buf.size() == rhs.buf.size()) &&
		((memcmp(lhs.buf.begin() ,rhs.buf.begin(), lhs.buf.size()) == 0)));
}


//
// 黻 != ؤư(VOBJ friend)
//
bool	operator!=(const VOBJ& lhs, const VOBJ& rhs) throw()
{
	W	size;

	size = (lhs.buf.size() <= rhs.buf.size()) ? lhs.buf.size() : rhs.buf.size();

	return ((lhs.wid != rhs.wid) ||
		(lhs.vid != rhs.vid) ||
		(lhs.type != rhs.type) ||
		(lhs.hold != rhs.hold) ||
		(lhs.back != rhs.back) ||
		(lhs.del != rhs.del) ||
		(lhs.sel != rhs.sel) ||
		(lhs.buf.size() != rhs.buf.size()) ||
		((memcmp(lhs.buf.begin() ,rhs.buf.begin(), size) != 0)));
}


//
// 黻 = ؤư
//
VOBJ&	VOBJ::operator=(const VOBJ& vbuf) throw(std::bad_alloc)
{
	if (vbuf != *this) {
		// ž
		wid = vbuf.wid;
		vid = vbuf.vid;
		type = vbuf.type;
		hold = vbuf.hold;
		back = vbuf.back;
		del = vbuf.del;
		sel = vbuf.sel;
		prev = vbuf.prev;
		next = vbuf.next;

		// segment Ƥž
		buf.resize(vbuf.buf.size());
		memcpy(buf.begin(), vbuf.buf.begin(), vbuf.buf.size());
	}

	return *this;
}


//
// 경֤
//
void	VOBJ::set_hold(bool flg)
{
	if (flg) {
		// طʲ֤֤λϸ경ǽ
		if ((back) || (del)) {
			flg = false;
		}
	}
	hold = flg;

	return;
}


//
// طʲ֤
//
void	VOBJ::set_back(bool flg)
{
	if (flg) {
		// ֤λطʲǽ
		if (del) {
			flg = false;
		} else {
			// طʲϸ경/֤ϲ
			hold = false;
			sel = false;
		}
	} else if (back) {
		// طʲ֤˰ܹ(طʲ줿ΤΤ)
		sel = true;
	}
	back = flg;

	return;
}


//
// ֤
//
void	VOBJ::set_del(bool flg)
{
	if (flg) {
		// 경֤طʲ֤λϺǽ
		if ((hold) || (back)) {
			flg = false;
		} else {
			// ֤ϲ
			sel = false;
		}
	}

	del = flg;
	omov_vob(vid, (flg) ? 0xffff8000 : wid, NULL, V_NODISP);
	reggabage((LINK*)&vlnk, (flg) ? 1 : 0);

	return;
}


//
// ֤
//
void	VOBJ::set_sel(bool flg)
{
	if (flg) {
		// طʲ֤֤λǽ
		if ((back) || (del)) {
			flg = false;
		}
	}
	sel = flg;

	return;
}


//
// VLINK Ƥκؤ()
//
void	VOBJ::set_vlnk(const VLINK* lnk)
{
	if ((type) && (lnk != NULL)) {
		// 䵤ǤʤȤǧƤ
		vlnk = *lnk;
	}

	return;
}


//
// segment Ƥκؤ()
//
void	VOBJ::set_segdat(const VP dat, W len)
{
	try {
		buf.resize(len);
	} catch (std::bad_alloc) {
		throw EXCEPT_VOBJ(ER_NOMEM);
	} catch (...) {
		throw EXCEPT_VOBJ(ER_SYS);
	}
	memcpy(buf.begin(), dat, buf.size());

	return;
}


//
// VLINK, segment Ƥμ()
//
// lupd : VLINK ι
// supd : VOBJSEG(ʤ FUSENSEG) ι
//
void	VOBJ::upd_mydat(bool lupd, bool supd)
{
	UW	len;

	oget_vob(vid, (lupd) ? &vlnk : NULL, NULL, 0, &len);
	if (supd) {
		try {
			buf.resize(len);
			oget_vob(vid, NULL, buf.begin(), len, NULL);
		} catch (std::bad_alloc) {
			throw EXCEPT_VOBJ(ER_NOMEM);
		} catch (...) {
			throw EXCEPT_VOBJ(ER_SYS);
		}
	}

	return;
}


//
// Ȥ default application Ǥμ¹
//
void	VOBJ::exec_vobj()
{
	setpointer(PS_BUSY, NULL);
	if (oexe_apg(vid, 0) > 0) {
		setpointer(0x8001, NULL);
	}

	return;
}
