//
//	ud_ope.cc (Ȱ/äư class)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>

#include	"dbox.h"
#include	"val.h"
#include	"err.h"
#include	"except.h"

#include	"appl.h"
#include	"editobj.h"
#include	"guiope.h"
#include	"ud_ope.h"
#include	"ud_move.h"
#include	"ud_add.h"
#include	"ud_del.h"
#include	"ud_tadd.h"
#include	"ud_rsz.h"
#include	"ud_hold.h"
#include	"ud_uhold.h"
#include	"ud_back.h"
#include	"ud_uback.h"
#include	"ud_renum.h"


// --------------------------------------- UD_OPE  public ؿ(static member)
//
// undo ()
//
void	UD_OPE::make_undo(UW utype) throw()
{
	ERR	er;

	er = ER_OK;
	try {
		// undo 
		switch (utype) {
			case UT_MOVE:	// ְư
				appl->gui->undo = new UD_MOVE(utype);
				break;
			case UT_ADD:	// ɲ
				appl->gui->undo = new UD_ADD(utype);
				break;
			case UT_DEL:	// Ⱥ()
				appl->gui->undo = new UD_DEL(utype);
				break;
			case UT_TRAYADD:// ɲ(ȥ졼ưΤ)
				appl->gui->undo = new UD_TRAYADD(utype);
				break;
			case UT_TRAYDEL:// Ⱥ(ȥ졼ưμä)
				throw EXCEPT_UNDO(0);	// ϤʤϤ
				break;
			case UT_RESIZE:	// ѹ
				appl->gui->undo = new UD_RESIZE(utype);
				break;
			case UT_HOLD:	// 경
				appl->gui->undo = new UD_HOLD(utype);
				break;
			case UT_UNHOLD:	// 
				appl->gui->undo = new UD_UNHOLD(utype);
				break;
			case UT_BACK:	// طʲ
				appl->gui->undo = new UD_BACK(utype);
				break;
			case UT_UNBACK:	// طʲ
				appl->gui->undo = new UD_UNBACK(utype);
				break;
			case UT_FRONT:	// Ф
			case UT_REAR:	// Ф
				appl->gui->undo = new UD_RENUM(utype);
				break;
			default:	// 
			case UT_NONE:	// 
				throw EXCEPT_UNDO(0);
				break;
		}
		if (appl->gui->undo != NULL) {
			appl->gui->undo->make();
		}
	} catch (EXCEPT_UNDO& err) {
		er = err.get_err();
	} catch (std::bad_alloc) {
		er = ER_NOMEM;
	} catch (...) {
		;
	}

	if (er < ER_OK) {
		errpanel(DBOX::EPNL_UNDOMAKE, er);
		appl->gui->undo = NULL;
	}

	return;
}


//
// undo μ¹ - redo 
//
void	UD_OPE::exec_undo() throw()
{
	ERR	er;

	er = ER_OK;
	try {
		// redo 
		const	UW	utype = appl->gui->undo->get_type();
		UD_OPE*	rbuf;

		rbuf = NULL;
		switch (utype) {
			case UT_MOVE:	// ְư
				rbuf = new UD_MOVE(utype);
				rbuf->make();
				appl->gui->undo->exec();
				break;
			case UT_ADD:	// ɲ
				rbuf = new UD_DEL(UT_DEL);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_DEL:	// Ⱥ()
				rbuf = new UD_ADD(UT_ADD);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_TRAYADD:// ɲ(ȥ졼ưΤ)
				rbuf = new UD_DEL(UT_TRAYDEL);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_TRAYDEL:// Ⱥ(ȥ졼ưμä)
				rbuf = new UD_TRAYADD(UT_TRAYADD);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_RESIZE:	// ѹ
				rbuf = new UD_RESIZE(utype);
				rbuf->make();
				appl->gui->undo->exec();
				break;
			case UT_HOLD:	// 경
				rbuf = new UD_UNHOLD(UT_UNHOLD);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_UNHOLD:	// 
				rbuf = new UD_HOLD(UT_HOLD);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_BACK:	// طʲ
				rbuf = new UD_UNBACK(UT_UNBACK);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_UNBACK:	// طʲ
				rbuf = new UD_BACK(UT_BACK);
				rbuf->redo(appl->gui->undo->get_udat(), appl->gui->undo->get_ucnt());
				appl->gui->undo->exec();
				break;
			case UT_FRONT:	// Ф
			case UT_REAR:	// Ф
				rbuf = new UD_RENUM(utype);
				rbuf->make();
				appl->gui->undo->exec();
				break;
			default:	// 
			case UT_NONE:	// 
				break;
		}

		// undo κؤ
		delete appl->gui->undo;
		appl->gui->undo = rbuf;
	} catch (EXCEPT_UNDO& err) {
		er = err.get_err();
	} catch (std::bad_alloc) {
		er = ER_NOMEM;
	} catch (...) {
		;
	}

	if (er < ER_OK) {
		errpanel(DBOX::EPNL_UNDOMAKE, er);
		delete appl->gui->undo;
		appl->gui->undo = NULL;
	}

	return;
}


//
// undo Ѵ - ֤β
//
void	UD_OPE::clear_undo() throw()
{
	delete appl->gui->undo;
	appl->gui->undo = NULL;
	appl->eobj->set_saveflg(false);
	appl->eobj->set_editflg(false);
	appl->eobj->set_skipflg(false);
	appl->eobj->upd_mydat();

	return;
}


// ------------------------------------------------------ UD_OPE  public ؿ
//
// constructor
//
UD_OPE::UD_OPE()
	: type(UT_NONE)
{
}
