//
//	tidypnl.cc (Ȱ/ѥͥ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>

#include	"val.h"
#include	"dbox.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"

#include	"appl.h"
#include	"fusen.h"
#include	"tidypnl.h"


// ؿץȥ
LOCAL	W	tidypnl_fn(W pnid, W ino, W val);


// ----------------------------------------------------------- class ؿ
//
// ѥͥɴؿ
//
LOCAL	W	tidypnl_fn(W pnid, W ino, W val)
{
	W	rv;

	rv = -1;
	switch (ino) {
#if	0				// ʤ
		case -2:		// 
			break;
		case -1:		// 
			break;
		case 0:			// 
			break;
#endif	// 0
		case TIDYPNL::TSPIDX_MS_CANCEL:	// [ä]
			rv = 0;
			break;
		case TIDYPNL::TSPIDX_MS_DO:	// [¹]
			rv = 0x8000;
			break;
#if	0				// äưϴΤʤ
		case TIDYPNL::TSPIDX_WS_H:	//  WS_PARTS
		case TIDYPNL::TSPIDX_WS_V:	//  WS_PARTS
		case TIDYPNL::TSPIDX_WS_L:	// Ĺ WS_PARTS
			break;
#endif	// 0
	}

	return rv;
}


// ----------------------------------------------------- TIDYPNL  public ؿ
//
// constructor
//
TIDYPNL::TIDYPNL(bool ponly)
	: pnid(-1), only(ponly),
	  tdat(appl->fsn->get_tidy())
{
	// panel 򳫤
	pnid = opnstdpnl(DBOX::OPNL_TIDY, NULL);
	if (pnid < ER_OK) {
		throw EXCEPT_TIDYPNL(pnid);
	}

	// parts ξ֤ꤹ
	if (only) {
		// ñ
		cchg_par(pidstdpnl(TSPIDX_WS_H), P_DISABLE);
		cchg_par(pidstdpnl(TSPIDX_WS_V), P_DISABLE);
		cset_val(pidstdpnl(TSPIDX_WS_L), 1, (W*)&tdat.ltype);
	} else {
		// ʣ
		cset_val(pidstdpnl(TSPIDX_WS_H), 1, (W*)&tdat.htype);
		cset_val(pidstdpnl(TSPIDX_WS_V), 1, (W*)&tdat.vtype);
		cset_val(pidstdpnl(TSPIDX_WS_L), 1, (W*)&tdat.ltype);
	}
}


//
// destructor
//
TIDYPNL::~TIDYPNL()
{
	if (pnid >= 0) {
		clsstdpnl();
	}
}


//
// ѥͥμ¹
//
W	TIDYPNL::exec()
{
	W	rv;

	rv = exstdpnl(pnid, (FUNCP)(&tidypnl_fn));
	if (rv == pnid) {
		// parts ƤμФ(䵸ͭǡȿ)
		if (only) {
			// ñ
			cget_val(pidstdpnl(TSPIDX_WS_L), 1, (W*)&tdat.ltype);
		} else {
			// ʣ
			cget_val(pidstdpnl(TSPIDX_WS_H), 1, (W*)&tdat.htype);
			cget_val(pidstdpnl(TSPIDX_WS_V), 1, (W*)&tdat.vtype);
			cget_val(pidstdpnl(TSPIDX_WS_L), 1, (W*)&tdat.ltype);
		}
		appl->fsn->set_tidy(tdat);
		rv = 1;
	} else {
		// [ä] ¾ error
		pnid = -1;		//  panel ĤƤ
		rv = 0;
	}

	return rv;
}
