//
//	tadsave.cc (Ȱ/¿Ȥؤν񤭹߷)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>		// tad.h ɬ
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<errcode.h>
#include	<tad.h>
#include	<tcode.h>

#include	"dbox.h"
#include	"cval.h"
#include	"val.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"vobjope.h"
#include	"vobjs.h"
#include	"tadsave.h"


// ----------------------------------------------------- TADSAVE  public ؿ
//
// constructor
//
TADSAVE::TADSAVE(W pfd, W pvid)
	: fd(pfd), dvid(pvid)
{
	sysmsg(DBOX::SMSG_SAVE);
	wbuf.ofs = 0;
	wbuf.size = 0;
	memset(wbuf.dat, 0x00, BUFFER_SIZE);
}


//
// destructor
//
TADSAVE::~TADSAVE()
{
	sysmsg(0);
}


//
// ¸μ¹Խ
//
void	TADSAVE::main()
{
	store_lnkfsn();
	del_oldlnkfsn();
	store_tad();
	del_oldtad();

	return;
}


// ---------------------------------------------------- TADSAVE  private ؿ
//
// LINK / FFUSEN ν񤭽Ф
//
void	TADSAVE::store_lnkfsn()
{
	// ǽ LINK ʤ FFUSEN ˰ư
	W	rtype;

	rtype = fnd_rec(fd, F_TOPEND, RM_LINK | RM_FFUSEN, 0x0000, NULL);
	if ((rtype != RT_LINK) && (rtype != RT_FFUSEN)) {
		// ¸ߤƤʤкǽ record ˰ư
		see_rec(fd, 0, -1, NULL);
	}

	// 񤭽ФƤ
	VOBJ*	ptr;
	const	VOBJ*	vobj = appl->vobjs.get_vobj();

	if (vobj == NULL) {
		goto EXIT;
	}
	ptr = const_cast<VOBJ*>(vobj);
	do {
		// ֤ΤΤˤʤ
		if (ptr->get_del()) {
			goto NEXT;
		}

		// 1 record ν񤭽Ф
		ERR	er;

		if (ptr->get_type()) {
			// 
			LINK	lnk;

			ocnv_vob(dvid, ptr->get_vid(), &lnk);
			er = ins_rec(fd, (B*)&lnk, sizeof(LINK), RT_LINK, 0x0000, 0);
		} else {
			// (ǽ)
			er = ins_rec(fd, (B*)ptr->get_fusenseg(), ptr->get_seglen(), RT_FFUSEN, 0x0000, 0);
		}

		if (er < ER_OK) {
			// 񤭹 error
			throw EXCEPT_TADSAVE(er);
		}

		// Ϥ record ˰ư
		rtype = fnd_rec(fd, F_FWD, RM_LINK | RM_FFUSEN, 0x0000, NULL);
		if (rtype < ER_OK) {
			if (rtype != ER_REC) {
				throw EXCEPT_TADSAVE(rtype);
			}
		}

NEXT:
		// 
		ptr = const_cast<VOBJ*>(ptr->get_next());
	} while (ptr != vobj);

EXIT:
	return;
}


//
// Ť LINK / FFUSEN ˴
//
// store_lnkfsn() ˤ record ƺƤޤ
//
void	TADSAVE::del_oldlnkfsn()
{
	W	mode;

	for (mode = F_FWD; ; ) {
		W	rtype;

		rtype = fnd_rec(fd, mode, RM_LINK | RM_FFUSEN, 0x0000, NULL);
		if (rtype == ER_REC) {
			// λ
			break;
		} else if (rtype < ER_OK) {
			// ¾ error
			throw EXCEPT_TADSAVE(rtype);
		} else if ((rtype == RT_LINK) || (rtype == RT_FFUSEN)) {
			//  record 
			mode = (del_rec(fd) >= 0) ? F_FWD : F_NFWD;
		}
	}

	return;
}


//
// record ؤν񤭽Ф
//
void	TADSAVE::output_data(const B* dat, W size)
{
	if (size < 0) {
		// flush buffer
		if (wbuf.size > 0) {
			wri_rec(fd, wbuf.ofs, wbuf.dat, wbuf.size,NULL,NULL,0);
			wbuf.ofs += wbuf.size;
			wbuf.size = 0;
			memset(wbuf.dat, 0x00, BUFFER_SIZE);
		}
	} else {
		// buffer ίƤ
		W	widx;

		for (widx = 0; widx < size; ++widx) {
			if (wbuf.size >= BUFFER_SIZE) {
				// buffer Ϥ߽ФΤ flush ǽϤ
				output_data(NULL, -1);
			}
			wbuf.dat[wbuf.size] = dat[widx];
			++wbuf.size;
		}
	}

	return;
}


//
// 󥻥Ȥν񤭽Ф
//
void	TADSAVE::store_info()
{
	TADSEG	inf = {
			TC_ESC | TS_INFO, sizeof(INFOSEG)
		};
	TC	dat[] = {		// padding к
			0x0000, 2, 0x0121
		};

	output_data(reinterpret_cast<B*>(&inf), sizeof(TADSEG));
	output_data(reinterpret_cast<B*>(&dat), sizeof(TC) * 3);

	return;
}


//
// ޷ϥȤν񤭽Ф
//
void	TADSAVE::store_fig()
{
	const	RECT	varea = appl->vobjs.get_allarea();
	TADSEG	fig = {
			TC_ESC | TS_FIG, sizeof(FIGSEG)
		};
	FIGSEG	dat = {
			varea, varea, -120, -120, 0
		};

	output_data(reinterpret_cast<B*>(&fig), sizeof(TADSEG));
	output_data(reinterpret_cast<B*>(&dat), sizeof(FIGSEG));

	return;
}


//
// ȥȤν񤭽Ф
//
void	TADSAVE::store_vobj(W vid)
{
	// ȥȤ礭μ
	UW	vsize;

	oget_vob(vid, NULL, NULL, 0, &vsize);

	// ȥȤμ
	std::vector<B>	vbuf(vsize);
	VOBJSEG*	vseg = reinterpret_cast<VOBJSEG*>(vbuf.begin());

	oget_vob(vid, NULL, vseg, vsize, NULL);

	// ȥʬν񤭽Ф
	W	tsize;
	LTADSEG	ltseg;

	ltseg.id = TC_ESC | TS_VOBJ;
	if (vsize <= 0xffff) {
		ltseg.len = vsize;
		tsize = sizeof(TADSEG);
	} else {
		ltseg.len = 0xffff;
		ltseg.llen = vsize;
		tsize = sizeof(LTADSEG);
	}
	output_data(reinterpret_cast<B*>(&ltseg), tsize);
	output_data(vbuf.begin(), vsize);

	return;
}


//
// ޷ץꥱ䵤ν񤭽Ф(경/طʲ)
//
void	TADSAVE::store_fappl(UB ltype)
{
	TADSEG	fappl = {
			TC_ESC | TS_FAPPL, sizeof(LOCKSEG)
		};
	LOCKSEG dat = {
			1 | (ltype << 8),
			CVAL::DLED_APPID_0,
			CVAL::DLED_APPID_1,
			CVAL::DLED_APPID_2
		};

	output_data(reinterpret_cast<B*>(&fappl), sizeof(TADSEG));
	output_data(reinterpret_cast<B*>(&dat), sizeof(LOCKSEG));

	return;
}


//
// ޷λȤν񤭽Ф
//
void	TADSAVE::store_figend()
{
	TADSEG	fend = {
			TC_ESC | TS_FIGEND, 0
		};

	output_data(reinterpret_cast<B*>(&fend), sizeof(TADSEG));

	return;
}


//
// TAD  record ν񤭽Ф
//
// ɬǸɲ(apd_rec())Ȥʤޤ
//
void	TADSAVE::store_tad()
{
	// оݥ쥳ɤ
	ERR	er;

	er = apd_rec(fd, NULL, 0, RT_TADDATA, 0x0000, 0);
	if (er < ER_OK) {
		throw EXCEPT_TADSAVE(er);
	}

	// ϤΥ쥳ɤ˰ư
	W	rtype;

	rtype = fnd_rec(fd, F_ENDTOP, RM_TADDATA, 0x0000, NULL);
	if (rtype < ER_OK) {
		throw EXCEPT_TADSAVE(rtype);
	}

	// إåʬν񤭽Ф
	store_info();
	store_fig();

	// ƤƤ
	UH	ltype;
	VOBJ*	ptr;
	const	VOBJ*	vobj = appl->vobjs.get_vobj();

	if (vobj == NULL) {
		goto ENDSEG;
	}

	ltype = CVAL::NONE_LOCK;
	ptr = const_cast<VOBJ*>(vobj);
	do {
		// ֤ΤΤˤʤ
		if (ptr->get_del()) {
			goto NEXT;
		}

		// Ƥν񤭽Ф(ȰʳϲФʤ)
		if (ptr->get_type()) {
			// طʲ/경֤γǧ
			UH	tbuf;

			tbuf = ((ptr->get_hold()) ? CVAL::HOLD_TYPE : 0) |
			       ((ptr->get_back()) ? CVAL::BACK_TYPE : 0);
			if (tbuf != ltype) {
				ltype = (tbuf >= 2) ? 2 : (tbuf & 1);
				store_fappl(ltype);
			}

			// 
			store_vobj(ptr->get_vid());
		}

NEXT:
		// 
		ptr = const_cast<VOBJ*>(ptr->get_next());
	} while (ptr != vobj);

ENDSEG:
	// ޷λȤν񤭽Ф
	store_figend();

	// buffer flush
	output_data(NULL, -1);

	return;
}


//
// Ť TAD  record ˴
//
// store_tad() ˤ record ƺƤޤ
//
void	TADSAVE::del_oldtad()
{
	W	mode;

	for (mode = F_NBWD; ; ) {
		W	rtype;

		rtype = fnd_rec(fd, mode, RM_TADDATA, 0x0000, NULL);
		if (rtype == ER_REC) {
			// λ
			break;
		} else if (rtype < ER_OK) {
			// ¾ error
			throw EXCEPT_TADSAVE(rtype);
		} else if (rtype == RT_TADDATA) {
			//  record 
			mode = (del_rec(fd) >= 0) ? F_NBWD : F_BWD;
		}
	}

	return;
}
