//
//	tadload.cc (Ȱ/¿Ȥɤ߹߷)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>		// tad.h ɬ
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<bstring.h>
#include	<tad.h>
#include	<tcode.h>

#include	<vector>

#include	"dbox.h"
#include	"cval.h"
#include	"val.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"macro.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjope.h"
#include	"vobjs.h"
#include	"tadload.h"


// ----------------------------------------------------- TADLOAD  public ؿ
//
// constructor
//
TADLOAD::TADLOAD(const LINK* lnk)
	: nst(0), vreg(0), ltype(CVAL::NONE_LOCK),
	  skiptad(false), skipobj(false)
{
	// оݼ¿Ȥ򳫤
	rinf.fd = opn_fil((LINK*)lnk, F_READ, NULL);
	if (rinf.fd < ER_OK) {
		throw EXCEPT_TADLOAD(rinf.fd);
	}

	rinf.ofs = 0;
	rinf.idx = 0;
	rinf.rsize = 0;
	memset(rinf.buf, 0x00, BUFFER_SIZE);
}


//
// destructor
//
TADLOAD::~TADLOAD()
{
	cls_fil(rinf.fd);
}


//
// ɤ߹ߤμ紴
//
void	TADLOAD::main()
{
	// LINK ȵǽ䵤ɤ
	read_lnkfsn();

	// TAD  record ɤ
	W	mode;

	for (mode = F_TOPEND; ; mode = F_NFWD) {
		// о record õ
		if (fnd_rec(rinf.fd, mode, RM_TADDATA, 0x0000, NULL) != RT_TADDATA) {
			break;
		}

		// ɤ߹߾ν
		rinf.ofs = 0;
		rinf.idx = 0;
		memset(rinf.buf, 0x00, BUFFER_SIZE);
		rea_rec(rinf.fd, 0, NULL, 0, &rinf.rsize, NULL);
		DPRINT(("record size : %d\n", rinf.rsize));

		// paser θƽФ
		tad_parse();
	}

	// ɤ߹߸ξ֤γǧ
	if (nst != 0) {
		// ʿ
		skiptad = true;
	}
	if (vreg < rdat.size()) {
		// ĤϿ
		VOBJSEG	dmy = DEF_VOBJSEG;

		dmy.view.c.left = CVAL::VOBJ_HGAP;
		dmy.view.c.right = CVAL::VOBJ_HGAP;
		for ( ; vreg < rdat.size(); ++vreg) {
			const	RECT	varea = appl->vobjs.get_allarea();

			dmy.view.c.top = varea.c.bottom - CHSSTD + CVAL::VOBJ_VGAP;
			dmy.view.c.bottom = dmy.view.c.top;
			if (rdat[vreg].vlnk) {
				reg_vobj((VLINK*)rdat[vreg].buf.begin(), &dmy, sizeof(VOBJSEG));
			} else {
				reg_vobj(NULL, rdat[vreg].buf.begin(), rdat[vreg].buf.size());
			}

			// ϿȤθ경/طʲ֤
			if (ltype != CVAL::NONE_LOCK) {
				VOBJ*	vobj;

				vobj = const_cast<VOBJ*>(appl->vobjs.get_vobj());
				if (vobj != NULL) {
					VOBJ*	ptr;

					ptr = const_cast<VOBJ*>(vobj->get_prev());
					ptr->set_hold((ltype & CVAL::HOLD_TYPE) != 0);
					ptr->set_back((ltype & CVAL::BACK_TYPE) != 0);
				}
			}
		}
	}

	// ɤФ
	if (skipobj) {
		errpanel(DBOX::EPNL_VOBJSKIP, 0);
		appl->eobj->set_skipflg(true);
	} else if (skiptad) {
		errpanel(DBOX::EPNL_LOADSKIP, 0);
		appl->eobj->set_skipflg(true);
	}

	return;
}


// ---------------------------------------------------- TADLOAD  private ؿ
//
// LINK ȵǽ䵤ɤ
//
void	TADLOAD::read_lnkfsn()
{
	W	mode;

	for (mode = F_TOPEND; ; mode = F_NFWD) {
		W	rtype;

		rtype = fnd_rec(rinf.fd, mode, RM_LINK | RM_FFUSEN, 0x0000, NULL);
		if (rtype == RT_LINK) {
			RECDAT	dat;

			dat.vlnk = true;
			dat.buf.resize(sizeof(VLINK));
			rea_rec(rinf.fd, 0, dat.buf.begin(), sizeof(VLINK), NULL, NULL);
			rdat.push_back(dat);
		} else if (rtype == RT_FFUSEN) {
			// ̤μ
			W	size;

			rea_rec(rinf.fd, 0, NULL, 0, &size, NULL);

			// Ƥɤ߹
			RECDAT	dat;

			dat.vlnk = false;
			dat.buf.resize(size);

			rea_rec(rinf.fd, 0, dat.buf.begin(), size, NULL, NULL);
			rdat.push_back(dat);
		} else {
			// 
			break;
		}
	}

	return;
}


//
// /䵤Ͽ򤹤
//
void	TADLOAD::reg_vobj(const VLINK* lnk, const VP dat, W len)
{
	// ȤϿ
	try {
		appl->vobjs.add_vobj(lnk, dat, len);
	} catch (EXCEPT_VOBJ& err) {
		ERR	er;

		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		if (er == ER_LIMIT) {
			// 
			skipobj = true;
		} else {
			throw EXCEPT_TADLOAD(er);
		}
	} catch (EXCEPT_VOBJS& err) {
		ERR	er;

		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_TADLOAD(ER_NOMEM);
	} catch (...) {
		DPRINT(("other exception.\n"));
		throw EXCEPT_TADLOAD(ER_SYS);
	}

	return;
}


//
// record ɤ߹(TC 1ʸŤĤɤ߹)
//
// force == true : ɬ¿Ȥɤ߼
//
TC	TADLOAD::read_buf(bool force)
{
	TC	ch;

	if (rinf.idx >= rinf.rsize) {
		// record νüã
		rinf.idx = -1;
		rinf.ofs = -1;
		ch = TNULL;
	} else {
		// buffer 椫Ȥ
		if (((rinf.ofs + BUFFER_SIZE) <= rinf.idx) || (force)) {
			// buffer ˤϤʤʤΤ record ɤ߹
			rinf.ofs = rinf.idx;
			rea_rec(rinf.fd, rinf.ofs, rinf.buf, BUFFER_SIZE, NULL, NULL);
		}
		ch = *(reinterpret_cast<const TC*>(&rinf.buf[rinf.idx - rinf.ofs]));
	}

	return ch;
}


//
// TAD  record Ƥβ
//
void	TADLOAD::tad_parse()
{
	do {
		TC	ch;

		ch = read_buf(rinf.idx <= 0);
		if ((ch == TNULL) && (rinf.idx < 0) && (rinf.ofs < 0)) {
			// ü
			DPRINT(("buffer over.\n"));
			break;
		} else if ((ch & TC_SPEC) == TC_SPEC) {
			// /
			chk_TS(ch);
		} else if ((ch & TC_SPEC) == TC_LANG) {
			// /ץȻ(̵)
			skiptad = true;
			while ((ch & TC_SPEC) == TC_LANG) {
				rinf.idx += sizeof(TC);
				ch = read_buf(false);
			}
		} else {
			// ʸ(̵)
			skiptad = true;
			rinf.idx += sizeof(TC);
		}
	} while ((rinf.idx >= 0) && (rinf.ofs >= 0));

	return;
}


//
// /Ȥμʬ
//
void	TADLOAD::chk_TS(TC ch)
{
	W	len;			// /Ĺ(byte ñ)
	UB	id;			// segment ID
	UB	sid;			// segment sub ID
	UB	sattr;			// attribute

	// TADSEG ʬμ
	id = ch & 0x00ff;
	rinf.idx += sizeof(TC);
	len = read_buf(false);
	rinf.idx += sizeof(TC);
	if (len == 0xffff) {
		// large segment(ˡǤ endian )(LTADSEG )
		len = read_buf(false);
		rinf.idx += sizeof(TC);
		len += (read_buf(false) << 16);
		rinf.idx += sizeof(TC);
	}

	// sub ID Ȥμ(Ǥ rinf.idx Ϥޤʤʤ)
	TC	sch;

	sch = read_buf(false);
	sid = sch >> 8;
	sattr = sch & 0x00ff;

	// segment ID ʬ
	switch (id) {
		case TS_INFO:
			// 󥻥(̵)
			break;
		case TS_TEXT:
		case TS_FIG:
			// ʸϳϥ/޷ϥ
			++nst;		// ʿɲäΤ
			break;
		case TS_TEXTEND:
		case TS_FIGEND:
			// ʸϽλ/޷λ
			--nst;		// ʿθ
			break;
		case TS_VOBJ:
			// ȥ
			get_TS_VOBJ(len);
			break;
		case TS_FAPPL:
			get_TS_FAPPL(len);
			break;
		default:
			// 
			skiptad = true;
			break;
	}

	// rinf.idx ʤ
	rinf.idx += len;

	return;
}


//
// TS_VOBJ μ
//
void	TADLOAD::get_TS_VOBJ(W len)
{
	if (vreg >= rdat.size()) {
		// б LINK ʤ
		;			// äˤʤˤ⤷ʤ
	} else {
		// ¿Ȥɤ߹
		std::vector<B>	vbuf(len);

		rea_rec(rinf.fd, rinf.idx, vbuf.begin(), len, NULL, NULL);

		// ȤϿ(б벾Ȥ֤
		bool	rflg;

		rflg = true;
		while ((vreg < rdat.size()) && (rflg)) {
			if (rdat[vreg].vlnk) {
				// ȥȤϿ
				reg_vobj((VLINK*)rdat[vreg].buf.begin(), vbuf.begin(), vbuf.size());
				rflg = false;
			} else {
				// ǽ䵤Ͽ
				reg_vobj(NULL, rdat[vreg].buf.begin(), rdat[vreg].buf.size());
			}

			// ϿȤθ경/طʲ֤
			if (ltype != CVAL::NONE_LOCK) {
				VOBJ*	vobj;

				vobj = const_cast<VOBJ*>(appl->vobjs.get_vobj());
				if (vobj != NULL) {
					VOBJ*	ptr;

					ptr = const_cast<VOBJ*>(vobj->get_prev());
					ptr->set_hold((ltype & CVAL::HOLD_TYPE) != 0);
					ptr->set_back((ltype & CVAL::BACK_TYPE) != 0);
				}
			}
			++vreg;
		}
	}

	return;
}


//
// TS_FAPPPL μ(경/طʲ)(DLED ߴ)
//
void	TADLOAD::get_TS_FAPPL(W len)
{
	if (len == sizeof(LOCKSEG)) {
		// ¿Ȥɤ߹
		LOCKSEG	lseg;

		rea_rec(rinf.fd, rinf.idx, (B*)&lseg, sizeof(LOCKSEG), NULL, NULL);

		// Ƥγǧ
		if ((lseg.app_id1 == CVAL::DLED_APPID_0) &&
		    (lseg.app_id2 == CVAL::DLED_APPID_1) &&
		    (lseg.app_id3 == CVAL::DLED_APPID_2)) {
			// DLED ο޷ץꥱ
			ltype = (lseg.id_at >> 8);
		}
	}

	return;
}
