//
//	pd_vqp.cc (Ȱ/ݥ󥿥åץ쥹-ȤĤ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/hmi.h>
#include	<btron/libapp.h>

#include	"val.h"
#include	"cval.h"
#include	"err.h"
#include	"except.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjope.h"
#include	"vobjs.h"
#include	"guiope.h"
#include	"mainwin.h"
#include	"pd_vqp.h"
#include	"ud_ope.h"
#include	"trayope.h"
#include	"misc.h"


// ------------------------------------------------------ PD_VQP  public ؿ
//
// constructor
//
PD_VQP::PD_VQP(W vid)
	: svid(vid), vobj(const_cast<VOBJ*>(appl->vobjs.srch_vobj(vid)))
{
	if (!(vobj->get_sel())) {
		// ֤ʤ֤ˤ
		appl->vobjs.set_allsel(false, false);
		vobj->set_sel(true);
	} else if (appl->vobjs.get_selvid() != vid) {
		// ʣػ
		throw EXCEPT_PDOPE(I_DLEDERR::PD_NOOPE);
	}

	// 䵤ξػ
	if (!(vobj->get_type())) {
		appl->gui->mwin->disp_selfrm(-2);
		throw EXCEPT_PDOPE(I_DLEDERR::PD_NOOPE);
	}

	appl->gui->mwin->disp_selfrm(-1);

	// drag Ķ
	dgid = wsta_drg(wid, 0);
	if (dgid < ER_OK) {
		throw EXCEPT_PDOPE(dgid);
	}
	setpointer(PS_GRIP, NULL);	// 

	// ¾ѿ
	sp = wevt.s.pos;
	gget_fra(dgid, &frect);
	orsz_vob(vid, &vr, V_CHECK);
	gap = (SIZE){sp.x - vr.c.left, sp.y - vr.c.top};
	srgn.sts = 0x0000;
}


//
// destructor
//
PD_VQP::~PD_VQP()
{
	appl->gui->mwin->disp_selfrm(1);
	if (dgid >= 0) {
		wend_drg();
	}
}
 

//
// ¹Խ
//
void	PD_VQP::main()
{
	W	type;			// event type

	do {
		UW	time;
		PNT	p, pF;
		bool	modF;

		// event μ
		pF = p;
		modF = mod;
		type = MISC::wget_drg_C(&p, &wevt);
		if (type == EV_BUTUP) {
			break;
		}
		mod = ((wevt.s.stat & (ES_LSHFT | ES_RSHFT)) != 0x0000);

		// ֤γǧ
		if (inrect(vrect, p)) {
			// ɥκΰˤ
			if (lock) {
				// Ķ lock 
				adsp_sel(dgid, &srgn, 0);
				gset_vis(dgid, vrect);
				gloc_env(dgid, 0);
				lock = false;
			}
			if ((p.x != pF.x) || (p.y != pF.y) || (mod != modF)) {
				// Ȥư
				move_selfrm(vr, p, gap);
			}
			on = false;
			in = true;
		} else if (wevt.s.wid == wid) {
			// ɥȾˤ
			adsp_sel(dgid, &srgn, 0);
			if (lock) {
				// Ķ lock 
				gset_vis(dgid, vrect);
				gloc_env(dgid, 0);
				lock = false;
			}
			if (on) {
				// ˥ɥȾǻ֤ФϤƤ
				if ((wevt.s.time - time) > CVAL::SCRL_WAIT) {
					set_spos(p);
				}
			} else {
				// Ⱦˤ
				time = wevt.s.time;
				on = true;
			}
			in = false;
		} else {
			// ɥ˻äƤȤƤ
			if (!(lock)) {
				// Ķ lock 
				adsp_sel(dgid, &srgn, 0);
				gloc_env(dgid, 1);
				gset_vis(dgid, frect);
				lock = true;
			}
			if ((p.x != pF.x) || (p.y != pF.y)) {
				// Ȥư
				move_selfrm(vr, p, gap);
			}
			in = false;
			on = false;
		}

		// scroll ̤γǧ scroll 
		if ((vp.x != vpN.x) || (vp.y != vpN.y)) {
			adsp_sel(dgid, &srgn, 0);
			appl->gui->mwin->scroll_work((PNT){vpN.x - vp.x, vpN.y - vp.y});
			vrect = appl->gui->mwin->vrect;
			vp = vrect.p.lefttop;
			vpN = vp;
			gget_fra(dgid, &frect);	// wscr_wnd() ưƤ
		}
	} while (type != EV_BUTUP);

	// drag ĶѴ
	adsp_sel(dgid, &srgn, 0);
	if (lock) {
		// Ķ lock 
		gset_vis(dgid, vrect);
		gloc_env(dgid, 0);
		lock = false;
	}
	wend_drg();
	dgid = -1;

	// Ȥ
	appl->gui->mwin->disp_selfrm(-2);

	// ̤ȿ
	if ((!(on)) && (wevt.s.wid >= 1)) {
		// ¿ʣ
		W	cvid;		// ʣ dummy
		W	nvid;		// 줿¿Ȥؤβ

		cvid = odup_vob(svid);	// dummy äơʣ˰ư
		omov_vob(cvid, wevt.s.wid, NULL, V_NODISP);
		nvid = onew_obj(cvid, NULL);
		odel_vob(cvid, 0);
		if (nvid < ER_OK) {
			// ä餫ΰ۾
			;		// äˤʤˤ⤷ʤ
		} else {
			// ɤʣ¿ȤβȤŽդ
			omov_vob(nvid, 0, &srgn.rgn.r, V_NODISP);
			if (in) {
				// ɥκΰ
				appl->eobj->set_editflg(true);	// 
				appl->vobjs.ins_vobj(nvid);
				vobj->set_sel(false);
				appl->vobjs.set_sel(nvid, true);
				appl->vobjs.dsp_vobj(-1, &srgn.rgn.r);
				appl->gui->mwin->upd_narea();
				appl->gui->mwin->disp_selfrm(-2);
				UD_OPE::make_undo(UD_OPE::UT_ADD);
			} else {
				// ɥΤɤ(ȥ졼ͳ)
				TRAYOPE::push_tray(nvid, false, true, gap);
				odel_vob(nvid, 0);
			}
		}
	}

	return;
}
