//
//	pd_hprs.cc (Ȱ/ݥ󥿥ץ쥹-ȤΥϥɥ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>

#include	"val.h"
#include	"cval.h"
#include	"err.h"
#include	"except.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjs.h"
#include	"guiope.h"
#include	"mainwin.h"
#include	"pd_hprs.h"
#include	"ud_ope.h"
#include	"misc.h"


// ----------------------------------------------------- PD_HPRS  public ؿ
//
// constructor
//
PD_HPRS::PD_HPRS(W vid, W type)
	: svid(vid), vtype(type)
{
	appl->gui->mwin->disp_selfrm(-1);

	// ֤
	if (!(appl->vobjs.get_sel(vid))) {
		// ֤ʤ֤ڤؤ
		appl->vobjs.set_allsel(false, false);
		appl->vobjs.set_sel(vid, true);
	}

	// drag Ķ
	dgid = wsta_drg(wid, 0);
	if (dgid < ER_OK) {
		appl->gui->mwin->disp_selfrm(-2);
		throw EXCEPT_PDOPE(dgid);
	}
	setpointer(PS_PICK, NULL);	// Ĥޤ

	// Ĥ˱()
	RECT	r;

	orsz_vob(vid, &r, V_CHECK);
	if ((type == V_LTHD) || (type == V_LBHD)) {
		sp.x = r.c.right;
		np.x = r.c.left;
	} else {
		sp.x = r.c.left;
		np.x = r.c.right;
	}
	if ((type == V_LTHD) || (type == V_RTHD)) {
		sp.y = r.c.bottom;
		np.y = r.c.top;
	} else {
		sp.y = r.c.top;
		np.y = r.c.bottom;
	}

	// ¾ѿν
	W	attr;
	W	chs;

	attr = ochg_sts(vid, V_GETSTS);
	chs = ochg_chs(vid, -1, NULL, V_NODISP);
	if (attr & V_NOFDISP) {
		// Ȥʤ
		if (!(attr & V_NOPICT)) {
			// ԥȥͭ
			chs += chs >> 2;
		}
		min.h = chs;
		min.v = chs;
	} else {
		// Ȥ
		min.h = chs << 1;
		min.v = chs + (chs >> 2) + 2;
	}
}


//
// destructor
//
PD_HPRS::~PD_HPRS()
{
	if (dgid >= 0) {
		// drag ĶѴ
		wend_drg();
	}
}
 

//
// ¹Խ
//
void	PD_HPRS::main()
{
	W	type;			// event type;

	do {
		UW	time;
		PNT	p, pF;
		bool	modF;

		// event μ
		pF = p;
		modF = mod;
		type = MISC::wget_drg_C(&p, &wevt);
		if (type == EV_BUTUP) {
			break;
		}
		mod = ((wevt.s.stat & (ES_LSHFT | ES_RSHFT)) != 0x0000);

		// ֤γǧ
		if (inrect(vrect, p)) {
			// ɥκΰˤ
			if ((p.x != pF.x) || (p.y != pF.y) || (mod != modF)) {
				// ȤĤ
				set_selfrm(p);
			}
			on = false;
			in = true;
		} else if (wevt.s.wid == wid) {
			// ɥȾˤ
			adsp_sel(dgid, &srgn, 0);
			if (on) {
				// ˥ɥȾǻ֤ФϤƤ
				if ((wevt.s.time - time) > CVAL::SCRL_WAIT) {
					set_spos(p);
				}
			} else {
				// Ⱦˤ
				time = wevt.s.time;
				on = true;
			}
			in = false;
		} else {
			// ɤǤʤ
			adsp_sel(dgid, &srgn, 0);
			in = false;
		}

		// scroll ̤γǧ scroll 
		if ((vp.x != vpN.x) || (vp.y != vpN.y)) {
			adsp_sel(dgid, &srgn, 0);
			appl->gui->mwin->scroll_work((PNT){vpN.x - vp.x, vpN.y - vp.y});
			vrect = appl->gui->mwin->vrect;
			vp = vrect.p.lefttop;
			vpN = vp;
		}
	} while (type != EV_BUTUP);

	// drag ĶѴ
	adsp_sel(dgid, &srgn, 0);
	wend_drg();
	dgid = -1;

	if (in) {
		// ѷȿ
		SIZE	ds;

		ds.h = ((vtype == V_LTHD) || (vtype == V_LBHD)) ? (np.x - srgn.rgn.r.c.left) : (srgn.rgn.r.c.right - np.x);
		ds.v = ((vtype == V_LTHD) || (vtype == V_RTHD)) ? (np.y - srgn.rgn.r.c.top) : (srgn.rgn.r.c.bottom - np.y);
		if ((ds.h != 0) || (ds.v != 0)) {
			UD_OPE::make_undo(UD_OPE::UT_RESIZE);
			appl->vobjs.rsz_selvobj(ds, vtype);
			appl->gui->mwin->upd_narea();
			appl->eobj->set_editflg(true);	// 
		}
	}

	// Ȥ
	appl->gui->mwin->disp_selfrm(-2);

	return;
}


// ---------------------------------------------------- PD_HPRS  private ؿ
//
// ֤γǧ
//
void	PD_HPRS::chk_modify(PNT& p)
{
	W	ptype;

	ptype = PS_PICK;		// Ĥޤ
	if ((wevt.s.stat & (ES_LSHFT | ES_RSHFT)) != 0x0000) {
		// 
		SIZE	dp;		// Ѱ

		switch (dir) {
			case 1:
				// ʿѷ
				p.y = np.y;
				ptype = PS_HPICK;	// Ĥޤ()
				break;
			case 2:
				// ľѷ
				p.x = np.x;
				ptype = PS_VPICK;	// Ĥޤ()
				break;
			case 3:
				// ѷ
				dp.h = ((sp.x > p.x) ? -1 : 1) * (p.x - sp.x);
				dp.v = ((sp.y > p.y) ? -1 : 1) * (p.y - sp.y);
				if (dp.h > dp.v) {
					p.x = sp.x + (((vtype == V_RTHD) || (vtype == V_LBHD)) ? -1 : 1) * (p.y - sp.y);
				} else {
					p.y = sp.y + (((vtype == V_RTHD) || (vtype == V_LBHD)) ? -1 : 1) * (p.x - sp.x);
				}
				break;
			default:
				// (ˡ)
				dp.h = ((np.x > p.x) ? -1 : 1) * (p.x - np.x);
				dp.v = ((np.y > p.y) ? -1 : 1) * (p.y - np.y);

				dir = (dp.h > dp.v) ? 1 : 2;
				if ((dp.v <= (dp.h << 1)) &&
				    (dp.h <= (dp.v << 1))) {
					dir = 3;
				}
				break;
		}
	} else {
		dir = 0;
	}

	setpointer(ptype, NULL);

	return;
}

//
// Ȥꤹ
//
void	PD_HPRS::set_selfrm(PNT p)
{
	// Ȥä
	adsp_sel(dgid, &srgn, 0);

	// γǧ
	chk_modify(p);

	// ϥɥ֤˱ǾȤθ
	if ((vtype == V_LTHD) || (vtype == V_LBHD)) {
		// ư
		if ((sp.x - p.x) < min.h) {
			p.x = sp.x - min.h;
		}
	} else {
		// ư
		if ((p.x - sp.x) < min.h) {
			p.x = sp.x + min.h;
		}
	}
	if ((vtype == V_LTHD) || (vtype == V_RTHD)) {
		// ư
		if ((sp.y - p.y) < min.v) {
			p.y = sp.y - min.v;
		}
	} else {
		// ư
		if ((p.y - sp.y) < min.v) {
			p.y = sp.y + min.v;
		}
	}

	// Ȥ
	gen_selfrm(sp, p);

	// Ȥ
	adsp_sel(dgid, &srgn, 1);

	return;
}
