//
//	mainwin.cc (Ȱ/祦ɥɷ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<btron/cnvend.h>
#include	<bstring.h>
#include	<errcode.h>
#include	<keycode.h>
#include	<tstring.h>
#include	<tcode.h>

#include	<new>
#include	<memory>
#include	<vector>

#include	"val.h"
#include	"cval.h"
#include	"dbox.h"
#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjs.h"
#include	"fusen.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"pd_ope.h"
#include	"pd_nprs.h"
#include	"pd_hprs.h"
#include	"pd_vprs.h"
#include	"pd_vqp.h"
#include	"pd_clk.h"
#include	"pd_dclk.h"
#include	"kb_ope.h"
#include	"kb_can.h"
#include	"kb_del.h"
#include	"kb_move.h"
#include	"kb_scrl.h"
#include	"selfrm.h"
#include	"mainmenu.h"
#include	"ud_ope.h"
#include	"trayope.h"


// ----------------------------------------------------- MAINWIN  public ؿ
//
// constructor
//
MAINWIN::MAINWIN()
	: wid(-1), gid(-1), selfrm(NULL)
{
	// ɥǡμФ
	ConvEndianStruct(&wdef, getdbox(DBOX::DEF_MAINWIN), WINDEF_STRUCT, sizeof(wdef));

	// ¾ν
	ppos = (PNT){0, 0};
	genrectlist(4, rlist);
}


//
// destructor
//
MAINWIN::~MAINWIN()
{
	delete selfrm;
	if (wid >= 0) {
		odel_vob(-wid, CLR);
		wcls_wnd(wid, CLR);
	}
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;
}


//
// ɥ򳫤
//
void	MAINWIN::open_win(const W pwid, const RECT* pr)
{
	// ԥȥμ
	W	pcid;			// ԥȥ ID

	pcid = (static_cast<W>(appl->eobj->get_atype()) & 0xff);
	if (pcid == 0) {
		pcid = CVAL::I_DLED_PICT;
	}

	// ɥȥ
	TC	tit[L_FNM + 1 + 1 + 1];

	tc_strset(tit, TNULL, L_FNM + 1 + 1 + 1);
	tc_strncpy(tit, appl->eobj->get_fname(), L_FNM);
	tit[tc_strlen(tit)] = TK_COLN;
	tc_strncat(tit, wdef.title, 1);

	// ɥξ
	const	WINATTR	wattr = appl->fsn->get_wattr();

	vrect = wattr.rect;
	if ((vrect.c.left >= vrect.c.right)||(vrect.c.top >= vrect.c.bottom)) {
		vrect = wdef.r;
		centering(&vrect);
	}

	// ɥ򳫤
	UW	atr;

	atr = wdef.attr | ((wattr.fwindow) ? WA_FULL : 0);
	set_wbgpat(false);
	wid = wopn_wnd(atr, pwid, &vrect, (RECT*)pr, pcid, tit, &wbgpat, NULL);
	if (wid < ER_OK) {
		throw EXCEPT_MAINWIN(wid);
	}
	DPRINT(("wid : %d\n", wid));
	wget_bar(wid, &bar[0], &bar[1], NULL);

	// ɽν

	gid = wget_gid(wid);
	gset_vis(gid, vrect);

	// ɽ֤ȿ
	const	PNT	vp = appl->fsn->get_vpos();

	wscr_wnd(wid, NULL, -vp.x, -vp.y, W_SCRL);
	gget_vis(gid, &vrect);

	// ɽˤ
	cchg_par(bar[0], P_DRAGBREAK);
	cchg_par(bar[1], P_DRAGBREAK);

	// ɥ쥳ɤϿ
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = wid;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].chgmod = 0x10;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].limit = (RECT){{0, 0, 0, 0}};
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[0] = bar[0];
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[1] = bar[1];
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].pid[2] = -1;

	return;
}


//
// ɥĤ
//
void	MAINWIN::close_win()
{
	wcls_wnd(wid, CLR);
	wid = -1;
	EVTOPE::winfo[CVAL::WIDX_MAINWIN].wid = 0;

	return;
}


//
// ɥطʿꤹ
//
void	MAINWIN::set_wbgpat(bool set)
{
	// ʬ
	wbgpat.spat.kind = 0;
	wbgpat.spat.hsize = 16;
	wbgpat.spat.vsize = 16;
	wbgpat.spat.bgcol = CVAL::RGB_WHITE;

	// 䵸ͭǡƤȿ
	const	WINCOL	wcol = appl->fsn->get_wcol();

	if (wcol.mask == 0) {
		// طʿŬ
		wbgpat.spat.fgcol = appl->get_bgcol();
		wbgpat.spat.mask = FILL100;
	} else {
		// 䵸ͭǡͤȿ
		wbgpat.spat.fgcol = wcol.col;
		wbgpat.spat.mask = reinterpret_cast<UB*>(wcol.mask & 0x0007);
	}

	if (set) {
		// ȿǤ
		wset_bgp(wid, &wbgpat);
		redisp(NULL);
	}

	return;
}


//
// ȴϢ
//
// type <  0 : ȤѴ(ä -2 ξȤ)
//      == 0 : 
//      == 1 : ( window  active Ǥ뤳)
//      >  1 : ( window  active Ǥ뤳)
//
void	MAINWIN::disp_selfrm(W type)
{
	if (type < 0) {
		// ȤѴ
		delete selfrm;
		selfrm = NULL;

		if (type == -2) {
			// Ȥ
			try {
				selfrm = new SELFRM(gid);
			} catch (EXCEPT_SELFRM) {
				;
			} catch (std::bad_alloc) {
				errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
			} catch (...) {
				;
			}
		}
	} else if (selfrm != NULL) {
		// Ȥɽ
		if (type == 0) {
			// 
			selfrm->off();
		} else if (wget_act(NULL) == wid) {
			//  window  active ǤʤȡɽϤʤ
			if (type == 1) {
				// 
				selfrm->on();
			} else {
				// 
				selfrm->blink();
			}
		}
	}

	return;
}


//
// ɽ򥹥뤵
//
void	MAINWIN::scroll_work(PNT p)
{
	W	rv;

	rv = wscr_wnd(wid, NULL, p.x, p.y, W_SCRL | W_RDSET);
	set_narea();			// Ĵ˹Ԥ
	if ((rv >= ER_OK) && (rv & W_RDSET)) {
		// scroll ȼ
		disp_fn(0, NULL);
	}

	// ɽ֤䵤˳Ф
	appl->fsn->set_vpos(vrect.p.lefttop);

	// scroll bar ι
	sbar_setup();

	return;
}


//
// ºΰȥС
//
void	MAINWIN::upd_narea()
{
	set_narea();
	sbar_setup();

	return;
}


//
// (ޤ)ȥ졼ͳǤΥȥ졼ʣ/ưμ¹
//
// ֤ͤ error code Ф/䵤θĿ
//
W	MAINWIN::do_poptray(bool tmp, bool cut)
{
	W	rv;

	rv = 0;
	try {
		PNT	p;

		if (tmp) {
			p = ppos;
		} else {
			// menu ͳξ PD ֤кɸˤʤäƤ
			p = wevt.s.pos;
			gcnv_rel(gid, &p);
		}
		rv = TRAYOPE::pop_tray(false, tmp, cut, true, p);
		if ((rv <= 0) && (!(tmp))) {
			// error code üΤ
			errpanel(DBOX::EPNL_POPTRAY, -10001);
		}
	} catch (EXCEPT_VOBJ& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if ((rv == ER_NOMEM) || (rv == ER_NOSPC)) {
			errpanel(DBOX::EPNL_NEWVOBJ, rv);
			rv = 0;
		} else if (rv == ER_LIMIT) {
			errpanel(DBOX::EPNL_VOBJSKIP, rv);
			rv = 0;
		}
	} catch (EXCEPT_VOBJS& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if ((rv == ER_NOMEM) || (rv == ER_NOSPC)) {
			errpanel(DBOX::EPNL_NEWVOBJ, rv);
			rv = 0;
		}
	} catch (std::bad_alloc) {
		DPRINT(("memory allocaiton error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		DPRINT(("other exception.\n"));
		rv = ER_SYS;
	}
	ppos = (PNT){0, 0};

	if (rv > 0) {
		// Ȥι
		disp_selfrm(-2);
		disp_selfrm(1);
		upd_narea();
		appl->eobj->set_editflg(true);  // 
		if (tmp) {
			UD_OPE::make_undo(UD_OPE::UT_ADD);
		} else {
			UD_OPE::make_undo((cut) ? UD_OPE::UT_TRAYADD : UD_OPE::UT_ADD);
		}
	}

	return rv;
}


//
// 
//
void	MAINWIN::redisp(RECT* r)
{
	RECT	vr;

	gget_vis(gid, &vr);

	// 
	wera_wnd(wid, r);
	if (r != NULL) {
		gset_vis(gid, *r);
	}
	appl->vobjs.dsp_vobj(-1, r);

	gset_vis(gid, vr);

	return;
}


//
// (window event)
//
void	MAINWIN::idle_fn(bool pdflg)
{
	if (pdflg) {
		// PD 
		W	pdtype;
		const	W	vid = appl->vobjs.fnd_posvobj(wevt.s.pos);

		if (wevt.s.stat & (ES_LSHFT | ES_RSHFT)) {
			// 
			pdtype = PS_MODIFY;
		} else if (vid >= 0) {
			VOBJ*	vobj = const_cast<VOBJ*>(appl->vobjs.srch_vobj(vid));

			if (vobj->get_sel()) {
				// 
				W	vtype = ofnd_vob(-vid,wevt.s.pos,NULL);

				if (vobj->get_back()) {
					// (طʾ֤ξˤ)
					// (طʾ֤ϾʤΤǡ
					//  ˤϤʤϤ)
					pdtype = PS_SELECT;
				} else if (vtype == V_PICT) {
					// (ԥȥˤ)
					pdtype = PS_SELECT;
				} else if (vobj->get_hold()) {
					// ư(֤ξˤ)
					pdtype = PS_MOVE;
				} else if ((vtype == V_LTHD) ||
					   (vtype == V_RTHD) ||
					   (vtype == V_LBHD) ||
					   (vtype == V_RBHD)) {
					// ѷ(Ѿ֤Υϥɥˤ)
					pdtype = PS_RSIZ;
				} else {
					// ư(ϥɥ볰β)
					pdtype = PS_MOVE;
				}
			} else {
				// ()
				pdtype = PS_SELECT;
			}
		} else {
			// 
			pdtype = PS_SELECT;
		}

		// ȿ
		setpointer(pdtype, NULL);
	}

	// ȤΤĤ
	disp_selfrm(2);

	return;
}


//
// ɽ(window event)
//
void	MAINWIN::disp_fn(W mode, RECT* newr)
{
	if (mode < 0) {
		// 
		set_narea();
		redisp(NULL);
		sbar_setup();
		appl->vobjs.do_autoexec();	// ưưμ¹
	} else {
		// ¾κ
		disp_selfrm(0);
		if (newr != NULL) {
			// Ѥä
			if ((newr->c.left < CVAL::LIMIT_RECT.c.left) ||
			    (newr->c.top < CVAL::LIMIT_RECT.c.top)) {
				// 夬°ʲˤʤ
				vrect.c.right = rectwidth(*newr);
				vrect.c.bottom = rectheight(*newr);
				vrect.p.lefttop = (PNT){0, 0};
				wset_wrk(wid, &vrect);
				do {
					wsta_dsp(wid, NULL, NULL);
				} while (wend_dsp(wid) > 0);
				redisp(NULL);
			} else {
				vrect = *newr;
			}
			gset_vis(gid, vrect);
			set_narea();
		}

		// ׵νʬ
		do {
			W	i;
			RECT	r;

			i = wsta_dsp(wid, &r, rlist);
			if (i <= 0) break;
			if (i > 4) {
				redisp(&r);
			} else {
				while (i--) {
					redisp(&rlist[i].rcomp);
				}
			}
		} while (wend_dsp(wid) > 0);

		// 䵸ͭǡؤȿ
		WINATTR	wattr = static_cast<WINATTR>(appl->fsn->get_wattr());

		if (mode == 5) {
			// ̥⡼ɤˤʤä
			wattr.fwindow = true;
		} else if ((newr != NULL) || (mode == 1)) {
			// Ѥä֤ư
			WDSTAT	wstat;

			wget_sts(wid, &wstat, NULL);
			wattr.rect = wstat.r;
			wattr.fwindow = false;
		}
		appl->fsn->set_wattr(wattr);
		appl->fsn->set_vpos(vrect.p.lefttop);
		sbar_setup();
		disp_selfrm(1);
	}

	return;
}


//
// Ͻ(window event)
//
W	MAINWIN::key_fn()
{
	W	rv;

	rv = 0;
	try {
		std::auto_ptr<KB_OPE>	ope;

		if (wevt.e.data.key.code == KC_CAN) {
			// [ä] Ȥ
			ope = std::auto_ptr<KB_OPE>(new KB_CAN());
		} else if (wevt.e.data.key.code == KC_DEL) {
			// [] Ȥ
			ope = std::auto_ptr<KB_OPE>(new KB_DEL());
		} else if ((appl->vobjs.get_selvid() >= 0) &&
			   ((wevt.s.stat & (ES_BUT2 | ES_CMD)) == 0x0000) &&
			   ((wevt.e.data.key.code == KC_CC_U) ||
			    (wevt.e.data.key.code == KC_CC_D) ||
			    (wevt.e.data.key.code == KC_CC_L) ||
			    (wevt.e.data.key.code == KC_CC_R))) {
			// βȤΰư
			ope = std::auto_ptr<KB_OPE>(new KB_MOVE(wevt.e.data.key.code, wevt.s.stat));
		} else {
			// ɽΥ
			ope = std::auto_ptr<KB_OPE>(new KB_SCRL(wevt.e.data.key.code, wevt.s.stat));
		}

		// μ¹
		ope->main();
	} catch (EXCEPT_KBOPE& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if (rv == I_DLEDERR::KB_NOOPE) {
			// ϼ¹Ԥʤä
			rv = 0;
		}
	} catch (std::bad_alloc) {
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		rv = ER_SYS;
	}

	return rv;
}


//
// ܥץ쥹(window event)
//
W	MAINWIN::press_fn()
{
	W	rv;

	rv = 0;
	try {
		// PD ֡ˡ˱ object 
		std::auto_ptr<PD_OPE>	ope;
		const	W	vid = appl->vobjs.fnd_posvobj(wevt.s.pos);

		if ((vid >= 0) &&
		    ((wevt.s.stat & (ES_LSHFT | ES_RSHFT)) == 0x0000)) {
			// ֤ǤϤʤĲȾΤɤ
			VOBJ*	vobj = const_cast<VOBJ*>(appl->vobjs.srch_vobj(vid));

			if ((!(vobj->get_back())) && (!(vobj->get_sel()))) {
				// طʲƤʤʤ֤
				disp_selfrm(0);
				appl->vobjs.set_allsel(false, false);
				vobj->set_sel(true);
				disp_selfrm(-2);
				disp_selfrm(1);
			}

			// PD ̤μ/ʬ
			W	type;

			type = wchk_dck(wevt.s.time);
			if ((type == W_PRESS) || (type == W_QPRESS)) {
				// press  quick press
				if (vobj->get_back()) {
					DPRINT(("background vobj press.\n"));
					ope = std::auto_ptr<PD_OPE>(new PD_NPRS());
				} else {
					W	vtype = ofnd_vob(-vid, wevt.s.pos, NULL);

					if ((!(vobj->get_hold())) &&
					    ((vtype == V_LTHD) ||
					     (vtype == V_RTHD) ||
					     (vtype == V_LBHD) ||
					     (vtype == V_RBHD))) {
						// handle ĤǤ
						DPRINT(("handle press.\n"));
						ope = std::auto_ptr<PD_OPE>(new PD_HPRS(vid, vtype));
					} else if (type == W_PRESS) {
						DPRINT(("vobj press.\n"));
						// press ǤĤǤ
						ope = std::auto_ptr<PD_OPE>(new PD_VPRS(vid));
					} else {
						// quick press ǤĤǤ
						DPRINT(("vobj quick press.\n"));
						ope = std::auto_ptr<PD_OPE>(new PD_VQP(vid));
					}
				}
			} else if (type == W_CLICK) {
				// click
				DPRINT(("click.\n"));
				ope = std::auto_ptr<PD_OPE>(new PD_CLK());
			} else if (type == W_DCLICK) {
				// double click
				DPRINT(("double click.\n"));
				ope = std::auto_ptr<PD_OPE>(new PD_DCLK());
			} else {
				// (ȯʤ)
				throw EXCEPT_MAINWIN(0);	// ꤲ
			}
		} else {
			// ȤǤϤʤ(ɥϤʬ)
			W	type;

			type = wchk_dck(wevt.s.time);
			if ((type == W_PRESS) || (type == W_QPRESS)) {
				DPRINT(("workarea press.\n"));
				ope = std::auto_ptr<PD_OPE>(new PD_NPRS());
			} else if (type == W_CLICK) {
				// click
				DPRINT(("click.\n"));
				ope = std::auto_ptr<PD_OPE>(new PD_CLK());
			} else if (type == W_DCLICK) {
				// double click
				DPRINT(("double click.\n"));
				ope = std::auto_ptr<PD_OPE>(new PD_DCLK());
			} else {
				// (ȯʤ)
				throw EXCEPT_MAINWIN(0);	// ꤲ
			}
		}

		// μ¹
		ope->main();
	} catch (EXCEPT_PDOPE& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if (rv == I_DLEDERR::PD_NOOPE) {
			// ϼ¹Ԥʤä
			rv = 0;
		}
	} catch (EXCEPT_MAINWIN) {
		;			// ⤷ʤ
	} catch (EXCEPT_VOBJ& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if (rv == ER_LIMIT) {
			// 
			errpanel(DBOX::EPNL_NEWOBJ, rv);
			rv = ER_OK;
		}
	} catch (EXCEPT_VOBJS& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if (rv == ER_LIMIT) {
			// 
			errpanel(DBOX::EPNL_NEWVOBJ, rv);
			rv = ER_OK;
		}
	} catch (std::bad_alloc) {
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		rv = ER_SYS;
	}

	return rv;
}


//
// Ž׵(window event)
//
W	MAINWIN::paste_fn(PNT pos)
{
	W	rv;
	PNT	p;

	rv = W_NAK;
	p = wevt.s.pos;

	try {
		if (TRAYOPE::pop_tray(true, true, false, false, p) > 0) {
			ppos = p;	// Ž߰
			rv = W_ACK;
		}
	} catch (...) {
		;			// Ԥ W_NAK 
	}

	return rv;
}


//
// (window event)
//
void	MAINWIN::scroll_fn(W type, W diff)
{
	W	diff2;
	PNT	p;
	const	RECT	varea = appl->fsn->get_area();
	 
	if ((type & 0x0c) == 0) {
		// smooth scroll  DLED Ʊ®٤Ĥ
		W       max;
 
		diff2 = CHSSTD * ((diff >> 1) + 1);
		max = ((type & 2) ? rectwidth(vrect) : rectheight(vrect)) >> 1;
		if (diff2 > max) {
			diff2 = max;
		}
	} else {
		diff2 = 0;
	}
	p = chk_scroll(type, diff, diff2, vrect, varea);

	// ư̤ 0 λϤʤˤ⤷ʤ
	if ((p.x != 0) || (p.y != 0)) {
		scroll_work(p);
	}

	return;
}


// ---------------------------------------------------- MAINWIN  private ؿ
//
// Сͤꤹ
//
void	MAINWIN::sbar_setup()
{
	W	val[4];
	const	RECT	varea = appl->fsn->get_area();

	// С(ľְư)
	val[0] = vrect.c.top;
	val[1] = vrect.c.bottom;
	val[2] = 0;
	val[3] = rectheight(varea);
	if (val[1] > val[3]) {
		val[1] = val[3];
	}
	cset_val(bar[0], 4, val);

	// С(ʿְư)
	val[0] = vrect.c.right;
	val[1] = vrect.c.left;
	val[2] = rectwidth(varea);
	val[3] = 0;
	if (val[0] > val[2]) {
		val[0] = val[2];
	}
	cset_val(bar[1], 4, val);

	return;
}


//
// ȤΰȼºΰĴ
//
void	MAINWIN::set_narea()
{
	RECT	narea = appl->fsn->get_area();
	const	RECT	varea = appl->vobjs.get_allarea();

	gget_vis(gid, &vrect);
	narea.c.right = (vrect.c.right > varea.c.right) ? vrect.c.right : varea.c.right;
	narea.c.bottom = (vrect.c.bottom > varea.c.bottom) ? vrect.c.bottom : varea.c.bottom;
	appl->fsn->set_area(narea);

	return;
}
