//
//	mainmenu.h (Ȱ/ᥤ˥塼ϥإå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_I_DLED_MAINMENU_H
#define	_I_DLED_MAINMENU_H

#include	<basic.h>
#include	<btron/btron.h>


// ------------------------------------------------------------- class MAINMENU
class	MAINMENU {
	enum MENUIDX {			// ˥塼ι໲ֹ
		MIDX_VOBJ     = 0,	// 
		MIDX_TOOL     = 1,	// ʪ
		MIDX_EXEC     = 2,	// ¹Է
		MIDX_EXIT     = 3,	// [λ]
		MIDX_NEWSAVE  = 4,	// [¸]-[¿Ȥ]
		MIDX_SAVE     = 5,	//       -[μ¿Ȥ]
		MIDX_FWINDOW  = 6,	// [ɽ]-[ɽ]
		MIDX_REDISP   = 7,	//       -[ɽ]
		MIDX_CHGBACK  = 8,	//       -[طʿѹ]
		MIDX_HIDDEN   = 9,	//       -[]
		MIDX_UNDO     = 10,	// [Խ]-[ä]
		MIDX_TOTRAY   = 11,	//       -[ȥ졼ʣ/ư]
		MIDX_FROMTRAY = 12,	//       -[ȥ졼ʣ/ư]
		MIDX_DELETE   = 13,	//       -[]
		MIDX_ALLSEL   = 14,	//       -[٤]
		MIDX_AUTOTIDY = 15,	//       -[ư]
		MIDX_SELFTIDY = 16,	//       -[]
		MIDX_NUMBER   = 17,	//       -[Ф/]
		MIDX_HOLD     = 18,	// [ݸ]-[경/]
		MIDX_BACK     = 19,	//       -[طʲ/طʲ]

		MENU_NUM = 20		// 
	};

	enum MENUINUM {			// ˥塼ֹ
		MINUM_EXIT     = (MIDX_EXIT - 3),
		MINUM_NEWSAVE  = (MIDX_NEWSAVE - 3),
		MINUM_SAVE     = (MIDX_SAVE - 3),
		MINUM_FWINDOW  = (MIDX_FWINDOW - 3),
		MINUM_REDISP   = (MIDX_REDISP - 3),
		MINUM_CHGBACK  = (MIDX_CHGBACK - 3),
		MINUM_HIDDEN   = (MIDX_HIDDEN - 3),
		MINUM_UNDO     = (MIDX_UNDO - 3),
		MINUM_TOTRAY   = (MIDX_TOTRAY - 3),
		MINUM_FROMTRAY = (MIDX_FROMTRAY - 3),
		MINUM_DELETE   = (MIDX_DELETE - 3),
		MINUM_ALLSEL   = (MIDX_ALLSEL - 3),
		MINUM_AUTOTIDY = (MIDX_AUTOTIDY - 3),
		MINUM_SELFTIDY = (MIDX_SELFTIDY - 3),
		MINUM_NUMBER   = (MIDX_NUMBER - 3),
		MINUM_HOLD     = (MIDX_HOLD - 3),
		MINUM_BACK     = (MIDX_BACK - 3)
	};

	#define	MMASK(n)	(1 << n)
	enum MENUMASK {			// ˥塼Υޥ
		MMASK_EXIT     = MMASK(MINUM_EXIT),
		MMASK_NEWSAVE  = MMASK(MINUM_NEWSAVE),
		MMASK_SAVE     = MMASK(MINUM_SAVE),
		MMASK_FWINDOW  = MMASK(MINUM_FWINDOW),
		MMASK_REDISP   = MMASK(MINUM_REDISP),
		MMASK_CHGBACK  = MMASK(MINUM_CHGBACK),
		MMASK_HIDDEN   = MMASK(MINUM_HIDDEN),
		MMASK_UNDO     = MMASK(MINUM_UNDO),
		MMASK_TOTRAY   = MMASK(MINUM_TOTRAY),
		MMASK_FROMTRAY = MMASK(MINUM_FROMTRAY),
		MMASK_DELETE   = MMASK(MINUM_DELETE),
		MMASK_ALLSEL   = MMASK(MINUM_ALLSEL),
		MMASK_AUTOTIDY = MMASK(MINUM_AUTOTIDY),
		MMASK_SELFTIDY = MMASK(MINUM_SELFTIDY),
		MMASK_NUMBER   = MMASK(MINUM_NUMBER),
		MMASK_HOLD     = MMASK(MINUM_HOLD),
		MMASK_BACK     = MMASK(MINUM_BACK)
	};

	enum MENUPIDX {			// ƹܤֹ
		MPIDX_EXIT    = 0,	// [λ] 
		MPIDX_SAVE    = 1,	// [¸] 
		MPIDX_DISP    = 2,	// [ɽ] 
		MPIDX_EDIT    = 3,	// [Խ] 
		MPIDX_PROTECT = 4,	// [ݸ] 
		MPIDX_VOBJ    = 5,	// [] 
		MPIDX_FILE    = 6,	// [¿] 
		MPIDX_DISK    = 7,	// [ǥ] 
		MPIDX_WINDOW  = 8,	// [ɥ] 
		MPIDX_TOOL    = 9,	// [ʪ] 
		MPIDX_EXEC    = 10	// [¹] 
	};

public:
	MAINMENU();			// constructor
	~MAINMENU();			// destructor

	static	FUNCP	mfun[MENU_NUM];	// ˥塼ؿơ֥

	// ˥塼μ¹Խ
	W	exec();

	// ƥ˥塼ؿ(static member)
	static	W	mn_exit(W par);		// [λ]
	static	W	mn_newsave(W par);	// [¸]-[¿Ȥ]
	static	W	mn_save(W par);		//       -[μ¿Ȥ]
	static	W	mn_fwindow(W par);	// [ɽ]-[ɽ]
	static	W	mn_redisp(W par);	//       -[ɽ]
	static	W	mn_chgback(W par);	//       -[طʿѹ]
	static	W	mn_hidden(W par);	//       -[]
	static	W	mn_undo(W par);		// [Խ]-[ä]
	static	W	mn_totray(W par);	//       -[ȥ졼ʣ/ư]
	static	W	mn_fromtray(W par);	//       -[ȥ졼ʣ/ư]
	static	W	mn_delete(W par);	//       -[]
	static	W	mn_allsel(W par);	//       -[٤]
	static	W	mn_autotidy(W par);	//       -[ư]
	static	W	mn_selftidy(W par);	//       -[]
	static	W	mn_number(W par);	//       -[Ф/]
	static	W	mn_hold(W par);		// [ݸ]-[경/]
	static	W	mn_back(W par);		//       -[طʲ/طʲ]
	static	W	mn_vobj(W par);		// [] 
	static	W	mn_tool(W par);		// [ʪ] 
	static	W	mn_exec(W par);		// [¹] 

	// application μ¹(static memer)
	static	void	appl_exec(W par, W vid = 0);

private:
	W	mid;			// menu ID

	// 󥸥
	void	set_indi();

	// ͭǽ
	void	set_enable();

	// ¾ΤΤͭǽ
	void	set_enable_other();
};

#endif	// _I_DLED_MAINMENU_H
