//
//	mainmenu.cc (Ȱ/ᥤ˥塼)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>

#include	<memory>

#include	"val.h"
#include	"cval.h"
#include	"dbox.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjope.h"
#include	"vobjs.h"
#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"mainmenu.h"
#include	"ud_ope.h"
#include	"trayope.h"
#include	"saveope.h"
#include	"tidypnl.h"


// ѿ(˥塼ؿ)
LOCAL	W	svid = -1;		// ˥塼¹Իβ ID


// ѿμ(from libapp)
IMPORT	W	_inact_vmitem[];	// ϥ˥塼ζػߤ


// --------------------------------------- MAINMENU  static member ѿμ
FUNCP	MAINMENU::mfun[MENU_NUM];


// ---------------------------------- MAINMENU  public ؿ( static member)
//
// constructor
//
MAINMENU::MAINMENU()
	: mid(-1)
{
	// ˥塼ؿơ֥ν
	mfun[MIDX_VOBJ] = reinterpret_cast<FUNCP>(&mn_vobj);
	mfun[MIDX_TOOL] = reinterpret_cast<FUNCP>(&mn_tool);
	mfun[MIDX_EXEC] = reinterpret_cast<FUNCP>(&mn_exec);
	mfun[MIDX_EXIT] = reinterpret_cast<FUNCP>(&mn_exit);
	mfun[MIDX_NEWSAVE] = reinterpret_cast<FUNCP>(&mn_newsave);
	mfun[MIDX_SAVE] = reinterpret_cast<FUNCP>(&mn_save);
	mfun[MIDX_FWINDOW] = reinterpret_cast<FUNCP>(&mn_fwindow);
	mfun[MIDX_REDISP] = reinterpret_cast<FUNCP>(&mn_redisp);
	mfun[MIDX_CHGBACK] = reinterpret_cast<FUNCP>(&mn_chgback);
	mfun[MIDX_HIDDEN] = reinterpret_cast<FUNCP>(&mn_hidden);
	mfun[MIDX_UNDO] = reinterpret_cast<FUNCP>(&mn_undo);
	mfun[MIDX_TOTRAY] = reinterpret_cast<FUNCP>(&mn_totray);
	mfun[MIDX_FROMTRAY] = reinterpret_cast<FUNCP>(&mn_fromtray);
	mfun[MIDX_DELETE] = reinterpret_cast<FUNCP>(&mn_delete);
	mfun[MIDX_ALLSEL] = reinterpret_cast<FUNCP>(&mn_allsel);
	mfun[MIDX_AUTOTIDY] = reinterpret_cast<FUNCP>(&mn_autotidy);
	mfun[MIDX_SELFTIDY] = reinterpret_cast<FUNCP>(&mn_selftidy);
	mfun[MIDX_NUMBER] = reinterpret_cast<FUNCP>(&mn_number);
	mfun[MIDX_HOLD] = reinterpret_cast<FUNCP>(&mn_hold);
	mfun[MIDX_BACK] = reinterpret_cast<FUNCP>(&mn_back);

	// ˥塼Ͽ
	mid = openmenu(DBOX::MENU_MAIN);
	if (mid < ER_OK) {
		throw EXCEPT_MAINMENU(mid);
	}
}


//
// destructor
//
MAINMENU::~MAINMENU()
{
	closemenu();
}


//
// ˥塼μ¹Խ
//
W	MAINMENU::exec()
{
	svid = appl->vobjs.get_selvid();

	set_indi();			// 󥸥
	set_enable();			// ͭǽ

	return selmenu(svid, mfun);
}


// ------------------------------------- MAINMENU  public ؿ(static member)
//
// [λ]
//
W	MAINMENU::mn_exit(W par)
{
	return EVTOPE::evt_finish(0, 0);
}


//
// [¸]-[¿Ȥ]
//
W	MAINMENU::mn_newsave(W par)
{
	W	rv;
	W	vid;
	LINK	lnk;

	rv = 0;
	if (SAVEOPE::make_newfile(vid, lnk) > 0) {
		// ¸
		try {
			SAVEOPE	save(vid, &lnk);

			save.main();
		} catch (EXCEPT_SAVEOPE& err) {
			ERR	er;

			er = err.get_err();
			DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
			if (er == I_DLEDERR::SAVE_CANCEL) {
				;
			} else if ((er == ER_NOMEM) || (er == ER_NOSPC)) {
				errpanel(DBOX::EPNL_MEMORY, er);
			} else {
				errpanel(DBOX::EPNL_WRITE, er);
			}
		} catch (std::bad_alloc) {
			DPRINT(("memory allocation error.\n"));
			errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		} catch (...) {
			DPRINT(("other exception.\n"));
			rv = ER_SYS;
		}
	}

	return rv;
}


//
// [¸]-[μ¿Ȥ]
//
W	MAINMENU::mn_save(W par)
{
	W	rv;

	rv = 0;
	try {
		SAVEOPE	save(false);

		save.main();
		UD_OPE::clear_undo();
	} catch (EXCEPT_SAVEOPE& err) {
		ERR	er;

		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		if (er == I_DLEDERR::SAVE_CANCEL) {
		} else if ((er == ER_NOMEM) || (er == ER_NOSPC)) {
			errpanel(DBOX::EPNL_MEMORY, er);
		} else {
			errpanel(DBOX::EPNL_WRITE, er);
		}
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		DPRINT(("other exception.\n"));
		rv = ER_SYS;
	}

	return rv;
}


//
// [ɽ]-[ɽ]
//
// ɽ׵¦䵸ͭǡι򤹤ΤǡǤѹʤ
//
W	MAINMENU::mn_fwindow(W par)
{
	W	mode;
	RECT	r;

	mode = wchg_wnd(appl->gui->mwin->get_wid(), &r, W_MOVE);
	if (mode >= 0) {
		EVTOPE::evt_disp(CVAL::WIDX_MAINWIN, mode | 0x04, &r);
	}

	return 0;			//  0
}


//
// [ɽ]-[ɽ]
//
W	MAINMENU::mn_redisp(W par)
{
	appl->gui->mwin->disp_selfrm(0);
	appl->gui->mwin->redisp(NULL);
	appl->gui->mwin->disp_selfrm(1);

	return 0;			//  0
}


//
// [ɽ]-[طʿѹ]
//
W	MAINMENU::mn_chgback(W par)
{
	WINCOL	wcol = static_cast<WINCOL>(appl->fsn->get_wcol());

	if (chgbgcol(&wcol.mask, &wcol.col, appl->get_bgcol()) == 1) {
		appl->gui->mwin->disp_selfrm(0);
		appl->fsn->set_wcol(wcol);
		appl->gui->mwin->set_wbgpat(true);
		appl->gui->mwin->disp_selfrm(1);
	}

	return 0;			//  0
}


//
// [ɽ]-[]
//
W	MAINMENU::mn_hidden(W par)
{
	appl->gui->mwin->disp_selfrm(0);
	appl->vobjs.set_hidden(!(appl->vobjs.get_hidden()));
	appl->gui->mwin->redisp(NULL);
	appl->gui->mwin->disp_selfrm(1);

	return 0;			//  0
}


//
// [Խ]-[ä]
//
W	MAINMENU::mn_undo(W par)
{
	UD_OPE::exec_undo();

	return 0;			//  0
}


//
// [Խ]-[ȥ졼ʣ]/[ȥ졼ذư]
//
W	MAINMENU::mn_totray(W par)
{
	W	rv;

	rv = 0;
	try {
		TRAYOPE::push_tray(-1, (par == 2), false, (SIZE){0, 0});
	} catch (std::bad_alloc) {
		DPRINT(("memory allocaiton error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		DPRINT(("other exception.\n"));
		rv = ER_SYS;
	}

	return rv;
}


//
// [Խ]-[ȥ졼ʣ]/[ȥ졼ư]
//
W	MAINMENU::mn_fromtray(W par)
{
	W	rv;

	rv = appl->gui->mwin->do_poptray(false, (par == 2));

	return ((rv >= 0) ? 0 : rv);
}


//
// [Խ]-[]
//
W	MAINMENU::mn_delete(W par)
{
	UD_OPE::make_undo(UD_OPE::UT_DEL);
	appl->gui->mwin->disp_selfrm(0);
	appl->vobjs.set_alldel(true, true);
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);
	appl->gui->mwin->upd_narea();
	appl->eobj->set_editflg(true);	// 

	return 0;			//  0
}


//
// [Խ]-[٤]
//
W	MAINMENU::mn_allsel(W par)
{
	appl->vobjs.set_allsel(true, false);
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);

	return 0;			//  0
}


//
// [Խ]-[ư]
//
W	MAINMENU::mn_autotidy(W par)
{
	UD_OPE::make_undo(UD_OPE::UT_MOVE);
	appl->gui->mwin->disp_selfrm(0);
	appl->vobjs.do_autotidy(appl->gui->mwin->get_vrect());
	appl->gui->mwin->redisp(NULL);
	appl->gui->mwin->upd_narea();
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);
	appl->eobj->set_editflg(true);	// 

	return 0;			//  0
}


//
// [Խ]-[]
//
W	MAINMENU::mn_selftidy(W par)
{
	bool	flg;

	flg = false;

	// ѥͥ򳫤
	try {
		TIDYPNL	pnl(svid > 0);

		flg = (pnl.exec() > 0);
	} catch (...) {
		;
	}

	// ̤ȿ
	appl->gui->mwin->disp_selfrm(0);
	if (flg) {
		UD_OPE::make_undo(UD_OPE::UT_MOVE);
		appl->vobjs.do_selftidy();
		appl->gui->mwin->redisp(NULL);
		appl->gui->mwin->upd_narea();
		appl->gui->mwin->disp_selfrm(-2);
		appl->eobj->set_editflg(true);	// 
	}
	appl->gui->mwin->disp_selfrm(1);

	return 0;
}


//
// [Խ]-[Ф]/[Ф]
//
W	MAINMENU::mn_number(W par)
{
	UD_OPE::make_undo((par == 1) ? UD_OPE::UT_FRONT : UD_OPE::UT_REAR);
	appl->gui->mwin->disp_selfrm(0);
	appl->vobjs.renum_selvobj(par == 1);
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);
	appl->eobj->set_editflg(true);	// 

	return 0;			//  0
}


//
// [ݸ]-[경]/[]
//
W	MAINMENU::mn_hold(W par)
{
	UD_OPE::make_undo((par == 1) ? UD_OPE::UT_HOLD : UD_OPE::UT_UNHOLD);
	appl->vobjs.set_allhold((par == 1), true);
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);
	appl->eobj->set_editflg(true);	// 

	return 0;			//  0
}


//
// [ݸ]-[طʲ]/[طʲ]
//
W	MAINMENU::mn_back(W par)
{
	switch (par) {
		case 1:
			// طʲ
			appl->gui->mwin->disp_selfrm(-1);
			UD_OPE::make_undo(UD_OPE::UT_BACK);
			appl->vobjs.set_allback(true, true);
			break;
		default:
		case 2:
			// طʲ
			appl->gui->mwin->disp_selfrm(-1);
			UD_OPE::make_undo(UD_OPE::UT_UNBACK);
			appl->vobjs.set_allsel(false, false);
			appl->vobjs.set_allback(false, false);
			break;
	}
	appl->gui->mwin->disp_selfrm(-2);
	appl->gui->mwin->disp_selfrm(1);
	appl->eobj->set_editflg(true);	// 

	return 0;			//  0
}


//
// [] 
//
W	MAINMENU::mn_vobj(W par)
{
	W	rv;

	rv = 0;
	try {
		appl->vobjs.mn_vobj(par);
	} catch (EXCEPT_VOBJ& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if ((rv == ER_NOMEM) || (rv == ER_NOSPC)) {
			errpanel(DBOX::EPNL_MEMORY, rv);
			rv = 0;
		}
	} catch (EXCEPT_VOBJS& err) {
		rv = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), rv, rv >> 16));
		if ((rv == ER_NOMEM) || (rv == ER_NOSPC)) {
			errpanel(DBOX::EPNL_MEMORY, rv);
			rv = 0;
		}
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
	} catch (...) {
		;
	}

	return rv;
}


//
// [ʪ] 
//
W	MAINMENU::mn_tool(W par)
{
	appl_exec(par, 0);

	return 0;			//  0
}


//
// [¹] 
//
W	MAINMENU::mn_exec(W par)
{
	appl_exec(par, appl->vobjs.get_selvid());

	return 0;			//  0
}


//
// application μ¹( menu )
//
void	MAINMENU::appl_exec(W par, W vid)
{
	setpointer(PS_BUSY, NULL);
	if (oexe_apg(vid, par) > 0) {
		setpointer(0x8001, NULL);
	}

	return;
}


// --------------------------------------------------- MAINMENU  private ؿ
//
// 󥸥
//
void	MAINMENU::set_indi()
{
	const	WINATTR	wattr = appl->fsn->get_wattr();

	indmenu(MINUM_FWINDOW, (W)(wattr.fwindow), 0);
	indmenu(MINUM_HIDDEN, (W)(appl->vobjs.get_hidden()), 0);

	return;
}


//
// ͭǽ
//
void	MAINMENU::set_enable()
{
	W	mask;

	mask = 0;

	// [ä] 
	mask |= (appl->gui->undo == NULL) ? MMASK_UNDO : 0;

	// [ȥ졼ʣ]/[ȥ졼ư] 
	mask |= (tget_sts(NULL, NULL) <= 0) ? MMASK_FROMTRAY : 0;

	// mask ȿ
	inactmenu(mask, 0);

	// ¾(ֹꤹ)
	set_enable_other();

	// ϤΥ˥塼
	if (svid > 0) {
		if (appl->vobjs.get_hold(svid)) {
			// 򤷤Ƥ벾Ȥϸ경֤ʤ顢[] ϶ػ
			_inact_vmitem[0] = 0xffffffff;
		} else {
			_inact_vmitem[0] = 0;
		}
	}

	return;
}


//
// ¾ΤΤͭǽ
//
// оݤϰʲΤ
//	[Խ]-[ȥ졼ʣ]
//	      -[ȥ졼ذư]
//	      -[]
//	      -[٤]
//	      -[ư]
//	      -[]
//            -[Ф]
//            -[Ф]
//	[ݸ]-[경]
//	      -[]
//	      -[طʲ]
//	      -[طʲ]
//
void	MAINMENU::set_enable_other()
{
	UW	tocopy;			// [Խ]-[ȥ졼ʣ] 
	UW	tomove;			//       -[ȥ졼ذư] 
	UW	del;			//       -[] 
	UW	allsel;			//       -[٤] 
	UW	autotidy;		//       -[ư] 
	UW	tidy;			//       -[] 
	UW	number;			//       -[Ф/] 
	UW	hold;			// [ݸ]-[[경] 
	UW	nothold;		//       -[] 
	UW	back;			//       -[طʲ] 
	UW	notback;		//       -[طʲ] 
	const	VOBJ*	vobj = appl->vobjs.get_vobj();

	tocopy = M_INACT;
	tomove = M_INACT;
	del = M_INACT;
	allsel = M_INACT;
	autotidy = M_INACT;
	tidy = M_INACT;
	number = M_INACT;
	hold = M_INACT;
	nothold = M_INACT;
	back = M_INACT;
	notback = M_INACT;

	if (vobj != NULL) {
		VOBJ*	ptr = const_cast<VOBJ*>(vobj);

		do {
			const	VLINK*	vlnk = ptr->get_vlnk();
			if ((!(vlnk->attr & V_HIDDEN)) ||
			    (appl->vobjs.get_hidden())) {
				// ɽ֤βȤ
				allsel = M_ACT;
				autotidy = M_ACT;
			}

			if (ptr->get_back()) {
				// طʲƤΤ
				notback = M_ACT;
			}

			if (ptr->get_sel()) {
				// 
				tocopy = M_ACT;
				number = M_ACT;

				if (ptr->get_hold()) {
					// /
					nothold = M_ACT;
				} else {	
					// /
					tomove = M_ACT;
					del = M_ACT;
					hold = M_ACT;
					tidy = M_ACT;
				}

				if (!(ptr->get_back())) {
					// /طʾ
					back = M_ACT;
				}
			}
			ptr = const_cast<VOBJ*>(ptr->get_next());
		} while (ptr != vobj);
	}

	// ֤ꤹ
	mchg_atr(mid, 0x0302, tocopy);
	mchg_atr(mid, 0x0304, tomove);
	mchg_atr(mid, 0x0306, del);
	mchg_atr(mid, 0x0308, allsel);
	mchg_atr(mid, 0x0309, autotidy);
	mchg_atr(mid, 0x030a, tidy);
	mchg_atr(mid, 0x030c, number);
	mchg_atr(mid, 0x030d, number);
	mchg_atr(mid, 0x0401, hold);
	mchg_atr(mid, 0x0402, nothold);
	mchg_atr(mid, 0x0404, back);
	mchg_atr(mid, 0x0405, notback);

	return;
}
