//
//	appl_pst.cc (Ȱ/application -ǡŽߵư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"fusen.h"
#include	"trayope.h"
#include	"tadload.h"
#include	"saveope.h"


// ----------------------------------------------- I_DLED_PSTREQ  public ؿ
//
// constructor
//
I_DLED_PSTREQ::I_DLED_PSTREQ(const M_PASTEREQ* msg)
	: rspflg(1), igid(-1), iwid(-1)
{
	DPRINT(("I_DLED_PSTREQ constructor\n"));

	// μ
	mydat.msg.pstmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.lnk = msg->lnk;
}


//
// destructor
//
I_DLED_PSTREQ::~I_DLED_PSTREQ()
{
	DPRINT(("I_DLED_PSTREQ destructor\n"));
	if (iwid >= 0) {
		odel_vob(-iwid, NOCLR);
		wcls_wnd(iwid, NOCLR);
	}
	if (igid >= 0) {
		gcls_env(igid);
	}
	oend_req(mydat.vid, rspflg);
}


//
// application 
//
ERR	I_DLED_PSTREQ::main()
{
	ERR	er;

	er = ER_OK;

	try {
		// ɬפ class 
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		eobj = std::auto_ptr<EDITOBJ>(new EDITOBJ(&mydat.lnk));

		// ѲĶ
		igid = gnew_env((mydat.pwid < 0) ? -mydat.pwid : wget_gid(mydat.pwid));
		if (igid < ER_OK) {
			throw EXCEPT_INITERR(igid);
		}
		iwid = wopn_iwd(igid);
		if (iwid < ER_OK) {
			throw EXCEPT_INITERR(iwid);
		}
		vobjs.set_regid(-igid);

		// ¿Ȥɤ߹
		TADLOAD*	load;

		load = new TADLOAD(&mydat.lnk);
		load->main();
		delete load;

		// Ƥγǧ
		if (TRAYOPE::pop_tray(true, false, false, false, (PNT){0, 0}) > 0) {
			// Ž߽
			TRAYOPE::pop_tray(false, false, false, false, (PNT){0, 0});

			// ¿Ȥ¸
			SAVEOPE*	save;

			save = new SAVEOPE();
			save->main();
			delete save;

			// Žߤ
			rspflg = 0;
		}
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_TADLOAD& err) {	// ¿Ȥɤ߹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJ& err) {	// ñ첾ȴϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJS& err) {	// ȷϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_SAVEOPE& err) {	// ¿Ȥؤν񤭹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
