//
//	appl_ex.cc (Ȱ/application -ȤΥץư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"dbox.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"vobjs.h"
#include	"opndsp.h"
#include	"fusen.h"
#include	"guiope.h"
#include	"evtope.h"
#include	"mainwin.h"
#include	"tadload.h"


// ------------------------------------------------ I_DLED_EXREQ  public ؿ
//
// constructor
//
I_DLED_EXREQ::I_DLED_EXREQ(const M_EXECREQ* msg)
	: endprc(true)
{
	DPRINT(("I_DLED_EXREQ constructor\n"));

	// μ
	mydat.msg.exmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.pr = msg->r;
	mydat.lnk = msg->lnk;
	mydat.bgcol = msg->bgcol;
}


//
// destructor
//
I_DLED_EXREQ::~I_DLED_EXREQ()
{
	DPRINT(("I_DLED_EXREQ destructor\n"));
	if (endprc) {
		oend_prc(mydat.vid, NULL, 0);
	}
}


//
// application 
//
ERR	I_DLED_EXREQ::main()
{
	ERR	er;

	er = ER_OK;

	try {
		// ɬפ class 
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		gui = std::auto_ptr<GUIOPE>(new GUIOPE);
		eobj = std::auto_ptr<EDITOBJ>(new EDITOBJ(&mydat.lnk));

		// GUI Ϥν
		gui->init();
		vobjs.set_regid(gui->mwin->get_wid());	//  ID 

		// ¿Ȥɤ߹
		TADLOAD	load(&mydat.lnk);

		load.main();
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_FREAD, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_TADLOAD& err) {	// ¿Ȥɤ߹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_READ, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJ& err) {	// ñ첾ȴϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_SYSTEM, er);
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJS& err) {	// ȷϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		errpanel(DBOX::EPNL_SYSTEM, er);
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, ER_NOMEM);
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	// Ȥμ¹Ԥ
	osta_prc(mydat.vid, gui->mwin->get_wid());

	// ٥ȥ롼פγ
	DPRINT(("event loop start.\n"));
	er = gui->evtope->eventloop();
	DPRINT(("evt_loop exit : %d(%d)\n", er, er >> 16));

	// λ
	W	vgid;

	if (er >= ER_OK) {
		// 䵤ι(ｪλΤ)
		try {
			vgid = fsn->write_fusen(mydat.msg.msg, mydat.vid,true);
			endprc = false;
		} catch (EXCEPT_FUSEN& err) {
			er = err.get_err();
			DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
//			errpanel(DBOX::EPNL_FWRITE, er);
		}
	}

	if (vgid > 0) {
		// ɽƤƤ(ɽ˼Ԥ)
		RECT	r;
                
		gget_fra(vgid, &r);
		gfil_rec(vgid, r, WHITE0, 0, G_STORE);
		--r.c.right;
		--r.c.bottom;
		gdra_lin(vgid, r.p.lefttop, r.p.rightbot, 0x0001, BLACK100, G_STORE);
		try {
			// ϿβȤκ
			vobjs.del_allvobj();

			// Ȥɽ׵
			OPNDSP	odsp(vgid);

			odsp.main();
		} catch (...) {		// Ǥ⤤
			DPRINT(("opened virtual-object display error.\n"));
			;
		}
	}

	// Ȥν򤷤Ƥ饦ɥĤ
	gui->dest();

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
