//
//	appl_dsp.cc (Ȱ/application -Ȥɽư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"editobj.h"
#include	"opndsp.h"
#include	"fusen.h"


// ----------------------------------------------- I_DLED_DSPREQ  public ؿ
//
// constructor
//
I_DLED_DSPREQ::I_DLED_DSPREQ(const M_DISPREQ* msg)
	: rspflg(1)
{
	DPRINT(("I_DLED_DSPREQ constructor\n"));

	// μ
	mydat.msg.dspmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.lnk = msg->lnk;
	mydat.bgcol = msg->bgcol;
}


//
// destructor
//
I_DLED_DSPREQ::~I_DLED_DSPREQ()
{
	DPRINT(("I_DLED_DSPREQ destructor\n"));
	oend_req(mydat.vid, rspflg);
}


//
// application 
//
ERR	I_DLED_DSPREQ::main()
{
	ERR	er;
	W	vgid;

	er = ER_OK;
	vgid = mydat.msg.dspmsg->gid;

	// ɽƤƤ(ɽ˼Ԥ)
	RECT	r;

	gget_fra(vgid, &r);
	gfil_rec(vgid, r, WHITE0, 0, G_STORE);
	--r.c.right;
	--r.c.bottom;
	gdra_lin(vgid, r.p.lefttop, r.p.rightbot, 0x0001, BLACK100, G_STORE);

	try {
		// ɬפ class 
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		eobj = std::auto_ptr<EDITOBJ>(new EDITOBJ(&mydat.lnk));

		// ɽ
		OPNDSP	odsp(vgid);

		odsp.main();
		rspflg = 0;		// ɽƽλ
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_TADLOAD& err) {	// ¿Ȥɤ߹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJ& err) {	// ñ첾ȴϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_VOBJS& err) {	// ȷϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_OVDISP& err) {	// Ȥɽξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
