//
//	appl.h (Ȱ/application 𴴥إå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_I_DLED_APPL_H
#define	_I_DLED_APPL_H

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/vobj.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"vobjs.h"


//  class 
class	EDITOBJ;
class	FUSEN;
class	GUIOPE;
class	I_DLED_EXREQ;
class	I_DLED_PSTREQ;
class	I_DLED_DSPREQ;


// ---------------------------------------------------------- class I_DLED_APPL
// application δ class
class	I_DLED_APPL {
	typedef	struct {		//  application 
		W	pid;		//  PID
		W	vid;		// ư ID
		W	pwid;		// ưȤΤ WID
		RECT	pr;		// ưȤζΰ
		LINK	lnk;		// оݼ¿Ȥؤ LINK
		LINK	alnk;		//  application ¿
		COLOR	bgcol;		// طʿ
		union {			// ư message
			const	MESSAGE*	msg;	// 
			const	M_EXECREQ*	exmsg;	// ȤΥץư
			const	M_PASTEREQ*	pstmsg;	// ǡŽߵư
			const	M_FUSENREQ*	fsnmsg;	// 䵤Υץư
			const	M_DISPREQ*	dspmsg;	// Ȥɽư
			const	M_TADREQ*	tadmsg;	// TAD ǡư
		} msg;
	} MYDAT;

public:
	I_DLED_APPL();			// default constructor
	I_DLED_APPL(const MESSAGE* msg);	// copy constructor
	virtual	~I_DLED_APPL();		// destructor

	VOBJS	vobjs;			// ȴ
	std::auto_ptr<EDITOBJ>	eobj;	// Խоݼ¿ȴ
	std::auto_ptr<FUSEN>	fsn;	// 䵴
	std::auto_ptr<GUIOPE>	gui;	// GUI ɷϴ

	//  PID μ
	const	W	get_pid() {return mydat.pid;}

	// ư ID μ
	const	W	get_vid() {return mydat.vid;}

	// ưȤΤ window ID μ
	const	W	get_pwid() {return mydat.pwid;}

	// ưȤζȤμ
	const	RECT*	get_pr() {return &mydat.pr;}

	// оݼ¿Ȥؤ LINK μ
	const	LINK*	get_link() {return &mydat.lnk;}

	// طʿμ
	const	COLOR	get_bgcol() {return mydat.bgcol;}

	// ư message μ
	const	MESSAGE*	get_msg() {return mydat.msg.msg;}
	const	M_EXECREQ*	get_exmsg() {return mydat.msg.exmsg;}
	const	M_PASTEREQ*	get_pstmsg() {return mydat.msg.pstmsg;}
	const	M_FUSENREQ*	get_fsnmsg() {return mydat.msg.fsnmsg;}
	const	M_DISPREQ*	get_dspmsg() {return mydat.msg.dspmsg;}
	const	M_TADREQ*	get_tadmsg() {return mydat.msg.tadmsg;}

	// application 
	virtual	ERR	main() {return ER_OK;}

private:
	MYDAT	mydat;			//  application 

	friend	I_DLED_EXREQ;
	friend	I_DLED_PSTREQ;
	friend	I_DLED_DSPREQ;
};


// --------------------------------------------------------- class I_DLED_EXREQ
// ȤΥץưδ
class	I_DLED_EXREQ : public I_DLED_APPL {
public:
	I_DLED_EXREQ(const M_EXECREQ* msg);	// constructor
	~I_DLED_EXREQ();		// destructor

	// application 
	ERR	main();

private:
	bool	endprc;			// oend_prc() ȯԤɬ
};


// -------------------------------------------------------- class I_DLED_DSPREQ
// Ȥɽưδ
class	I_DLED_DSPREQ : public I_DLED_APPL {
public:
	I_DLED_DSPREQ(const M_DISPREQ* msg);	// constructor
	~I_DLED_DSPREQ();		// destructor

	// application 
	ERR	main();

private:
	W	rspflg;			// oend_req() ֤
};


// -------------------------------------------------------- class I_DLED_PSTREQ
// ǡŽߵưδ
class	I_DLED_PSTREQ : public I_DLED_APPL {
public:
	I_DLED_PSTREQ(const M_PASTEREQ* msg);	// constructor
	~I_DLED_PSTREQ();		// destructor

	// application 
	ERR	main();

private:
	W	rspflg;			// oend_req() ֤
	W	igid;			// Ķ ID
	W	iwid;			// ɥ ID
};

#endif	// _I_DLED_APPL_H
