//
//	main.cc (/ᥤ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/libapp.h>
#include	<btron/cnvend.h>
#include	<errcode.h>

#include	<new>

#include	"val.h"
#include	"dbox.h"
#include	"except.h"
#include	"err.h"
#include	"debug.h"

#include	"main.h"
#include	"appl.h"


// ؿץȥ
LOCAL	ERR	ex_main(const MESSAGE* msg);
LOCAL	VOID	errext_rsp(const MESSAGE* msg) throw();


// ѿ
EXPORT	IMGVIEW_APPL*	appl = NULL;	// application 


//
// ưˡγǧȴ
//
LOCAL	ERR	ex_main(const MESSAGE* msg)
{
	ERR	er;

	// little endian 
	bigEndian = False;   
 
	// Ūʽ
	getscreen();   
	initstdpnl();
	chg_wrk(NULL);
 
	// databox 򳫤
	LINK	lnk;

	prc_inf(0, PI_LINK, &lnk, sizeof(LINK));
	if (opendatabox(&lnk, DBOX::IMGVIEW_DTYP, DBOX::IMGVIEW_DNUM, 1) < ER_OK) {                                   
		throw EXCEPT_INITERR(IMGVIEWERR::DBOXOPEN);
	}

	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			DPRINT(("execution : EXECREQ\n"));
			if (((M_EXECREQ*)msg)->mode & 0x0002) {
				// ʪưξ
				oend_prc(((M_EXECREQ*)msg)->vid, NULL, 0);
				throw EXCEPT_EXECMSG(ER_NOSPT);
			} else {
				// ʪʳεưˡξ
				appl = new IMGVIEW_EXREQ((M_EXECREQ*)msg);
			}
			break;   
		case FUSENREQ:		// 䵤Υץư
			DPRINT(("execution : FUSENREQ\n"));
			oend_prc(((M_FUSENREQ*)msg)->vid, NULL, 0);
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
		case DISPREQ:		// Ȥɽư
			DPRINT(("execution : DISPREQ\n"));
			appl = new IMGVIEW_DSPREQ((M_DISPREQ*)msg);
			break;
		case PASTEREQ:		// ǡŽߵư
			DPRINT(("execution : PASTEREQ\n"));
			oend_req(((M_PASTEREQ*)msg)->vid, 1);
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
		case TADREQ:		// Ȥ TAD ǡư
			DPRINT(("execution : TADREQ\n"));
			appl = new IMGVIEW_TADREQ((M_TADREQ*)msg);
			break;
		default:		// ¾(cli ưʤ)
			DPRINT(("execution : other\n"));
			throw EXCEPT_EXECMSG(ER_NOSPT);
			break;
	}

	return er;
}


//
// ư error 
//
// oend_prc()  oend_req() ȯԤʤΤΤΤǤ
// application  class ˼Ԥ礬ӤǤ
//
LOCAL	VOID	errext_rsp(const MESSAGE* msg) throw()
{
	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			oend_prc(((M_EXECREQ*)msg)->vid, NULL, 0);
			break;
		case FUSENREQ:		// 䵤Υץư
			oend_prc(((M_FUSENREQ*)msg)->vid, NULL, 0);
			break;
		case DISPREQ:		// Ȥɽư
			oend_req(((M_DISPREQ*)msg)->vid, 1);
			break;
		case PASTEREQ:		// ǡŽߵư
			oend_req(((M_PASTEREQ*)msg)->vid, 1);
			break;
		case TADREQ:		// Ȥ TAD ǡư
			oend_req(((M_TADREQ*)msg)->vid, 1);
			break;
		default:		// ¾(cli ưʤ)
			break;		// äˤʤˤ⤷ʤ
	}

	return;
}


// ----------------------------------------------------------------------- MAIN
extern "C" W MAIN(MESSAGE* msg)
{
	ERR	er;
	IMPORT	ERR	_StartupError;

	if (_StartupError < ER_OK) {
		er = _StartupError;
		errext_rsp(msg);
		DPRINT(("WARNING : startup error : %d\n", er >> 16));
		goto EXIT;
	}
#ifdef	DEBUG
	malloctest(1);
#endif	// DEBUG
	try {
		ex_main(msg);		// ưˡγǧȴ
		er = appl->main();	// application μ¹
	} catch (EXCEPT_EXECMSG& err) {	// ưˡ
					// (application  class 
					//   OS ؤνλθˤ)
		er = err.get_err();
		DPRINT(("%s : %d\n", err.what(), er >> 16));
		errpanel(DBOX::EPNL_EXECMSG, er);
	} catch (EXCEPT_INITERR& err) {	// application νǤ㳰
					// (panelθˤΤ panel ̵)
					// (application  class ˤ
					//  Τ OS ؤνλΤ)
		er = err.get_err();
		DPRINT(("%s : %d\n", err.what(), er >> 16));
	} catch (std::bad_alloc) {
		DPRINT(("memory allocation error.\n"));
		errpanel(DBOX::EPNL_MEMORY, 0);	// ʤȤ⤢뤫
		er = ER_NOMEM;
		errext_rsp(msg);
	} catch (exception& err) {
		DPRINT(("other exception.\n"));
		errpanel(DBOX::EPNL_SYSTEM, 0);	// ʤȤ⤢뤫
		er = ER_SYS;
		errext_rsp(msg);
	} catch (...) {
		DPRINT(("unknown exception.\n"));
		errpanel(DBOX::EPNL_SYSTEM, 0);	// ʤȤ⤢뤫
		closedbox();
		er = ER_SYS;
		errext_rsp(msg);
	}
	closedbox();
	sysmsg(0);

EXIT:
	delete appl;			// application 𴴤Ѵ
	setpointer(PS_SELECT, NULL);
	DPRINT(("IMGVIEW exit code : %d(%d)\n", er, er >> 16));
#ifdef	DEBUG
	return er;
#else	// DEBUG
	ext_prc(er);
	return er;
#endif	// DEBUG
}
