//
//	imgope.cc (/ɽ)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/libapp.h>
#include	<libimg.h>
#include	<bstdlib.h>

#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"imgope.h"


// ¤
typedef	struct {			// ɤ߹߾(libimg )
	W	fd;			// ɤ߹߼¿Ȥ FD
	W	rofs;			// ¿Ȥ record offset
} READINF;


// ؿץȥ
LOCAL	WERR	grph_reafn(UB* bytes, UW reqsize, READINF* rinf) throw();


//
// ɤ߹ߴؿ(libimg )
//
LOCAL	WERR	grph_reafn(UB* bytes, UW reqsize, READINF* rinf) throw()
{
	WERR	rv;

	rv = ER_OK;

	if (reqsize > 0) {
		W	size;

		rv = rea_rec(rinf->fd,rinf->rofs,(B*)bytes,reqsize,&size,NULL);
		if (rv >= ER_OK) {
			if (size > reqsize) {
				size = reqsize;
			}
			rinf->rofs += size;

			rv = size;
		}
	}

	return rv;
}


// ----------------------------------------- IMGOPE  static member ѿμ
H	IMGOPE::opt_tbl[] = {		// IMG_COMPACT.opt  table
				LIBIMG_JPEG_OPT_DEFAULT,
				LIBIMG_PNG_OPT_DEFAULT,
				LIBIMG_BMP_OPT_DEFAULT
			};
H	IMGOPE::mthd_tbl[] = {		// IMG_COMPACT.method  table
				LIBIMG_METHOD_JPEG,
				LIBIMG_METHOD_PNG,
				LIBIMG_METHOD_BMP
			};


// ------------------------------------------------------ IMGOPE  public ؿ
//
// constructor
//
IMGOPE::IMGOPE(const LINK* lnk)
	: sgid(-1), dgid(-1), zfact(-1)
{
	DPRINT(("IMGOPE constructor\n"));

	GetStdCSPEC(&sc_spec, SCREEN.planes, SCREEN.pixbits);
	sbmp.pixbits = SCREEN.pixbits;
	sbmp.baseaddr[0] = NULL;
	dbmp.baseaddr[0] = NULL;
	drect = (RECT){{0, 0, 0, 0}};
	vrect = (RECT){{0, 0, 0, 0}};

	// оݲμ¿Ȥ򳫤
	READINF	rinf;

	rinf.fd = opn_fil((LINK*)lnk, F_READ, NULL);
	if (rinf.fd < ER_OK) {
		throw EXCEPT_IMGOPE(rinf.fd);
	}

	// ѥ᡼ν
	IMG_BMP	ibmp;
	IMG_COMPACT	icmp;

	ibmp.bmap = &sbmp;
	ibmp.funcptr = reinterpret_cast<FUNCP>(&grph_reafn);
	ibmp.io_src = reinterpret_cast<VOID*>(&rinf);
	ibmp.color_spec = &sc_spec;

	// ɤ߹(retry ˷ѤƤ)
	W	l;
	ERR	er;

	for (l = 0, er = -1; (l < TYPE_MAX) && (er < ER_OK); ++l) {
		rinf.rofs = 0;
		icmp.opt = opt_tbl[l];
		icmp.method = mthd_tbl[l];

		er = libimg_rea_bmp(&ibmp, &icmp);
	}
	cls_fil(rinf.fd);
	if (er < ER_OK) {
		// ɤɤǤɤ߹ʤä
		throw EXCEPT_IMGOPE(er);
	}

	// ɤ줫ɤ߹᤿ΤǻĤν򤹤
	DPRINT(("type : %d\n", l - 1));
	sgid = gopn_mem(NULL, &sbmp, (B*)&sc_spec);
	if (sgid < ER_OK) {
		throw EXCEPT_IMGOPE(sgid);
	}
}


//
// destructor
//
IMGOPE::~IMGOPE()
{
	DPRINT(("IMGOPE destructor\n"));
	if (sgid >= 0) {
		gcls_env(sgid);
	}
	if (sbmp.baseaddr[0] != NULL) {
		free(sbmp.baseaddr[0]);
	}
	if (dgid >= 0) {
		gcls_env(dgid);
	}
	if (dbmp.baseaddr[0] != NULL) {
		free(dbmp.baseaddr[0]);
	}
}


//
// μ
//
//	gid   :  gid(< 0 ξϲΤ)
//	vr    : ζ
//	dr    : ΰ
//	vp    : (κ)
//	zfact : Ψ(1000 = 100.0[%])
//
void	IMGOPE::disp_grph(W gid, RECT vr, RECT dr, PNT vp, W dzfact)
{
	if ((!(equalrect(vr, vrect))) ||
	    ((vp.x != drect.c.left) || (vp.y != drect.c.top)) ||
	    (dzfact != zfact) ||
	    (dbmp.baseaddr[0] == NULL)) {
		// ɽƤѴ
		if (dgid >= 0) {
			gcls_env(dgid);
			dgid = -1;
		}
		if (dbmp.baseaddr[0] != NULL) {
			free(dbmp.baseaddr[0]);
			dbmp.baseaddr[0] = NULL;
		}

		// 򤹤
		W	w;
		W	h;
		W	vw;
		W	vh;

		w = ((rectwidth(vr) * 1000) / dzfact) + 1;
		h = ((rectheight(vr) * 1000) / dzfact) + 1;
		vw = w * dzfact / 1000;
		vh = h * dzfact / 1000;

		drect.p.lefttop = vp;
		drect.c.right = drect.c.left + w;
		drect.c.bottom = drect.c.top + h;

		dbmp.planes = sbmp.planes;
		dbmp.pixbits = sbmp.pixbits;
		dbmp.rowbytes = ((((sbmp.pixbits >> 8) * vw) + 15) >> 4) << 1;
		dbmp.bounds = (RECT){{0, 0, vw, vh}};
		dbmp.baseaddr[0] = static_cast<UB*>(malloc(dbmp.rowbytes*vh));
		if (dbmp.baseaddr[0] == NULL) {
			throw EXCEPT_IMGOPE(ER_NOMEM);
		}

		dgid = gopn_mem(NULL, &dbmp, (B*)&sc_spec);
		if (dgid < ER_OK) {
			throw EXCEPT_IMGOPE(dgid);
		}

				// ɽΰطʤɤĤ֤
		gfil_rec(dgid, dbmp.bounds, WHITE0, 0, G_STORE);
		gcop_bmp(sgid, &drect, dgid, &dbmp.bounds, NULL, G_STORE);
	}

	// ɽν򵭲
	vrect = vr;
	zfact = dzfact;

	// ɽ
	if (gid >= 0) {	
		gcop_bmp(dgid, &dr, gid, &dr, NULL, G_STORE);
	}
	
	return;
}
