//
//	fusen.cc (/䵴)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/cnvend.h>

#include	"struct.h"
#include	"err.h"
#include	"except.h"
#include	"macro.h"

#include	"fusen.h"


// ------------------------------------------------------- FUSEN  public ؿ
//
// constructor
//
FUSEN::FUSEN(const MESSAGE* msg)
{
	UH*	ptr;			// omgr Ƥ pointer
	IMGVIEW_FUSEN	buf;
	const	M_EXECREQ*	exreq =reinterpret_cast<const M_EXECREQ*>(msg);

	fsn = DEF_FUSEN;

	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			if ((exreq->mode & 0x03) != 0x00) {
				// 䵸ͭǡɤ߹
				W	fd;
				WERR	rv;

				fd = opn_fil((LINK*)&exreq->lnk, F_READ, NULL);
				if (fd < ER_OK) {
					throw EXCEPT_FUSEN(fd);
				}
				rv = oget_fsn(exreq->vid, fd, &buf, sizeof(IMGVIEW_FUSEN));
				cls_fil(fd);
				if (rv < ER_OK) {
					throw EXCEPT_FUSEN(rv);
				}
				break;
			}
		case DISPREQ:		// Ȥɽư
		case TADREQ:		// Ȥ TAD ǡư
		case PASTEREQ:		// ǡŽߵư
			ptr = reinterpret_cast<UH*>(exreq->info);
			goto GET_DATA;
		case FUSENREQ:		// 䵤Υץư
			ptr = reinterpret_cast<UH*>((reinterpret_cast<const M_FUSENREQ*>(msg))->info);
GET_DATA:
			// ¿Ȳȥޥ͡δ
			W	size;	// omgr Ƥ礭(byte ñ)

			size = *ptr + sizeof(UH);
			if (size > sizeof(IMGVIEW_FUSEN)) {
				// ϰϤĶƤϼФʤ
				size = sizeof(IMGVIEW_FUSEN);
			}
			memcpy(&buf, ptr, size);
			break;
		default:		// cli ưʤɤΤ¾ξ
			// ä˲⤷ʤ
			break;
	}

	// 䵤Ǥγǧ䵤ɤ߹(ɤƤʤнͤΤޤ)
	if ((buf.dlen >= IMGVIEW_FUSEN_DLEN) &&
	    (ConvEndianH(buf.ver) == IMGVIEW_FUSEN_VERSION)) {
		ConvEndianStruct(&fsn, &buf, IMGVIEW_FUSEN_STRUCT, sizeof(IMGVIEW_FUSEN));
	}

	// Ƥ򵭲Ƥ
	org = fsn;
}


//
// destructor
//
FUSEN::~FUSEN()
{
}


//
// 䵤ؤν񤭹
//
W	FUSEN::write_fusen(const MESSAGE* msg, W vid)
{
	W	upd;
	W	vgid;

	upd = (memcmp(&fsn, &org, sizeof(IMGVIEW_FUSEN)) != 0) ? 1 : 0;
	vgid = 0;

	switch (msg->msg_type) {
		case EXECREQ:		// ȤΥץư
			if (upd == 1) {
				// 䵤ι
				W	fd;
				const	M_EXECREQ*	exreq = reinterpret_cast<const M_EXECREQ*>(msg);

				fd = opn_fil((LINK*)&exreq->lnk,F_UPDATE,NULL);
				if (fd < ER_OK) {
					throw EXCEPT_FUSEN(fd);
				}
				fsn.dlen = IMGVIEW_FUSEN_DLEN;
				oput_fsn(vid, fd, &fsn);
				cls_fil(fd);
			}
		case FUSENREQ:		// 䵤Υץư
			vgid = oend_prc(vid, &fsn, upd);
			break;
		case DISPREQ:		// Ȥɽư
		case TADREQ:		// Ȥ TAD ǡư
		case PASTEREQ:		// ǡŽߵư
			// ä˲⤷ʤ
			break;
		default:		// cli ưʤɤΤ¾ξ
			// ä˲⤷ʤ
			break;
	}

	return vgid;
}
