//
//	appl_tad.cc (/application -ȤTAD dataư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"imgope.h"
#include	"fusen.h"
#include	"savedat.h"
#include	"misc.h"


// ---------------------------------------------- IMGVIEW_TADREQ  public ؿ
//
// constructor
//
IMGVIEW_TADREQ::IMGVIEW_TADREQ(const M_TADREQ* msg)
	: rspflg(1)
{
	DPRINT(("IMGVIEW_TADREQ constructor\n"));

	// μ
	mydat.msg.tadmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.lnk = msg->lnk;
}


//
// destructor
//
IMGVIEW_TADREQ::~IMGVIEW_TADREQ()
{
	DPRINT(("IMGVIEW_TADREQ destructor\n"));
	oend_req(mydat.vid, rspflg);
}


//
// application 
//
ERR	IMGVIEW_TADREQ::main()
{
	ERR	er;

	er = ER_OK;

	// ɬפ class 
        try {
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		load_img();

		// 
		UW	zfact = static_cast<UW>(fsn->get_zfact());
 
		MISC::zfact_to_tbl(zfact);
		img->disp_grph(-1, mydat.msg.tadmsg->r, mydat.msg.tadmsg->r, fsn->get_vpos(), zfact);

		// ¸γ
		SAVEDAT	save(&mydat.msg.tadmsg->save);

		save.main(img->get_dbmp(), img->get_cspec());
		rspflg = 0;		// ¸ƽλ
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_IMGOPE& err) {	// ɤ߹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_SAVEDAT& err) {	// ¸ϤǤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
