//
//	appl_dsp.cc (/application -Ȥɽư)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#include	<basic.h>
#include	<btron/btron.h>
#include	<btron/dp.h>
#include	<btron/hmi.h>
#include	<btron/vobj.h>
#include	<btron/libapp.h>
#include	<errcode.h>

#include	<new>
#include	<memory>

#include	"val.h"
#include	"err.h"
#include	"except.h"
#include	"debug.h"

#include	"appl.h"
#include	"opndsp.h"
#include	"imgope.h"
#include	"fusen.h"
#include	"misc.h"


// ---------------------------------------------- IMGVIEW_DSPREQ  public ؿ
//
// constructor
//
IMGVIEW_DSPREQ::IMGVIEW_DSPREQ(const M_DISPREQ* msg)
	: rspflg(1)
{
	DPRINT(("IMGVIEW_DSPREQ constructor\n"));

	// μ
	mydat.msg.dspmsg = msg;
	mydat.vid = msg->vid;
	mydat.pwid = msg->pwid;
	mydat.lnk = msg->lnk;
}


//
// destructor
//
IMGVIEW_DSPREQ::~IMGVIEW_DSPREQ()
{
	DPRINT(("IMGVIEW_DSPREQ destructor\n"));
	oend_req(mydat.vid, rspflg);
}


//
// application 
//
ERR	IMGVIEW_DSPREQ::main()
{
	ERR	er;

	er = ER_OK;

	// ɬפ class 
	try {
		fsn = std::auto_ptr<FUSEN>(new FUSEN(mydat.msg.msg));
		load_img();

		// ɽ
		OPNDSP	odsp(mydat.msg.dspmsg->gid);

		odsp.main();
		rspflg = 0;		// ɽƽλ
	} catch (EXCEPT_FUSEN& err) {	// 䵤ɤ߹߾㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_IMGOPE& err) {	// ɤ߹ߤξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (EXCEPT_OVDISP& err) {	// Ȥɽξ㳲
		er = err.get_err();
		DPRINT(("%s : %d(%d)\n", err.what(), er, er >> 16));
		throw EXCEPT_INITERR(er);
	} catch (std::bad_alloc) {	// ­
		DPRINT(("memory allocation error.\n"));
		throw EXCEPT_INITERR(ER_NOMEM);
	} catch (...) {			// 
		throw;
	}

	setpointer(PS_SELECT, NULL);
	DPRINT(("appl exit : %d(%d)\n", er, er >> 16));
	return er;
}
