//
//	appl.h (/application 𴴥إå)
//
//	(C) Copyright 2002 by Personal Media Corporation.
//

#ifndef	_IMGVIEW_APPL_H
#define	_IMGVIEW_APPL_H

#include	<basic.h>
#include	<btron/btron.h>
#include	<errcode.h>

#include	<new>
#include	<memory>


//  class 
class	IMGOPE;
class	FUSEN;
class	GUIOPE;
class	IMGVIEW_EXREQ;
class	IMGVIEW_DSPREQ;
class	IMGVIEW_TADREQ;


// --------------------------------------------------------- class IMGVIEW_APPL
// application δ class
class	IMGVIEW_APPL {
	typedef	struct {		//  application 
		W	pid;		//  PID
		W	vid;		// ư ID
		W	pwid;		// ưȤΤ WID
		RECT	pr;		// ưȤζΰ
		LINK	lnk;		// оݼ¿Ȥؤ LINK
		LINK	alnk;		//  application ¿
		union {			// ư message
			const	MESSAGE*	msg;	// 
			const	M_EXECREQ*	exmsg;	// ȤΥץư
			const	M_PASTEREQ*	pstmsg;	// ǡŽߵư
			const	M_FUSENREQ*	fsnmsg;	// 䵤Υץư
			const	M_DISPREQ*	dspmsg;	// Ȥɽư
			const	M_TADREQ*	tadmsg;	// TAD ǡư
		} msg;
	} MYDAT;

public:
	IMGVIEW_APPL();			// default constructor
	IMGVIEW_APPL(const MESSAGE* msg);	// copy constructor
	virtual	~IMGVIEW_APPL();		// destructor

	IMGOPE*	img;			// ɽ
	std::auto_ptr<FUSEN>	fsn;	// 䵴
	std::auto_ptr<GUIOPE>	gui;	// GUI ɷϴ

	//  PID μ
	const	W	get_pid() {return mydat.pid;}

	// ư ID μ
	const	W	get_vid() {return mydat.vid;}

	// ưȤΤ window ID μ
	const	W	get_pwid() {return mydat.pwid;}

	// ưȤζȤμ
	const	RECT*	get_pr() {return &mydat.pr;}

	// оݼ¿Ȥؤ LINK μ
	const	LINK*	get_link() {return &mydat.lnk;}

	// ư message μ
	const	MESSAGE*	get_msg() {return mydat.msg.msg;}
	const	M_EXECREQ*	get_exmsg() {return mydat.msg.exmsg;}
	const	M_PASTEREQ*	get_pstmsg() {return mydat.msg.pstmsg;}
	const	M_FUSENREQ*	get_fsnmsg() {return mydat.msg.fsnmsg;}
	const	M_DISPREQ*	get_dspmsg() {return mydat.msg.dspmsg;}
	const	M_TADREQ*	get_tadmsg() {return mydat.msg.tadmsg;}

	// application 
	virtual	ERR	main() {return ER_OK;}

	// ɽɤ߹
	void	load_img();

private:
	MYDAT	mydat;			//  application 

	friend	IMGVIEW_EXREQ;
	friend	IMGVIEW_DSPREQ;
	friend	IMGVIEW_TADREQ;
};


// -------------------------------------------------------- class IMGVIEW_EXREQ
// ȤΥץưδ
class	IMGVIEW_EXREQ : public IMGVIEW_APPL {
public:
	IMGVIEW_EXREQ(const M_EXECREQ* msg);	// constructor
	~IMGVIEW_EXREQ();		// destructor

	// application 
	ERR	main();

private:
	bool	endprc;			// oend_prc() ȯԤɬ
};


// ------------------------------------------------------- class IMGVIEW_DSPREQ
// Ȥɽưδ
class	IMGVIEW_DSPREQ : public IMGVIEW_APPL {
public:
	IMGVIEW_DSPREQ(const M_DISPREQ* msg);	// constructor
	~IMGVIEW_DSPREQ();		// destructor

	// application 
	ERR	main();

private:
	W	rspflg;			// oend_req() ֤
};


// ------------------------------------------------------- class IMGVIEW_TADREQ
// Ȥ TAD ǡưδ
class	IMGVIEW_TADREQ : public IMGVIEW_APPL {
public:
	IMGVIEW_TADREQ(const M_TADREQ* msg);	// constructor
	~IMGVIEW_TADREQ();		// destructor

	// application 
	ERR	main();

private:
	W	rspflg;			// oend_req() ֤
};

#endif	// _IMGVIEW_APPL_H
